/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.gradleplugin.testacceleration.internal.task;

import com.gradle.obfuscation.Keep;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.process.CommandLineArgumentProvider;

@Keep
abstract class GradleDistribution
implements CommandLineArgumentProvider {
    private final Path gradleHome;

    private GradleDistribution(Path path) {
        this.gradleHome = path;
    }

    @Classpath
    public Set<File> getLibs() {
        return this.getJarsIn("lib");
    }

    @Classpath
    public Set<File> getAgents() {
        return this.getJarsIn("lib/agents");
    }

    @Classpath
    public Set<File> getPlugins() {
        return this.getJarsIn("lib/plugins");
    }

    private Set<File> getJarsIn(String string) {
        Path path = this.gradleHome.resolve(string);
        return GradleDistribution.asSortedSet(this.fileTree(path, (Action<? super ConfigurableFileTree>)((Action)configurableFileTree -> configurableFileTree.include(new String[]{"*.jar"}))));
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getStaticContent() {
        return this.fileTree(this.gradleHome, (Action<? super ConfigurableFileTree>)((Action)configurableFileTree -> {
            configurableFileTree.exclude(new String[]{"lib/**"});
            configurableFileTree.exclude(new String[]{"samples/**"});
            configurableFileTree.exclude(new String[]{"src/**"});
            configurableFileTree.exclude(new String[]{"docs/**"});
            configurableFileTree.exclude(new String[]{"getting-started.html"});
        }));
    }

    protected abstract ConfigurableFileTree fileTree(Path var1, Action<? super ConfigurableFileTree> var2);

    private static SortedSet<File> asSortedSet(ConfigurableFileTree configurableFileTree) {
        return new TreeSet<File>(configurableFileTree.getFiles());
    }

    public Iterable<String> asArguments() {
        return Collections.emptyList();
    }

    public static GradleDistribution create(Path path, Project project) {
        return com.gradle.develocity.agent.gradle.internal.c.b.c() ? new b(path, project.getObjects()) : new a(path, project);
    }

    private static class b
    extends GradleDistribution {
        private final ObjectFactory a;

        b(Path path, ObjectFactory objectFactory) {
            super(path);
            this.a = objectFactory;
        }

        @Override
        protected ConfigurableFileTree fileTree(Path path, Action<? super ConfigurableFileTree> action) {
            ConfigurableFileTree configurableFileTree = this.a.fileTree().from((Object)path);
            action.execute((Object)configurableFileTree);
            return configurableFileTree;
        }
    }

    private static class a
    extends GradleDistribution {
        private final Project a;

        a(Path path, Project project) {
            super(path);
            this.a = project;
        }

        @Override
        protected ConfigurableFileTree fileTree(Path path, Action<? super ConfigurableFileTree> action) {
            return this.a.fileTree((Object)path, action);
        }
    }
}

