/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.gradle;

import com.gradle.develocity.DevelocityException;
import com.gradle.develocity.agent.gradle.DevelocityConfiguration;
import com.gradle.develocity.agent.gradle.internal.DevelocityConfigurationInternal;
import com.gradle.enterprise.gradleplugin.GradleEnterprisePlugin;
import com.gradle.obfuscation.Keep;
import com.gradle.scan.plugin.BuildScanPlugin;
import com.gradle.scan.plugin.internal.meta.CurrentBuildAgentVersion;
import com.gradle.scan.plugin.internal.reflect.c;
import com.gradle.scan.plugin.internal.v;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginAware;
import org.gradle.util.GradleVersion;

public class DevelocityPlugin
implements Plugin<Object> {
    private static final Logger a = Logging.getLogger(DevelocityPlugin.class);

    @Keep
    public void apply(Object object) {
        if (object instanceof Settings) {
            DevelocityPlugin.a((Settings)object);
        } else if (object instanceof Project) {
            DevelocityPlugin.a((Project)object);
        } else {
            throw new DevelocityException("The Develocity plugin must be applied to the root project (for Gradle 5.x) or settings (for Gradle 6.0 and later)");
        }
    }

    private static void a(Settings settings) {
        DevelocityPlugin.a(settings, GradleEnterprisePlugin.class);
        DevelocityPlugin.a(settings, "com.gradle.enterprise", "Gradle Enterprise");
    }

    private static void a(Project project) {
        DevelocityPlugin.b();
        DevelocityPlugin.a(project, BuildScanPlugin.class);
        DevelocityPlugin.a(project, "com.gradle.build-scan", "build scan");
    }

    private static void b() {
        if (GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"6.0")) >= 0) {
            throw new DevelocityException("The Develocity plugin must be applied to the settings (was applied to a project)");
        }
    }

    private static <T extends PluginAware & ExtensionAware, P extends Plugin<Object>> void a(T t2, Class<P> clazz) {
        System.setProperty("com.gradle.develocity.applied-deprecated-plugin", "true");
        t2.getPlugins().apply(clazz);
        DevelocityConfigurationInternal develocityConfigurationInternal = (DevelocityConfigurationInternal)((ExtensionAware)t2).getExtensions().findByType(DevelocityConfiguration.class);
        if (develocityConfigurationInternal != null) {
            develocityConfigurationInternal.getBuildScan().getDevelocityPluginApplied().set((Object)true);
        }
    }

    private static <T extends PluginAware & ExtensionAware> void a(T t2, String string, String string2) {
        t2.getPlugins().withId(string, plugin -> {
            try {
                if (!DevelocityPlugin.a()) {
                    GradleVersion gradleVersion;
                    Class<?> clazz = c.a(CurrentBuildAgentVersion.class.getName(), plugin.getClass().getClassLoader());
                    String string2 = c.a(clazz, "get", Object.class, new Class[0]).a(new Object[0]).toString();
                    int n2 = string2.indexOf("-");
                    if (n2 > 0) {
                        string2 = string2.substring(0, n2);
                    }
                    if ((gradleVersion = GradleVersion.version((String)string2).getBaseVersion()).compareTo(GradleVersion.version((String)"3.17")) < 0) {
                        a.warn(v.a("", "WARNING: Deprecated " + string2 + " plugin [version: " + string2 + "] was applied alongside Develocity plugin.", "If your build uses the latest Develocity functionality, it may fail or not run as expected since the deprecated plugin may not support requested features.", "The simultaneous application of Develocity and " + string2 + " plugins will cause the build to fail in a future release of the Develocity plugin."));
                    }
                }
            }
            catch (Exception exception) {
                a.info("Could not determine the location of the applied legacy plugin", (Throwable)exception);
            }
        });
    }

    public static boolean a() {
        GradleVersion gradleVersion = GradleVersion.current().getBaseVersion();
        if (gradleVersion.compareTo(GradleVersion.version((String)"7.4")) >= 0) {
            String string = System.getProperty("com.gradle.scan.multi-application");
            return string != null && (string.isEmpty() || "true".equalsIgnoreCase(string));
        }
        return false;
    }
}

