/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.software.os;

import com.gradle.scan.plugin.internal.dep.oshi.software.os.OSProcess;
import com.gradle.scan.plugin.internal.dep.oshi.util.Util;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;

public interface OperatingSystem {
    public List<OSProcess> getProcesses(Predicate<OSProcess> var1, Comparator<OSProcess> var2, int var3);

    public int getProcessId();

    public static final class ProcessFiltering {
        public static final Predicate<OSProcess> ALL_PROCESSES = oSProcess -> true;
        public static final Predicate<OSProcess> VALID_PROCESS = oSProcess -> !oSProcess.getState().equals((Object)OSProcess.State.INVALID);
        public static final Predicate<OSProcess> NO_PARENT = oSProcess -> oSProcess.getParentProcessID() == oSProcess.getProcessID();
        public static final Predicate<OSProcess> BITNESS_64 = oSProcess -> oSProcess.getBitness() == 64;
        public static final Predicate<OSProcess> BITNESS_32 = oSProcess -> oSProcess.getBitness() == 32;
    }

    public static class OSVersionInfo {
        private final String version;
        private final String codeName;
        private final String buildNumber;
        private final String versionStr;

        public OSVersionInfo(String string, String string2, String string3) {
            this.version = string;
            this.codeName = string2;
            this.buildNumber = string3;
            StringBuilder stringBuilder = new StringBuilder(this.getVersion() != null ? this.getVersion() : "unknown");
            if (!Util.isBlank(this.getCodeName())) {
                stringBuilder.append(" (").append(this.getCodeName()).append(')');
            }
            if (!Util.isBlank(this.getBuildNumber())) {
                stringBuilder.append(" build ").append(this.getBuildNumber());
            }
            this.versionStr = stringBuilder.toString();
        }

        public String getVersion() {
            return this.version;
        }

        public String getCodeName() {
            return this.codeName;
        }

        public String getBuildNumber() {
            return this.buildNumber;
        }

        public String toString() {
            return this.versionStr;
        }
    }

    public static final class ProcessSorting {
        public static final Comparator<OSProcess> NO_SORTING = (oSProcess, oSProcess2) -> 0;
        public static final Comparator<OSProcess> CPU_DESC = Comparator.comparingDouble(OSProcess::getProcessCpuLoadCumulative).reversed();
        public static final Comparator<OSProcess> RSS_DESC = Comparator.comparingLong(OSProcess::getResidentSetSize).reversed();
        public static final Comparator<OSProcess> UPTIME_ASC = Comparator.comparingLong(OSProcess::getUpTime);
        public static final Comparator<OSProcess> UPTIME_DESC = UPTIME_ASC.reversed();
        public static final Comparator<OSProcess> PID_ASC = Comparator.comparingInt(OSProcess::getProcessID);
        public static final Comparator<OSProcess> PARENTPID_ASC = Comparator.comparingInt(OSProcess::getParentProcessID);
        public static final Comparator<OSProcess> NAME_ASC = Comparator.comparing(OSProcess::getName, String.CASE_INSENSITIVE_ORDER);
    }
}

