/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestNames;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.Junit5TestFrameworkStrategy;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.JunitTestFrameworkStrategy;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.TestNgTestFrameworkStrategy;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.testsreader.TestsReader;
import java.io.File;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestFramework;
import org.gradle.api.internal.tasks.testing.junitplatform.JUnitPlatformTestFramework;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestFramework;
import org.gradle.util.GradleVersion;

public interface TestFrameworkStrategy {
    public static final Pattern SPOCK2_CORE_JAR_NAME_PATTERN = Pattern.compile(".*/spock-core-2[^/]*\\.jar");

    @Nullable
    public static TestFrameworkStrategy of(JvmTestExecutionSpec jvmTestExecutionSpec) {
        TestFramework testFramework = jvmTestExecutionSpec.getTestFramework();
        if (testFramework instanceof JUnitTestFramework) {
            return new JunitTestFrameworkStrategy();
        }
        if (testFramework instanceof JUnitPlatformTestFramework) {
            return new Junit5TestFrameworkStrategy(TestFrameworkStrategy.isSpock2Used(jvmTestExecutionSpec));
        }
        if (testFramework instanceof TestNGTestFramework) {
            return new TestNgTestFrameworkStrategy();
        }
        return null;
    }

    public static boolean isSpock2Used(JvmTestExecutionSpec jvmTestExecutionSpec) {
        return TestFrameworkStrategy.isSpock2JarOnPath(jvmTestExecutionSpec.getClasspath()) || TestFrameworkStrategy.supportsJavaModules() && TestFrameworkStrategy.isSpock2JarOnPath(jvmTestExecutionSpec.getModulePath());
    }

    public static boolean supportsJavaModules() {
        return TestFrameworkStrategy.gradleVersionIsAtLeast("6.4");
    }

    public static boolean isSpock2JarOnPath(Iterable<? extends File> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).anyMatch(TestFrameworkStrategy::isSpock2CoreJar);
    }

    public static boolean isSpock2CoreJar(File file) {
        return SPOCK2_CORE_JAR_NAME_PATTERN.matcher(file.getAbsolutePath()).matches();
    }

    public static boolean gradleVersionIsAtLeast(String string) {
        return GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)string)) >= 0;
    }

    public boolean isLifecycleFailureTest(TestsReader var1, String var2, String var3);

    public TestFramework createRetrying(TestFrameworkTemplate var1, TestFramework var2, TestNames var3, Set<String> var4);

    default public boolean isExpectedUnretriedTest(String string, String string2) {
        return false;
    }
}

