/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.protocol;

import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpConnection;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpHost;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpRequest;
import com.gradle.scan.plugin.internal.dep.org.apache.http.protocol.BasicHttpContext;
import com.gradle.scan.plugin.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;

public class HttpCoreContext
implements HttpContext {
    private final HttpContext context;

    public static HttpCoreContext adapt(HttpContext httpContext) {
        Args.notNull(httpContext, "HTTP context");
        return httpContext instanceof HttpCoreContext ? (HttpCoreContext)httpContext : new HttpCoreContext(httpContext);
    }

    public HttpCoreContext(HttpContext httpContext) {
        this.context = httpContext;
    }

    public HttpCoreContext() {
        this.context = new BasicHttpContext();
    }

    @Override
    public Object getAttribute(String string) {
        return this.context.getAttribute(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.context.setAttribute(string, object);
    }

    public <T> T getAttribute(String string, Class<T> clazz) {
        Args.notNull(clazz, "Attribute class");
        Object object = this.getAttribute(string);
        if (object == null) {
            return null;
        }
        return clazz.cast(object);
    }

    public HttpConnection getConnection() {
        return this.getAttribute("http.connection", HttpConnection.class);
    }

    public HttpRequest getRequest() {
        return this.getAttribute("http.request", HttpRequest.class);
    }

    public boolean isRequestSent() {
        Boolean bl2 = this.getAttribute("http.request_sent", Boolean.class);
        return bl2 != null && bl2 != false;
    }

    public HttpHost getTargetHost() {
        return this.getAttribute("http.target_host", HttpHost.class);
    }
}

