/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http;

import com.gradle.scan.plugin.internal.dep.io.netty.util.AsciiString;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.MathUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;

public class HttpMethod
implements Comparable<HttpMethod> {
    public static final HttpMethod OPTIONS = new HttpMethod("OPTIONS");
    public static final HttpMethod GET = new HttpMethod("GET");
    public static final HttpMethod HEAD = new HttpMethod("HEAD");
    public static final HttpMethod POST = new HttpMethod("POST");
    public static final HttpMethod PUT = new HttpMethod("PUT");
    public static final HttpMethod PATCH = new HttpMethod("PATCH");
    public static final HttpMethod DELETE = new HttpMethod("DELETE");
    public static final HttpMethod TRACE = new HttpMethod("TRACE");
    public static final HttpMethod CONNECT = new HttpMethod("CONNECT");
    private static final EnumNameMap<HttpMethod> methodMap = new EnumNameMap(new EnumNameMap.Node<HttpMethod>(OPTIONS.toString(), OPTIONS), new EnumNameMap.Node<HttpMethod>(GET.toString(), GET), new EnumNameMap.Node<HttpMethod>(HEAD.toString(), HEAD), new EnumNameMap.Node<HttpMethod>(POST.toString(), POST), new EnumNameMap.Node<HttpMethod>(PUT.toString(), PUT), new EnumNameMap.Node<HttpMethod>(PATCH.toString(), PATCH), new EnumNameMap.Node<HttpMethod>(DELETE.toString(), DELETE), new EnumNameMap.Node<HttpMethod>(TRACE.toString(), TRACE), new EnumNameMap.Node<HttpMethod>(CONNECT.toString(), CONNECT));
    private final AsciiString name;

    public HttpMethod(String string) {
        string = ObjectUtil.checkNonEmptyAfterTrim(string, "name");
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!Character.isISOControl(c2) && !Character.isWhitespace(c2)) continue;
            throw new IllegalArgumentException("invalid character in name");
        }
        this.name = AsciiString.cached(string);
    }

    public String name() {
        return this.name.toString();
    }

    public AsciiString asciiName() {
        return this.name;
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HttpMethod)) {
            return false;
        }
        HttpMethod httpMethod = (HttpMethod)object;
        return this.name().equals(httpMethod.name());
    }

    public String toString() {
        return this.name.toString();
    }

    @Override
    public int compareTo(HttpMethod httpMethod) {
        if (httpMethod == this) {
            return 0;
        }
        return this.name().compareTo(httpMethod.name());
    }

    private static final class EnumNameMap<T> {
        private final Node<T>[] values;
        private final int valuesMask;

        EnumNameMap(Node<T> ... nodeArray) {
            this.values = new Node[MathUtil.findNextPositivePowerOfTwo(nodeArray.length)];
            this.valuesMask = this.values.length - 1;
            for (Node<T> node : nodeArray) {
                int n2 = EnumNameMap.hashCode(node.key) & this.valuesMask;
                if (this.values[n2] != null) {
                    throw new IllegalArgumentException("index " + n2 + " collision between values: [" + this.values[n2].key + ", " + node.key + ']');
                }
                this.values[n2] = node;
            }
        }

        private static int hashCode(String string) {
            return string.hashCode() >>> 6;
        }

        private static final class Node<T> {
            final String key;
            final T value;

            Node(String string, T t2) {
                this.key = string;
                this.value = t2;
            }
        }
    }
}

