/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.channel.embedded;

import com.gradle.scan.plugin.internal.dep.io.netty.channel.AbstractChannel;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.Channel;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandler;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelId;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelInitializer;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelMetadata;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelOutboundBuffer;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.DefaultChannelConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.DefaultChannelPipeline;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.EventLoop;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.RecvByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.embedded.EmbeddedChannelId;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.embedded.EmbeddedEventLoop;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.embedded.EmbeddedSocketAddress;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

public class EmbeddedChannel
extends AbstractChannel {
    private static final SocketAddress LOCAL_ADDRESS = new EmbeddedSocketAddress();
    private static final SocketAddress REMOTE_ADDRESS = new EmbeddedSocketAddress();
    private static final ChannelHandler[] EMPTY_HANDLERS = new ChannelHandler[0];
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EmbeddedChannel.class);
    private static final ChannelMetadata METADATA_NO_DISCONNECT = new ChannelMetadata(false);
    private static final ChannelMetadata METADATA_DISCONNECT = new ChannelMetadata(true);
    private final EmbeddedEventLoop loop = new EmbeddedEventLoop();
    private final ChannelFutureListener recordExceptionListener = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            EmbeddedChannel.this.recordException(channelFuture);
        }
    };
    private final ChannelMetadata metadata;
    private final ChannelConfig config;
    private Queue<Object> inboundMessages;
    private Queue<Object> outboundMessages;
    private Throwable lastException;
    private State state;

    public EmbeddedChannel() {
        this(EMPTY_HANDLERS);
    }

    public EmbeddedChannel(ChannelHandler ... channelHandlerArray) {
        this(EmbeddedChannelId.INSTANCE, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, ChannelHandler ... channelHandlerArray) {
        this(channelId, false, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl2, ChannelHandler ... channelHandlerArray) {
        this(channelId, true, bl2, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl2, boolean bl3, ChannelHandler ... channelHandlerArray) {
        this(null, channelId, bl2, bl3, channelHandlerArray);
    }

    public EmbeddedChannel(Channel channel, ChannelId channelId, boolean bl2, boolean bl3, ChannelHandler ... channelHandlerArray) {
        super(channel, channelId);
        this.metadata = EmbeddedChannel.metadata(bl3);
        this.config = new DefaultChannelConfig(this);
        this.setup(bl2, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl2, ChannelConfig channelConfig, ChannelHandler ... channelHandlerArray) {
        super(null, channelId);
        this.metadata = EmbeddedChannel.metadata(bl2);
        this.config = ObjectUtil.checkNotNull(channelConfig, "config");
        this.setup(true, channelHandlerArray);
    }

    private static ChannelMetadata metadata(boolean bl2) {
        return bl2 ? METADATA_DISCONNECT : METADATA_NO_DISCONNECT;
    }

    private void setup(boolean bl2, final ChannelHandler ... channelHandlerArray) {
        ObjectUtil.checkNotNull(channelHandlerArray, "handlers");
        ChannelPipeline channelPipeline = this.pipeline();
        channelPipeline.addLast(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel channel) throws Exception {
                ChannelPipeline channelPipeline = channel.pipeline();
                for (ChannelHandler channelHandler : channelHandlerArray) {
                    if (channelHandler == null) break;
                    channelPipeline.addLast(channelHandler);
                }
            }
        });
        if (bl2) {
            ChannelFuture channelFuture = this.loop.register(this);
            assert (channelFuture.isDone());
        }
    }

    @Override
    protected final DefaultChannelPipeline newChannelPipeline() {
        return new EmbeddedChannelPipeline(this);
    }

    @Override
    public ChannelMetadata metadata() {
        return this.metadata;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    @Override
    public boolean isActive() {
        return this.state == State.ACTIVE;
    }

    public Queue<Object> inboundMessages() {
        if (this.inboundMessages == null) {
            this.inboundMessages = new ArrayDeque<Object>();
        }
        return this.inboundMessages;
    }

    public Queue<Object> outboundMessages() {
        if (this.outboundMessages == null) {
            this.outboundMessages = new ArrayDeque<Object>();
        }
        return this.outboundMessages;
    }

    public <T> T readInbound() {
        Object object = EmbeddedChannel.poll(this.inboundMessages);
        if (object != null) {
            ReferenceCountUtil.touch(object, "Caller of readInbound() will handle the message from this point");
        }
        return (T)object;
    }

    public boolean writeInbound(Object ... objectArray) {
        this.ensureOpen();
        if (objectArray.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.inboundMessages);
        }
        ChannelPipeline channelPipeline = this.pipeline();
        for (Object object : objectArray) {
            channelPipeline.fireChannelRead(object);
        }
        this.flushInbound(false, this.voidPromise());
        return EmbeddedChannel.isNotEmpty(this.inboundMessages);
    }

    private ChannelFuture flushInbound(boolean bl2, ChannelPromise channelPromise) {
        if (this.checkOpen(bl2)) {
            this.pipeline().fireChannelReadComplete();
            this.runPendingTasks();
        }
        return this.checkException(channelPromise);
    }

    public boolean finish() {
        return this.finish(false);
    }

    public boolean finishAndReleaseAll() {
        return this.finish(true);
    }

    private boolean finish(boolean bl2) {
        this.close();
        try {
            this.checkException();
            boolean bl3 = EmbeddedChannel.isNotEmpty(this.inboundMessages) || EmbeddedChannel.isNotEmpty(this.outboundMessages);
            return bl3;
        }
        finally {
            if (bl2) {
                EmbeddedChannel.releaseAll(this.inboundMessages);
                EmbeddedChannel.releaseAll(this.outboundMessages);
            }
        }
    }

    private static boolean releaseAll(Queue<Object> queue) {
        if (EmbeddedChannel.isNotEmpty(queue)) {
            Object object;
            while ((object = queue.poll()) != null) {
                ReferenceCountUtil.release(object);
            }
            return true;
        }
        return false;
    }

    private void finishPendingTasks(boolean bl2) {
        this.runPendingTasks();
        if (bl2) {
            this.embeddedEventLoop().cancelScheduledTasks();
        }
    }

    @Override
    public final ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public final ChannelFuture close(ChannelPromise channelPromise) {
        this.runPendingTasks();
        ChannelFuture channelFuture = super.close(channelPromise);
        this.finishPendingTasks(true);
        return channelFuture;
    }

    @Override
    public final ChannelFuture disconnect(ChannelPromise channelPromise) {
        ChannelFuture channelFuture = super.disconnect(channelPromise);
        this.finishPendingTasks(!this.metadata.hasDisconnect());
        return channelFuture;
    }

    private static boolean isNotEmpty(Queue<Object> queue) {
        return queue != null && !queue.isEmpty();
    }

    private static Object poll(Queue<Object> queue) {
        return queue != null ? queue.poll() : null;
    }

    public void runPendingTasks() {
        try {
            this.embeddedEventLoop().runTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
        }
        try {
            this.embeddedEventLoop().runScheduledTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
        }
    }

    private void recordException(ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            this.recordException(channelFuture.cause());
        }
    }

    private void recordException(Throwable throwable) {
        if (this.lastException == null) {
            this.lastException = throwable;
        } else {
            logger.warn("More than one exception was raised. Will report only the first one and log others.", throwable);
        }
    }

    private ChannelFuture checkException(ChannelPromise channelPromise) {
        Throwable throwable = this.lastException;
        if (throwable != null) {
            this.lastException = null;
            if (channelPromise.isVoid()) {
                PlatformDependent.throwException(throwable);
            }
            return channelPromise.setFailure(throwable);
        }
        return channelPromise.setSuccess();
    }

    public void checkException() {
        this.checkException(this.voidPromise());
    }

    private boolean checkOpen(boolean bl2) {
        if (!this.isOpen()) {
            if (bl2) {
                this.recordException(new ClosedChannelException());
            }
            return false;
        }
        return true;
    }

    private EmbeddedEventLoop embeddedEventLoop() {
        if (this.isRegistered()) {
            return (EmbeddedEventLoop)super.eventLoop();
        }
        return this.loop;
    }

    protected final void ensureOpen() {
        if (!this.checkOpen(true)) {
            this.checkException();
        }
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EmbeddedEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.isActive() ? LOCAL_ADDRESS : null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.isActive() ? REMOTE_ADDRESS : null;
    }

    @Override
    protected void doRegister() throws Exception {
        this.state = State.ACTIVE;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) throws Exception {
    }

    @Override
    protected void doDisconnect() throws Exception {
        if (!this.metadata.hasDisconnect()) {
            this.doClose();
        }
    }

    @Override
    protected void doClose() throws Exception {
        this.state = State.CLOSED;
    }

    @Override
    protected void doBeginRead() throws Exception {
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new EmbeddedUnsafe();
    }

    @Override
    public Channel.Unsafe unsafe() {
        return ((EmbeddedUnsafe)super.unsafe()).wrapped;
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) throws Exception {
        Object object;
        while ((object = channelOutboundBuffer.current()) != null) {
            ReferenceCountUtil.retain(object);
            this.handleOutboundMessage(object);
            channelOutboundBuffer.remove();
        }
    }

    protected void handleOutboundMessage(Object object) {
        this.outboundMessages().add(object);
    }

    protected void handleInboundMessage(Object object) {
        this.inboundMessages().add(object);
    }

    private final class EmbeddedChannelPipeline
    extends DefaultChannelPipeline {
        EmbeddedChannelPipeline(EmbeddedChannel embeddedChannel2) {
            super(embeddedChannel2);
        }

        @Override
        protected void onUnhandledInboundException(Throwable throwable) {
            EmbeddedChannel.this.recordException(throwable);
        }

        @Override
        protected void onUnhandledInboundMessage(ChannelHandlerContext channelHandlerContext, Object object) {
            EmbeddedChannel.this.handleInboundMessage(object);
        }
    }

    private final class EmbeddedUnsafe
    extends AbstractChannel.AbstractUnsafe {
        final Channel.Unsafe wrapped = new Channel.Unsafe(){

            @Override
            public RecvByteBufAllocator.Handle recvBufAllocHandle() {
                return EmbeddedUnsafe.this.recvBufAllocHandle();
            }

            @Override
            public SocketAddress localAddress() {
                return EmbeddedUnsafe.this.localAddress();
            }

            @Override
            public SocketAddress remoteAddress() {
                return EmbeddedUnsafe.this.remoteAddress();
            }

            @Override
            public void register(EventLoop eventLoop, ChannelPromise channelPromise) {
                EmbeddedUnsafe.this.register(eventLoop, channelPromise);
                EmbeddedChannel.this.runPendingTasks();
            }

            @Override
            public void bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
                EmbeddedUnsafe.this.bind(socketAddress, channelPromise);
                EmbeddedChannel.this.runPendingTasks();
            }

            @Override
            public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
                EmbeddedUnsafe.this.connect(socketAddress, socketAddress2, channelPromise);
                EmbeddedChannel.this.runPendingTasks();
            }

            @Override
            public void disconnect(ChannelPromise channelPromise) {
                EmbeddedUnsafe.this.disconnect(channelPromise);
                EmbeddedChannel.this.runPendingTasks();
            }

            @Override
            public void close(ChannelPromise channelPromise) {
                EmbeddedUnsafe.this.close(channelPromise);
                EmbeddedChannel.this.runPendingTasks();
            }

            @Override
            public void closeForcibly() {
                EmbeddedUnsafe.this.closeForcibly();
                EmbeddedChannel.this.runPendingTasks();
            }

            @Override
            public void deregister(ChannelPromise channelPromise) {
                EmbeddedUnsafe.this.deregister(channelPromise);
                EmbeddedChannel.this.runPendingTasks();
            }

            @Override
            public void beginRead() {
                EmbeddedUnsafe.this.beginRead();
                EmbeddedChannel.this.runPendingTasks();
            }

            @Override
            public void write(Object object, ChannelPromise channelPromise) {
                EmbeddedUnsafe.this.write(object, channelPromise);
                EmbeddedChannel.this.runPendingTasks();
            }

            @Override
            public void flush() {
                EmbeddedUnsafe.this.flush();
                EmbeddedChannel.this.runPendingTasks();
            }

            @Override
            public ChannelPromise voidPromise() {
                return EmbeddedUnsafe.this.voidPromise();
            }

            @Override
            public ChannelOutboundBuffer outboundBuffer() {
                return EmbeddedUnsafe.this.outboundBuffer();
            }
        };

        private EmbeddedUnsafe() {
        }

        @Override
        public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            this.safeSetSuccess(channelPromise);
        }
    }

    private static enum State {
        OPEN,
        ACTIVE,
        CLOSED;

    }
}

