/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.dev.failsafe;

import com.gradle.scan.plugin.internal.dep.dev.failsafe.CallImpl;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.ExecutionImpl;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.FailsafeException;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.FailsafeExecutor;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.ExecutionResult;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.PolicyExecutor;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.Scheduler;
import com.gradle.scan.plugin.internal.dep.dev.failsafe.spi.SyncExecutionInternal;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

final class SyncExecutionImpl<R>
extends ExecutionImpl<R>
implements SyncExecutionInternal<R> {
    private final FailsafeExecutor<R> executor;
    private final CallImpl<R> call;
    private Function<SyncExecutionInternal<R>, ExecutionResult<R>> outerFn;
    private final Thread executionThread;
    private final AtomicBoolean interruptable;
    private final AtomicBoolean interrupted;

    SyncExecutionImpl(FailsafeExecutor<R> failsafeExecutor, Scheduler scheduler, CallImpl<R> callImpl, Function<SyncExecutionInternal<R>, ExecutionResult<R>> function) {
        super(failsafeExecutor.policies);
        this.executor = failsafeExecutor;
        this.call = callImpl;
        this.interruptable = new AtomicBoolean();
        this.interrupted = new AtomicBoolean();
        this.executionThread = Thread.currentThread();
        if (callImpl != null) {
            callImpl.setExecution(this);
        }
        this.outerFn = function;
        for (PolicyExecutor policyExecutor : this.policyExecutors) {
            this.outerFn = policyExecutor.apply(this.outerFn, scheduler);
        }
    }

    private SyncExecutionImpl(SyncExecutionImpl<R> syncExecutionImpl) {
        super(syncExecutionImpl);
        this.executor = syncExecutionImpl.executor;
        this.call = syncExecutionImpl.call;
        this.interruptable = syncExecutionImpl.interruptable;
        this.interrupted = syncExecutionImpl.interrupted;
        this.executionThread = syncExecutionImpl.executionThread;
        if (this.call != null) {
            this.call.setExecution(this);
        }
    }

    @Override
    public synchronized void preExecute() {
        if (this.isStandalone()) {
            this.attemptRecorded = false;
            this.cancelledIndex = Integer.MIN_VALUE;
            this.interrupted.set(false);
        }
        super.preExecute();
        this.interruptable.set(true);
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted.get();
    }

    @Override
    public void setInterruptable(boolean bl2) {
        this.interruptable.set(bl2);
    }

    private boolean isStandalone() {
        return this.executor == null;
    }

    @Override
    public SyncExecutionImpl<R> copy() {
        return this.isStandalone() ? this : new SyncExecutionImpl<R>(this);
    }

    R executeSync() {
        ExecutionResult<R> executionResult = this.outerFn.apply(this);
        this.completed = executionResult.isComplete();
        this.executor.completionHandler.accept(executionResult, this);
        Throwable throwable = executionResult.getException();
        if (throwable != null) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new FailsafeException(throwable);
        }
        return executionResult.getResult();
    }
}

