/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.RecyclerPool;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class BufferRecycler
implements RecyclerPool.WithPool<BufferRecycler> {
    private static final int[] BYTE_BUFFER_LENGTHS = new int[]{8000, 8000, 2000, 2000};
    private static final int[] CHAR_BUFFER_LENGTHS = new int[]{4000, 4000, 200, 200};
    protected final AtomicReferenceArray<byte[]> _byteBuffers;
    protected final AtomicReferenceArray<char[]> _charBuffers;
    private RecyclerPool<BufferRecycler> _pool;

    public BufferRecycler() {
        this(4, 4);
    }

    protected BufferRecycler(int n2, int n3) {
        this._byteBuffers = new AtomicReferenceArray(n2);
        this._charBuffers = new AtomicReferenceArray(n3);
    }

    public final byte[] allocByteBuffer(int n2) {
        return this.allocByteBuffer(n2, 0);
    }

    public byte[] allocByteBuffer(int n2, int n3) {
        byte[] byArray;
        int n4 = this.byteBufferLength(n2);
        if (n3 < n4) {
            n3 = n4;
        }
        if ((byArray = (byte[])this._byteBuffers.getAndSet(n2, null)) == null || byArray.length < n3) {
            byArray = this.balloc(n3);
        }
        return byArray;
    }

    public void releaseByteBuffer(int n2, byte[] byArray) {
        this._byteBuffers.set(n2, byArray);
    }

    public final char[] allocCharBuffer(int n2) {
        return this.allocCharBuffer(n2, 0);
    }

    public char[] allocCharBuffer(int n2, int n3) {
        char[] cArray;
        int n4 = this.charBufferLength(n2);
        if (n3 < n4) {
            n3 = n4;
        }
        if ((cArray = (char[])this._charBuffers.getAndSet(n2, null)) == null || cArray.length < n3) {
            cArray = this.calloc(n3);
        }
        return cArray;
    }

    public void releaseCharBuffer(int n2, char[] cArray) {
        this._charBuffers.set(n2, cArray);
    }

    protected int byteBufferLength(int n2) {
        return BYTE_BUFFER_LENGTHS[n2];
    }

    protected int charBufferLength(int n2) {
        return CHAR_BUFFER_LENGTHS[n2];
    }

    protected byte[] balloc(int n2) {
        return new byte[n2];
    }

    protected char[] calloc(int n2) {
        return new char[n2];
    }

    @Override
    public BufferRecycler withPool(RecyclerPool<BufferRecycler> recyclerPool) {
        if (this._pool != null) {
            throw new IllegalStateException("BufferRecycler already linked to pool: " + recyclerPool);
        }
        this._pool = Objects.requireNonNull(recyclerPool);
        return this;
    }

    public void releaseToPool() {
        if (this._pool != null) {
            RecyclerPool<BufferRecycler> recyclerPool = this._pool;
            this._pool = null;
            recyclerPool.releasePooled(this);
        }
    }
}

