/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonLocation;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.format.InputAccessor;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.format.MatchStrength;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileParser$Feature;
import java.io.InputStream;

public class SmileParserBootstrapper {
    protected final IOContext _context;
    protected final InputStream _in;
    protected final byte[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;
    protected final boolean _bufferRecyclable;
    protected int _inputProcessed;

    public SmileParserBootstrapper(IOContext iOContext, InputStream inputStream) {
        this._context = iOContext;
        this._in = inputStream;
        this._inputBuffer = iOContext.allocReadIOBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._inputProcessed = 0;
        this._bufferRecyclable = true;
    }

    public SmileParserBootstrapper(IOContext iOContext, byte[] byArray, int n, int n2) {
        this._context = iOContext;
        this._in = null;
        this._inputBuffer = byArray;
        this._inputPtr = n;
        this._inputEnd = n + n2;
        this._inputProcessed = -n;
        this._bufferRecyclable = false;
    }

    public SmileParser constructParser(int n, int n2, int n3, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer) {
        ByteQuadsCanonicalizer byteQuadsCanonicalizer2 = byteQuadsCanonicalizer.makeChild(n);
        int n4 = this._inputEnd;
        if (this._inputPtr < n4 && this._in != null && (n4 = this._in.read(this._inputBuffer, n4, this._inputBuffer.length - n4)) > 0) {
            this._inputEnd += n4;
        }
        SmileParser smileParser = new SmileParser(this._context, n2, n3, objectCodec, byteQuadsCanonicalizer2, this._in, this._inputBuffer, this._inputPtr, this._inputEnd, this._bufferRecyclable);
        byte by = 0;
        if (this._inputPtr < this._inputEnd) {
            if (this._inputBuffer[this._inputPtr] == 58) {
                by = smileParser.handleSignature(true, true);
            }
        } else {
            return smileParser;
        }
        if (by == 0 && SmileParser$Feature.REQUIRE_HEADER.enabledIn(n3)) {
            by = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr] : (byte)0;
            String string = by == 123 || by == 91 ? "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(by & 0xFF) + ") -- rather, it starts with '" + (char)by + "' (plain JSON input?) -- can not parse" : "Input does not start with Smile format header (first byte = 0x" + Integer.toHexString(by & 0xFF) + ") and parser has REQUIRE_HEADER enabled: can not parse";
            throw new JsonParseException(string, JsonLocation.NA);
        }
        return smileParser;
    }

    public static MatchStrength hasSmileFormat(InputAccessor inputAccessor) {
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by = inputAccessor.nextByte();
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by2 = inputAccessor.nextByte();
        if (by == 58) {
            if (by2 != 41) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() == 10) {
                return MatchStrength.FULL_MATCH;
            }
            return MatchStrength.NO_MATCH;
        }
        if (by == -6) {
            if (by2 == 52) {
                return MatchStrength.SOLID_MATCH;
            }
            int n = by2 & 0xFF;
            if (n >= 128 && n < 248) {
                return MatchStrength.SOLID_MATCH;
            }
            return MatchStrength.NO_MATCH;
        }
        if (by == -8) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (SmileParserBootstrapper.likelySmileValue(by2) || SmileParserBootstrapper.possibleSmileValue(by2, true)) {
                return MatchStrength.SOLID_MATCH;
            }
            return MatchStrength.NO_MATCH;
        }
        if (SmileParserBootstrapper.likelySmileValue(by) || SmileParserBootstrapper.possibleSmileValue(by2, false)) {
            return MatchStrength.SOLID_MATCH;
        }
        return MatchStrength.NO_MATCH;
    }

    private static boolean likelySmileValue(byte by) {
        if (by == -32 || by == -28 || by == -24 || by == -8 || by == -6) {
            return true;
        }
        int n = by & 0xFF;
        by = (byte)n;
        return n >= 128 && by <= 159;
    }

    private static boolean possibleSmileValue(byte by, boolean bl) {
        int n = by & 0xFF;
        by = (byte)n;
        if (n >= 128) {
            return by <= 224;
        }
        if (bl) {
            if (by >= 64) {
                return true;
            }
            if (by > -32) {
                return by < 44;
            }
        }
        return false;
    }
}

