/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerationException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.PrettyPrinter;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Version;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.base.GeneratorBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json.JsonWriteContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.PackageVersion;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileBufferRecycler;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileGenerator$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileGenerator$SharedStringNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class SmileGenerator
extends GeneratorBase {
    private static final int MIN_BUFFER_LENGTH = 770;
    protected static final byte TOKEN_BYTE_LONG_STRING_ASCII = -32;
    protected static final byte TOKEN_BYTE_INT_32 = 36;
    protected static final byte TOKEN_BYTE_INT_64 = 37;
    protected static final byte TOKEN_BYTE_BIG_INTEGER = 38;
    protected static final byte TOKEN_BYTE_FLOAT_32 = 40;
    protected static final byte TOKEN_BYTE_FLOAT_64 = 41;
    protected static final byte TOKEN_BYTE_BIG_DECIMAL = 42;
    protected static final long MIN_INT_AS_LONG = Integer.MIN_VALUE;
    protected static final long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    protected final IOContext _ioContext;
    protected final OutputStream _out;
    protected int _formatFeatures;
    protected final SmileBufferRecycler<SmileGenerator$SharedStringNode> _smileBufferRecycler;
    protected byte[] _outputBuffer;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected int _bytesWritten;
    protected SmileGenerator$SharedStringNode[] _seenNames;
    protected int _seenNameCount;
    protected SmileGenerator$SharedStringNode[] _seenStringValues;
    protected int _seenStringValueCount;
    protected boolean _bufferRecyclable;
    protected static final ThreadLocal<SoftReference<SmileBufferRecycler<SmileGenerator$SharedStringNode>>> _smileRecyclerRef = new ThreadLocal();

    public SmileGenerator(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, OutputStream outputStream) {
        super(n, objectCodec);
        this._formatFeatures = n2;
        this._ioContext = iOContext;
        this._smileBufferRecycler = SmileGenerator._smileBufferRecycler();
        this._out = outputStream;
        this._bufferRecyclable = true;
        this._outputBuffer = iOContext.allocWriteEncodingBuffer();
        this._outputEnd = this._outputBuffer.length;
        if (this._outputEnd < 770) {
            throw new IllegalStateException("Internal encoding buffer length (" + this._outputEnd + ") too short, must be at least 770");
        }
        if ((n2 & SmileGenerator$Feature.CHECK_SHARED_NAMES.getMask()) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        } else {
            this._seenNames = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (this._seenNames == null) {
                this._seenNames = new SmileGenerator$SharedStringNode[64];
            }
            this._seenNameCount = 0;
        }
        if ((n2 & SmileGenerator$Feature.CHECK_SHARED_STRING_VALUES.getMask()) == 0) {
            this._seenStringValues = null;
            this._seenStringValueCount = -1;
            return;
        }
        this._seenStringValues = this._smileBufferRecycler.allocSeenStringValuesBuffer();
        if (this._seenStringValues == null) {
            this._seenStringValues = new SmileGenerator$SharedStringNode[64];
        }
        this._seenStringValueCount = 0;
    }

    public SmileGenerator(IOContext iOContext, int n, int n2, ObjectCodec objectCodec, OutputStream outputStream, byte[] byArray, int n3, boolean bl) {
        super(n, objectCodec);
        this._formatFeatures = n2;
        this._ioContext = iOContext;
        this._smileBufferRecycler = SmileGenerator._smileBufferRecycler();
        this._out = outputStream;
        this._bufferRecyclable = bl;
        this._outputTail = n3;
        this._outputBuffer = byArray;
        this._outputEnd = this._outputBuffer.length;
        if (this._outputEnd < 770) {
            throw new IllegalStateException("Internal encoding buffer length (" + this._outputEnd + ") too short, must be at least 770");
        }
        if ((n2 & SmileGenerator$Feature.CHECK_SHARED_NAMES.getMask()) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        } else {
            this._seenNames = this._smileBufferRecycler.allocSeenNamesBuffer();
            if (this._seenNames == null) {
                this._seenNames = new SmileGenerator$SharedStringNode[64];
            }
            this._seenNameCount = 0;
        }
        if ((n2 & SmileGenerator$Feature.CHECK_SHARED_STRING_VALUES.getMask()) == 0) {
            this._seenStringValues = null;
            this._seenStringValueCount = -1;
            return;
        }
        this._seenStringValues = this._smileBufferRecycler.allocSeenStringValuesBuffer();
        if (this._seenStringValues == null) {
            this._seenStringValues = new SmileGenerator$SharedStringNode[64];
        }
        this._seenStringValueCount = 0;
    }

    public void writeHeader() {
        int n = 0;
        if (SmileGenerator$Feature.CHECK_SHARED_NAMES.enabledIn(this._formatFeatures)) {
            n = 1;
        }
        if (SmileGenerator$Feature.CHECK_SHARED_STRING_VALUES.enabledIn(this._formatFeatures)) {
            n |= 2;
        }
        if (!SmileGenerator$Feature.ENCODE_BINARY_AS_7BIT.enabledIn(this._formatFeatures)) {
            n |= 4;
        }
        this._writeBytes((byte)58, (byte)41, (byte)10, (byte)n);
    }

    protected static final SmileBufferRecycler<SmileGenerator$SharedStringNode> _smileBufferRecycler() {
        Object object = _smileRecyclerRef.get();
        object = object == null ? null : ((SoftReference)object).get();
        if (object == null) {
            object = new SmileBufferRecycler();
            _smileRecyclerRef.set(new SoftReference(object));
        }
        return object;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean canWriteBinaryNatively() {
        return true;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this;
    }

    @Override
    public Object getOutputTarget() {
        return this._out;
    }

    @Override
    public int getOutputBuffered() {
        return this._outputTail;
    }

    @Override
    public int getFormatFeatures() {
        return this._formatFeatures;
    }

    @Override
    public JsonGenerator overrideFormatFeatures(int n, int n2) {
        this._formatFeatures = this._formatFeatures & ~n2 | n & n2;
        return this;
    }

    @Override
    public final void writeFieldName(String string) {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
    }

    @Override
    public final void writeFieldName(SerializableString serializableString) {
        if (this._writeContext.writeFieldName(serializableString.getValue()) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString);
    }

    @Override
    public final void writeStringField(String string, String string2) {
        if (this._writeContext.writeFieldName(string) == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string);
        this.writeString(string2);
    }

    public SmileGenerator enable(SmileGenerator$Feature smileGenerator$Feature) {
        this._formatFeatures |= smileGenerator$Feature.getMask();
        return this;
    }

    public SmileGenerator disable(SmileGenerator$Feature smileGenerator$Feature) {
        this._formatFeatures &= ~smileGenerator$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(SmileGenerator$Feature smileGenerator$Feature) {
        return (this._formatFeatures & smileGenerator$Feature.getMask()) != 0;
    }

    public SmileGenerator configure(SmileGenerator$Feature smileGenerator$Feature, boolean bl) {
        if (bl) {
            this.enable(smileGenerator$Feature);
        } else {
            this.disable(smileGenerator$Feature);
        }
        return this;
    }

    public void writeRaw(byte by) {
        this._writeByte(by);
    }

    public void writeBytes(byte[] byArray, int n, int n2) {
        this._writeBytes(byArray, n, n2);
    }

    @Override
    public final void writeStartArray() {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this._writeByte((byte)-8);
    }

    @Override
    public final void writeStartArray(int n) {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this._writeByte((byte)-8);
    }

    @Override
    public final void writeEndArray() {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        this._writeByte((byte)-7);
        this._writeContext = this._writeContext.getParent();
    }

    @Override
    public final void writeStartObject() {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        this._writeByte((byte)-6);
    }

    @Override
    public final void writeEndObject() {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this._writeByte((byte)-5);
    }

    private final void _writeFieldName(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenNameCount >= 0 && (n = this._findSeenName(string)) >= 0) {
            this._writeSharedNameReference(n);
            return;
        }
        if (n2 > 64) {
            this._writeNonShortFieldName(string, n2);
            return;
        }
        if (this._outputTail + 196 >= this._outputEnd) {
            this._flushBuffer();
        }
        n = this._outputTail++;
        int n3 = this._shortUTF8Encode(string, 0, n2);
        if (n3 == n2) {
            if (n3 <= 64) {
                n2 = (byte)(n3 + 127);
            } else {
                n2 = 52;
                this._outputBuffer[this._outputTail++] = -4;
            }
        } else if (n3 <= 56) {
            n2 = (byte)(n3 + 190);
        } else {
            n2 = 52;
            this._outputBuffer[this._outputTail++] = -4;
        }
        this._outputBuffer[n] = n2;
        if (this._seenNameCount >= 0) {
            this._addSeenName(string);
        }
    }

    private final void _writeNonShortFieldName(String string, int n) {
        this._writeByte((byte)52);
        int n2 = n + n + n;
        if (n2 <= this._outputBuffer.length) {
            if (this._outputTail + n2 >= this._outputEnd) {
                this._flushBuffer();
            }
            this._shortUTF8Encode(string, 0, n);
        } else {
            this._mediumUTF8Encode(string, 0, n);
        }
        if (this._seenNameCount >= 0) {
            this._addSeenName(string);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    protected final void _writeFieldName(SerializableString serializableString) {
        int n;
        int n2 = serializableString.charLength();
        if (n2 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenNameCount >= 0 && (n = this._findSeenName(serializableString.getValue())) >= 0) {
            this._writeSharedNameReference(n);
            return;
        }
        byte[] byArray = serializableString.asUnquotedUTF8();
        int n3 = byArray.length;
        if (n3 != n2) {
            this._writeFieldNameUnicode(serializableString, byArray);
            return;
        }
        if (n3 <= 64) {
            if (this._outputTail + n3 >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = (byte)(n3 + 127);
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n3);
            this._outputTail += n3;
        } else {
            this._writeLongAsciiFieldName(byArray);
        }
        if (this._seenNameCount >= 0) {
            this._addSeenName(serializableString.getValue());
        }
    }

    private final void _writeLongAsciiFieldName(byte[] byArray) {
        int n = byArray.length;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 52;
        if (this._outputTail + n + 1 < this._outputEnd) {
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n);
            this._outputTail += n;
        } else {
            this._flushBuffer();
            if (n < 770) {
                System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n);
                this._outputTail += n;
            } else {
                if (this._outputTail > 0) {
                    this._flushBuffer();
                }
                this._out.write(byArray, 0, n);
            }
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    protected final void _writeFieldNameUnicode(SerializableString serializableString, byte[] byArray) {
        int n = byArray.length;
        if (n <= 56) {
            if (this._outputTail + n >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = (byte)(n + 190);
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n);
            this._outputTail += n;
            if (this._seenNameCount >= 0) {
                this._addSeenName(serializableString.getValue());
            }
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 52;
        if (this._outputTail + n + 1 < this._outputEnd) {
            System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n);
            this._outputTail += n;
        } else {
            this._flushBuffer();
            if (n < 770) {
                System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n);
                this._outputTail += n;
            } else {
                if (this._outputTail > 0) {
                    this._flushBuffer();
                }
                this._out.write(byArray, 0, n);
            }
        }
        this._outputBuffer[this._outputTail++] = -4;
        if (this._seenNameCount >= 0) {
            this._addSeenName(serializableString.getValue());
        }
    }

    private final void _writeSharedNameReference(int n) {
        if (n >= this._seenNameCount) {
            throw new IllegalArgumentException("Internal error: trying to write shared name with index " + n + "; but have only seen " + this._seenNameCount + " so far!");
        }
        if (n < 64) {
            this._writeByte((byte)(n + 64));
            return;
        }
        this._writeBytes((byte)(48 + (n >> 8)), (byte)n);
    }

    @Override
    public void writeString(String string) {
        int n;
        if (string == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        int n2 = string.length();
        if (n2 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (n2 > 65) {
            this._writeNonSharedString(string, n2);
            return;
        }
        if (this._seenStringValueCount >= 0 && (n = this._findSeenStringValue(string)) >= 0) {
            this._writeSharedStringValueReference(n);
            return;
        }
        if (this._outputTail + 196 >= this._outputEnd) {
            this._flushBuffer();
        }
        n = this._outputTail++;
        int n3 = this._shortUTF8Encode(string, 0, n2);
        if (n3 <= 64) {
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(string);
            }
            if (n3 == n2) {
                this._outputBuffer[n] = (byte)(n3 + 63);
                return;
            }
            this._outputBuffer[n] = (byte)(n3 + 126);
            return;
        }
        this._outputBuffer[n] = n3 == n2 ? -32 : -28;
        this._outputBuffer[this._outputTail++] = -4;
    }

    private final void _writeSharedStringValueReference(int n) {
        if (n >= this._seenStringValueCount) {
            throw new IllegalArgumentException("Internal error: trying to write shared String value with index " + n + "; but have only seen " + this._seenStringValueCount + " so far!");
        }
        if (n < 31) {
            this._writeByte((byte)(n + 1));
            return;
        }
        this._writeBytes((byte)(236 + (n >> 8)), (byte)n);
    }

    private final void _writeNonSharedString(String string, int n) {
        int n2 = n + n + n + 2;
        if (n2 > this._outputBuffer.length) {
            this._writeByte((byte)-28);
            this._mediumUTF8Encode(string, 0, n);
            this._writeByte((byte)-4);
            return;
        }
        if (this._outputTail + n2 >= this._outputEnd) {
            this._flushBuffer();
        }
        n2 = this._outputTail;
        this._writeByte((byte)-32);
        if (this._shortUTF8Encode(string, 0, n) > n) {
            this._outputBuffer[n2] = -28;
        }
        this._outputBuffer[this._outputTail++] = -4;
    }

    @Override
    public void writeString(char[] cArray, int n, int n2) {
        if (n2 <= 65 && this._seenStringValueCount >= 0 && n2 > 0) {
            this.writeString(new String(cArray, n, n2));
            return;
        }
        this._verifyValueWrite("write String value");
        if (n2 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (n2 <= 64) {
            int n3;
            if (this._outputTail + 196 >= this._outputEnd) {
                this._flushBuffer();
            }
            int n4 = this._outputTail++;
            int n5 = this._shortUTF8Encode(cArray, n, n + n2);
            if (n5 <= 64) {
                n3 = n5 == n2 ? (int)((byte)(n5 + 63)) : (int)((byte)(n5 + 126));
            } else {
                n3 = -28;
                this._outputBuffer[this._outputTail++] = -4;
            }
            this._outputBuffer[n4] = n3;
            return;
        }
        int n6 = n2 + n2 + n2 + 2;
        if (n6 <= this._outputBuffer.length) {
            if (this._outputTail + n6 >= this._outputEnd) {
                this._flushBuffer();
            }
            int n7 = this._outputTail;
            this._writeByte((byte)-28);
            if (this._shortUTF8Encode(cArray, n, n + n2) == n2) {
                this._outputBuffer[n7] = -32;
            }
            this._outputBuffer[this._outputTail++] = -4;
            return;
        }
        this._writeByte((byte)-28);
        this._mediumUTF8Encode(cArray, n, n + n2);
        this._writeByte((byte)-4);
    }

    @Override
    public final void writeString(SerializableString serializableString) {
        int n;
        this._verifyValueWrite("write String value");
        Object object = serializableString.getValue();
        int n2 = ((String)object).length();
        if (n2 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (n2 <= 65 && this._seenStringValueCount >= 0 && (n = this._findSeenStringValue((String)object)) >= 0) {
            this._writeSharedStringValueReference(n);
            return;
        }
        byte[] byArray = serializableString.asUnquotedUTF8();
        object = byArray;
        int n3 = byArray.length;
        if (n3 <= 64) {
            if (this._outputTail + n3 + 1 >= this._outputEnd) {
                this._flushBuffer();
            }
            n2 = n3 == n2 ? n3 + 63 : n3 + 126;
            this._outputBuffer[this._outputTail++] = (byte)n2;
            System.arraycopy(object, 0, this._outputBuffer, this._outputTail, n3);
            this._outputTail += n3;
            if (this._seenStringValueCount >= 0) {
                this._addSeenStringValue(serializableString.getValue());
            }
            return;
        }
        n2 = n3 == n2 ? -32 : -28;
        this._writeByte((byte)n2);
        this._writeBytes((byte[])object, 0, ((Object)object).length);
        this._writeByte((byte)-4);
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n, int n2) {
        this._verifyValueWrite("write String value");
        if (n2 == 0) {
            this._writeByte((byte)32);
            return;
        }
        if (this._seenStringValueCount >= 0) {
            throw new UnsupportedOperationException("Can not use direct UTF-8 write methods when 'Feature.CHECK_SHARED_STRING_VALUES' enabled");
        }
        if (n2 <= 65) {
            if (this._outputTail + n2 >= this._outputEnd) {
                this._flushBuffer();
            }
            if (n2 == 1) {
                this._outputBuffer[this._outputTail++] = 64;
                this._outputBuffer[this._outputTail++] = byArray[n];
                return;
            }
            this._outputBuffer[this._outputTail++] = (byte)(n2 + 126);
            System.arraycopy(byArray, n, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
            return;
        }
        int n3 = n2 + n2 + n2 + 2;
        if (n3 <= this._outputBuffer.length) {
            if (this._outputTail + n3 >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = -28;
            System.arraycopy(byArray, n, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
            this._outputBuffer[this._outputTail++] = -4;
            return;
        }
        this._writeByte((byte)-28);
        this._writeBytes(byArray, n, n2);
        this._writeByte((byte)-4);
    }

    @Override
    public final void writeUTF8String(byte[] byArray, int n, int n2) {
        this.writeRawUTF8String(byArray, n, n2);
    }

    @Override
    public void writeRaw(String string) {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(String string, int n, int n2) {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) {
        throw this._notSupported();
    }

    @Override
    public void writeRaw(char c2) {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(String string) {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(String string, int n, int n2) {
        throw this._notSupported();
    }

    @Override
    public void writeRawValue(char[] cArray, int n, int n2) {
        throw this._notSupported();
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) {
        if (byArray == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (this.isEnabled(SmileGenerator$Feature.ENCODE_BINARY_AS_7BIT)) {
            this._writeByte((byte)-24);
            this._write7BitBinaryWithLength(byArray, n, n2);
            return;
        }
        this._writeByte((byte)-3);
        this._writePositiveVInt(n2);
        this._writeBytes(byArray, n, n2);
    }

    @Override
    public int writeBinary(InputStream inputStream, int n) {
        int n2;
        if (n < 0) {
            throw new UnsupportedOperationException("Must pass actual length for Smile encoded data");
        }
        this._verifyValueWrite("write Binary value");
        if (this.isEnabled(SmileGenerator$Feature.ENCODE_BINARY_AS_7BIT)) {
            this._writeByte((byte)-24);
            byte[] byArray = this._ioContext.allocBase64Buffer();
            try {
                n2 = this._write7BitBinaryWithLength(inputStream, n, byArray);
            }
            finally {
                this._ioContext.releaseBase64Buffer(byArray);
            }
        } else {
            this._writeByte((byte)-3);
            this._writePositiveVInt(n);
            n2 = this._writeBytes(inputStream, n);
        }
        if (n2 > 0) {
            this._reportError("Too few bytes available: missing " + n2 + " bytes (out of " + n + ")");
        }
        return n;
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n) {
        return this.writeBinary(inputStream, n);
    }

    @Override
    public void writeBoolean(boolean bl) {
        this._verifyValueWrite("write boolean value");
        if (bl) {
            this._writeByte((byte)35);
            return;
        }
        this._writeByte((byte)34);
    }

    @Override
    public void writeNull() {
        this._verifyValueWrite("write null value");
        this._writeByte((byte)33);
    }

    @Override
    public void writeNumber(int n) {
        this._verifyValueWrite("write number");
        n = SmileUtil.zigzagEncode(n);
        if (n <= 63 && n >= 0) {
            if (n <= 31) {
                this._writeByte((byte)(n + 192));
                return;
            }
            this._writeBytes((byte)36, (byte)(n + 128));
            return;
        }
        byte by = (byte)(128 + (n & 0x3F));
        if ((n >>>= 6) <= 127) {
            this._writeBytes((byte)36, (byte)n, by);
            return;
        }
        byte by2 = (byte)(n & 0x7F);
        if ((n >>= 7) <= 127) {
            this._writeBytes((byte)36, (byte)n, by2, by);
            return;
        }
        byte by3 = (byte)(n & 0x7F);
        if ((n >>= 7) <= 127) {
            this._writeBytes((byte)36, (byte)n, by3, by2, by);
            return;
        }
        byte by4 = (byte)(n & 0x7F);
        this._writeBytes((byte)36, (byte)(n >> 7), by4, by3, by2, by);
    }

    @Override
    public void writeNumber(long l) {
        if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
            this.writeNumber((int)l);
            return;
        }
        this._verifyValueWrite("write number");
        l = SmileUtil.zigzagEncode(l);
        int n = (int)l;
        byte by = (byte)(128 + (n & 0x3F));
        byte by2 = (byte)(n >> 6 & 0x7F);
        byte by3 = (byte)(n >> 13 & 0x7F);
        byte by4 = (byte)(n >> 20 & 0x7F);
        byte by5 = (byte)((int)(l >>>= 27) & 0x7F);
        n = (int)(l >> 7);
        if (n == 0) {
            this._writeBytes((byte)37, by5, by4, by3, by2, by);
            return;
        }
        if (n <= 127) {
            this._writeBytes((byte)37, (byte)n);
            this._writeBytes(by5, by4, by3, by2, by);
            return;
        }
        byte by6 = (byte)(n & 0x7F);
        if ((n >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)n);
            this._writeBytes(by6, by5, by4, by3, by2, by);
            return;
        }
        byte by7 = (byte)(n & 0x7F);
        if ((n >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)n, by7);
            this._writeBytes(by6, by5, by4, by3, by2, by);
            return;
        }
        byte by8 = (byte)(n & 0x7F);
        if ((n >>= 7) <= 127) {
            this._writeBytes((byte)37, (byte)n, by8, by7);
            this._writeBytes(by6, by5, by4, by3, by2, by);
            return;
        }
        byte by9 = (byte)(n & 0x7F);
        this._writeBytes((byte)37, (byte)(n >>= 7), by9, by8, by7);
        this._writeBytes(by6, by5, by4, by3, by2, by);
    }

    @Override
    public void writeNumber(BigInteger object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeByte((byte)38);
        object = ((BigInteger)object).toByteArray();
        this._write7BitBinaryWithLength((byte[])object, 0, ((Object)object).length);
    }

    @Override
    public void writeNumber(double d2) {
        this._ensureRoomForOutput(11);
        this._verifyValueWrite("write number");
        long l = Double.doubleToRawLongBits(d2);
        this._outputBuffer[this._outputTail++] = 41;
        int n = (int)(l >>> 35);
        this._outputBuffer[this._outputTail + 4] = (byte)(n & 0x7F);
        this._outputBuffer[this._outputTail + 3] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)(n >>= 7);
        this._outputTail += 5;
        n = (int)(l >> 28);
        this._outputBuffer[this._outputTail++] = (byte)(n & 0x7F);
        n = (int)l;
        this._outputBuffer[this._outputTail + 3] = (byte)(n & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)((n >>= 7) & 0x7F);
        this._outputTail += 4;
    }

    @Override
    public void writeNumber(float f2) {
        this._ensureRoomForOutput(6);
        this._verifyValueWrite("write number");
        int n = Float.floatToRawIntBits(f2);
        this._outputBuffer[this._outputTail++] = 40;
        this._outputBuffer[this._outputTail + 4] = (byte)(n & 0x7F);
        this._outputBuffer[this._outputTail + 3] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 2] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail + 1] = (byte)((n >>= 7) & 0x7F);
        this._outputBuffer[this._outputTail] = (byte)((n >>= 7) & 0x7F);
        this._outputTail += 5;
    }

    @Override
    public void writeNumber(BigDecimal object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeByte((byte)42);
        int n = ((BigDecimal)object).scale();
        this._writeSignedVInt(n);
        object = ((BigDecimal)object).unscaledValue().toByteArray();
        this._write7BitBinaryWithLength((byte[])object, 0, ((Object)object).length);
    }

    @Override
    public void writeNumber(String string) {
        char c2;
        int n;
        if (string == null) {
            this.writeNull();
            return;
        }
        int n2 = string.length();
        boolean bl = string.startsWith("-");
        int n3 = n = bl ? 1 : 0;
        while ((c2 = string.charAt(n)) <= '9' && c2 >= '0') {
            if (++n != n2) continue;
            this._writeIntegralNumber(string, bl);
            return;
        }
        this._writeDecimalNumber(string);
    }

    protected void _writeIntegralNumber(String string, boolean bl) {
        int n = string.length();
        if (bl) {
            --n;
        }
        try {
            if (n <= 9) {
                this.writeNumber(Integer.parseInt(string));
                return;
            }
            if (n <= 18) {
                this.writeNumber(Long.parseLong(string));
                return;
            }
            this.writeNumber(new BigInteger(string));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonGenerationException("Invalid String representation for Number ('" + string + "'); can not write using Smile format");
        }
    }

    protected void _writeDecimalNumber(String string) {
        try {
            this.writeNumber(new BigDecimal(string));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JsonGenerationException("Invalid String representation for Number ('" + string + "'); can not write using Smile format");
        }
    }

    @Override
    protected final void _verifyValueWrite(String string) {
        if (this._writeContext.writeValue() == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
    }

    @Override
    public final void flush() {
        this._flushBuffer();
        if (this.isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
            this._out.flush();
        }
    }

    @Override
    public void close() {
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator$Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonWriteContext jsonWriteContext;
                if ((jsonWriteContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonWriteContext.inObject()) break;
                this.writeEndObject();
            }
        }
        boolean bl = this._closed;
        super.close();
        if (!bl && this.isEnabled(SmileGenerator$Feature.WRITE_END_MARKER)) {
            this._writeByte((byte)-1);
        }
        this._flushBuffer();
        if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator$Feature.AUTO_CLOSE_TARGET)) {
            this._out.close();
        } else {
            this._out.flush();
        }
        this._releaseBuffers();
    }

    private final int _shortUTF8Encode(char[] cArray, int n, int n2) {
        int n3;
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        do {
            if ((n3 = cArray[n]) > 127) {
                return this._shortUTF8Encode2(cArray, n, n2, n4);
            }
            byArray[n4++] = (byte)n3;
        } while (++n < n2);
        n3 = n4 - this._outputTail;
        this._outputTail = n4;
        return n3;
    }

    private final int _shortUTF8Encode2(char[] cArray, int n, int n2, int n3) {
        int n4;
        byte[] byArray = this._outputBuffer;
        while (n < n2) {
            if ((n4 = cArray[n++]) <= 127) {
                byArray[n3++] = (byte)n4;
                continue;
            }
            if (n4 < 2048) {
                byArray[n3++] = (byte)(0xC0 | n4 >> 6);
                byArray[n3++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 < 55296 || n4 > 57343) {
                byArray[n3++] = (byte)(0xE0 | n4 >> 12);
                byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 > 56319) {
                this._throwIllegalSurrogate(n4);
            }
            if (n >= n2) {
                this._throwIllegalSurrogate(n4);
            }
            if ((n4 = this._convertSurrogate(n4, cArray[n++])) > 0x10FFFF) {
                this._throwIllegalSurrogate(n4);
            }
            byArray[n3++] = (byte)(0xF0 | n4 >> 18);
            byArray[n3++] = (byte)(0x80 | n4 >> 12 & 0x3F);
            byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
            byArray[n3++] = (byte)(0x80 | n4 & 0x3F);
        }
        n4 = n3 - this._outputTail;
        this._outputTail = n3;
        return n4;
    }

    private final int _shortUTF8Encode(String string, int n, int n2) {
        int n3;
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        do {
            if ((n3 = string.charAt(n)) > 127) {
                return this._shortUTF8Encode2(string, n, n2, n4);
            }
            byArray[n4++] = (byte)n3;
        } while (++n < n2);
        n3 = n4 - this._outputTail;
        this._outputTail = n4;
        return n3;
    }

    private final int _shortUTF8Encode2(String string, int n, int n2, int n3) {
        int n4;
        byte[] byArray = this._outputBuffer;
        while (n < n2) {
            char c2 = string.charAt(n++);
            n4 = c2;
            if (c2 <= '\u007f') {
                byArray[n3++] = (byte)n4;
                continue;
            }
            if (n4 < 2048) {
                byArray[n3++] = (byte)(0xC0 | n4 >> 6);
                byArray[n3++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 < 55296 || n4 > 57343) {
                byArray[n3++] = (byte)(0xE0 | n4 >> 12);
                byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 > 56319) {
                this._throwIllegalSurrogate(n4);
            }
            if (n >= n2) {
                this._throwIllegalSurrogate(n4);
            }
            if ((n4 = this._convertSurrogate(n4, string.charAt(n++))) > 0x10FFFF) {
                this._throwIllegalSurrogate(n4);
            }
            byArray[n3++] = (byte)(0xF0 | n4 >> 18);
            byArray[n3++] = (byte)(0x80 | n4 >> 12 & 0x3F);
            byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
            byArray[n3++] = (byte)(0x80 | n4 & 0x3F);
        }
        n4 = n3 - this._outputTail;
        this._outputTail = n3;
        return n4;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _mediumUTF8Encode(char[] cArray, int n, int n2) {
        int n3 = this._outputEnd - 4;
        block0: while (n < n2) {
            int n4;
            if (this._outputTail >= n3) {
                this._flushBuffer();
            }
            if ((n4 = cArray[n++]) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)n4;
                int n5 = n2 - n;
                n4 = n3 - this._outputTail;
                if (n5 > n4) {
                    n5 = n4;
                }
                n5 += n;
                while (true) {
                    if (n >= n5) continue block0;
                    if ((n4 = cArray[n++]) > 127) break;
                    this._outputBuffer[this._outputTail++] = (byte)n4;
                }
            }
            if (n4 < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | n4 >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 < 55296 || n4 > 57343) {
                this._outputBuffer[this._outputTail++] = (byte)(0xE0 | n4 >> 12);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 > 56319) {
                this._throwIllegalSurrogate(n4);
            }
            if (n >= n2) {
                this._throwIllegalSurrogate(n4);
            }
            if ((n4 = this._convertSurrogate(n4, cArray[n++])) > 0x10FFFF) {
                this._throwIllegalSurrogate(n4);
            }
            this._outputBuffer[this._outputTail++] = (byte)(0xF0 | n4 >> 18);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 >> 12 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 >> 6 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 & 0x3F);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void _mediumUTF8Encode(String string, int n, int n2) {
        int n3 = this._outputEnd - 4;
        block0: while (n < n2) {
            int n4;
            if (this._outputTail >= n3) {
                this._flushBuffer();
            }
            if ((n4 = string.charAt(n++)) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)n4;
                int n5 = n2 - n;
                n4 = n3 - this._outputTail;
                if (n5 > n4) {
                    n5 = n4;
                }
                n5 += n;
                while (true) {
                    if (n >= n5) continue block0;
                    char c2 = string.charAt(n++);
                    n4 = c2;
                    if (c2 > '\u007f') break;
                    this._outputBuffer[this._outputTail++] = (byte)n4;
                }
            }
            if (n4 < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | n4 >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 < 55296 || n4 > 57343) {
                this._outputBuffer[this._outputTail++] = (byte)(0xE0 | n4 >> 12);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 & 0x3F);
                continue;
            }
            if (n4 > 56319) {
                this._throwIllegalSurrogate(n4);
            }
            if (n >= n2) {
                this._throwIllegalSurrogate(n4);
            }
            if ((n4 = this._convertSurrogate(n4, string.charAt(n++))) > 0x10FFFF) {
                this._throwIllegalSurrogate(n4);
            }
            this._outputBuffer[this._outputTail++] = (byte)(0xF0 | n4 >> 18);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 >> 12 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 >> 6 & 0x3F);
            this._outputBuffer[this._outputTail++] = (byte)(0x80 | n4 & 0x3F);
        }
        return;
    }

    private int _convertSurrogate(int n, int n2) {
        if (n2 < 56320 || n2 > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(n) + ", second 0x" + Integer.toHexString(n2) + "; illegal combination");
        }
        return 65536 + (n - 55296 << 10) + (n2 - 56320);
    }

    private void _throwIllegalSurrogate(int n) {
        if (n > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(n) + ") to output; max is 0x10FFFF as per RFC 4627");
        }
        if (n >= 55296) {
            if (n <= 56319) {
                throw new IllegalArgumentException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(n) + ")");
            }
            throw new IllegalArgumentException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(n) + ")");
        }
        throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(n) + ") to output");
    }

    private final void _ensureRoomForOutput(int n) {
        if (this._outputTail + n >= this._outputEnd) {
            this._flushBuffer();
        }
    }

    private final void _writeByte(byte by) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
    }

    private final void _writeBytes(byte by, byte by2) {
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
    }

    private final void _writeBytes(byte by, byte by2, byte by3) {
        if (this._outputTail + 2 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
    }

    private final void _writeBytes(byte by, byte by2, byte by3, byte by4) {
        if (this._outputTail + 3 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by4;
    }

    private final void _writeBytes(byte by, byte by2, byte by3, byte by4, byte by5) {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by4;
        this._outputBuffer[this._outputTail++] = by5;
    }

    private final void _writeBytes(byte by, byte by2, byte by3, byte by4, byte by5, byte by6) {
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = by;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by4;
        this._outputBuffer[this._outputTail++] = by5;
        this._outputBuffer[this._outputTail++] = by6;
    }

    private final void _writeBytes(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (this._outputTail + n2 >= this._outputEnd) {
            this._writeBytesLong(byArray, n, n2);
            return;
        }
        System.arraycopy(byArray, n, this._outputBuffer, this._outputTail, n2);
        this._outputTail += n2;
    }

    private final int _writeBytes(InputStream inputStream, int n) {
        while (n > 0) {
            int n2 = this._outputEnd - this._outputTail;
            if (n2 <= 0) {
                this._flushBuffer();
                n2 = this._outputEnd - this._outputTail;
            }
            if (n2 > n) {
                n2 = n;
            }
            if ((n2 = inputStream.read(this._outputBuffer, this._outputTail, n2)) < 0) break;
            this._outputTail += n2;
            n -= n2;
        }
        return n;
    }

    private final void _writeBytesLong(byte[] byArray, int n, int n2) {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        while (true) {
            int n3 = Math.min(n2, this._outputEnd - this._outputTail);
            System.arraycopy(byArray, n, this._outputBuffer, this._outputTail, n3);
            this._outputTail += n3;
            if ((n2 -= n3) == 0) break;
            n += n3;
            this._flushBuffer();
        }
    }

    private void _writePositiveVInt(int n) {
        this._ensureRoomForOutput(5);
        byte by = (byte)(128 + (n & 0x3F));
        if ((n >>= 6) <= 127) {
            if (n > 0) {
                this._outputBuffer[this._outputTail++] = (byte)n;
            }
            this._outputBuffer[this._outputTail++] = by;
            return;
        }
        byte by2 = (byte)(n & 0x7F);
        if ((n >>= 7) <= 127) {
            this._outputBuffer[this._outputTail++] = (byte)n;
            this._outputBuffer[this._outputTail++] = by2;
            this._outputBuffer[this._outputTail++] = by;
            return;
        }
        byte by3 = (byte)(n & 0x7F);
        if ((n >>= 7) <= 127) {
            this._outputBuffer[this._outputTail++] = (byte)n;
            this._outputBuffer[this._outputTail++] = by3;
            this._outputBuffer[this._outputTail++] = by2;
            this._outputBuffer[this._outputTail++] = by;
            return;
        }
        byte by4 = (byte)(n & 0x7F);
        this._outputBuffer[this._outputTail++] = (byte)(n >> 7);
        this._outputBuffer[this._outputTail++] = by4;
        this._outputBuffer[this._outputTail++] = by3;
        this._outputBuffer[this._outputTail++] = by2;
        this._outputBuffer[this._outputTail++] = by;
    }

    private void _writeSignedVInt(int n) {
        this._writePositiveVInt(SmileUtil.zigzagEncode(n));
    }

    protected void _write7BitBinaryWithLength(byte[] byArray, int n, int n2) {
        int n3;
        this._writePositiveVInt(n2);
        while (n2 >= 7) {
            if (this._outputTail + 8 >= this._outputEnd) {
                this._flushBuffer();
            }
            n3 = byArray[n++];
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 1 & 0x7F);
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 2 & 0x7F);
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 3 & 0x7F);
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 4 & 0x7F);
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 5 & 0x7F);
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 6 & 0x7F);
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 7 & 0x7F);
            this._outputBuffer[this._outputTail++] = (byte)(n3 & 0x7F);
            n2 -= 7;
        }
        if (n2 > 0) {
            if (this._outputTail + 7 >= this._outputEnd) {
                this._flushBuffer();
            }
            n3 = byArray[n++];
            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 1 & 0x7F);
            if (n2 > 1) {
                n3 = (n3 & 1) << 8 | byArray[n++] & 0xFF;
                this._outputBuffer[this._outputTail++] = (byte)(n3 >> 2 & 0x7F);
                if (n2 > 2) {
                    n3 = (n3 & 3) << 8 | byArray[n++] & 0xFF;
                    this._outputBuffer[this._outputTail++] = (byte)(n3 >> 3 & 0x7F);
                    if (n2 > 3) {
                        n3 = (n3 & 7) << 8 | byArray[n++] & 0xFF;
                        this._outputBuffer[this._outputTail++] = (byte)(n3 >> 4 & 0x7F);
                        if (n2 > 4) {
                            n3 = (n3 & 0xF) << 8 | byArray[n++] & 0xFF;
                            this._outputBuffer[this._outputTail++] = (byte)(n3 >> 5 & 0x7F);
                            if (n2 > 5) {
                                n3 = (n3 & 0x1F) << 8 | byArray[n] & 0xFF;
                                this._outputBuffer[this._outputTail++] = (byte)(n3 >> 6 & 0x7F);
                                this._outputBuffer[this._outputTail++] = (byte)(n3 & 0x3F);
                                return;
                            }
                            this._outputBuffer[this._outputTail++] = (byte)(n3 & 0x1F);
                            return;
                        }
                        this._outputBuffer[this._outputTail++] = (byte)(n3 & 0xF);
                        return;
                    }
                    this._outputBuffer[this._outputTail++] = (byte)(n3 & 7);
                    return;
                }
                this._outputBuffer[this._outputTail++] = (byte)(n3 & 3);
                return;
            }
            this._outputBuffer[this._outputTail++] = (byte)(n3 & 1);
        }
    }

    protected int _write7BitBinaryWithLength(InputStream inputStream, int n, byte[] byArray) {
        int n2;
        this._writePositiveVInt(n);
        int n3 = 0;
        int n4 = 0;
        int n5 = -7;
        while (n >= 7) {
            if (n3 > n5) {
                n4 = this._readMore(inputStream, byArray, n3, n4, n);
                n3 = 0;
                if (n4 < 7) {
                    n -= n4;
                    break;
                }
                n5 = n4 - 7;
            }
            if (this._outputTail + 8 >= this._outputEnd) {
                this._flushBuffer();
            }
            n2 = byArray[n3++];
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 1 & 0x7F);
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 2 & 0x7F);
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 3 & 0x7F);
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 4 & 0x7F);
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 5 & 0x7F);
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 6 & 0x7F);
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 7 & 0x7F);
            this._outputBuffer[this._outputTail++] = (byte)(n2 & 0x7F);
            n -= 7;
        }
        if (n > 0) {
            if (this._outputTail + 7 >= this._outputEnd) {
                this._flushBuffer();
            }
            if ((n4 = this._readMore(inputStream, byArray, n3, n4, n)) > 0) {
                n -= n4;
                n2 = byArray[0];
                this._outputBuffer[this._outputTail++] = (byte)(n2 >> 1 & 0x7F);
                if (n4 > 1) {
                    n2 = (n2 & 1) << 8 | byArray[1] & 0xFF;
                    this._outputBuffer[this._outputTail++] = (byte)(n2 >> 2 & 0x7F);
                    if (n4 > 2) {
                        n2 = (n2 & 3) << 8 | byArray[2] & 0xFF;
                        this._outputBuffer[this._outputTail++] = (byte)(n2 >> 3 & 0x7F);
                        if (n4 > 3) {
                            n2 = (n2 & 7) << 8 | byArray[3] & 0xFF;
                            this._outputBuffer[this._outputTail++] = (byte)(n2 >> 4 & 0x7F);
                            if (n4 > 4) {
                                n2 = (n2 & 0xF) << 8 | byArray[4] & 0xFF;
                                this._outputBuffer[this._outputTail++] = (byte)(n2 >> 5 & 0x7F);
                                if (n4 > 5) {
                                    n2 = (n2 & 0x1F) << 8 | byArray[5] & 0xFF;
                                    this._outputBuffer[this._outputTail++] = (byte)(n2 >> 6 & 0x7F);
                                    this._outputBuffer[this._outputTail++] = (byte)(n2 & 0x3F);
                                } else {
                                    this._outputBuffer[this._outputTail++] = (byte)(n2 & 0x1F);
                                }
                            } else {
                                this._outputBuffer[this._outputTail++] = (byte)(n2 & 0xF);
                            }
                        } else {
                            this._outputBuffer[this._outputTail++] = (byte)(n2 & 7);
                        }
                    } else {
                        this._outputBuffer[this._outputTail++] = (byte)(n2 & 3);
                    }
                } else {
                    this._outputBuffer[this._outputTail++] = (byte)(n2 & 1);
                }
            }
        }
        return n;
    }

    private int _readMore(InputStream inputStream, byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n < n2) {
            byArray[n4++] = byArray[n++];
        }
        n2 = n4;
        n3 = Math.min(n3, byArray.length);
        while ((n = n3 - n2) != 0) {
            if ((n = inputStream.read(byArray, n2, n)) < 0) {
                return n2;
            }
            if ((n2 += n) < 7) continue;
        }
        return n2;
    }

    @Override
    protected void _releaseBuffers() {
        Object[] objectArray = this._outputBuffer;
        if (this._outputBuffer != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer((byte[])objectArray);
        }
        objectArray = this._seenNames;
        if (this._seenNames != null && objectArray.length == 64) {
            this._seenNames = null;
            if (this._seenNameCount > 0) {
                Arrays.fill(objectArray, null);
            }
            this._smileBufferRecycler.releaseSeenNamesBuffer((SmileGenerator$SharedStringNode[])objectArray);
        }
        objectArray = this._seenStringValues;
        if (this._seenStringValues != null && objectArray.length == 64) {
            this._seenStringValues = null;
            if (this._seenStringValueCount > 0) {
                Arrays.fill(objectArray, null);
            }
            this._smileBufferRecycler.releaseSeenStringValuesBuffer((SmileGenerator$SharedStringNode[])objectArray);
        }
    }

    protected final void _flushBuffer() {
        if (this._outputTail > 0) {
            this._bytesWritten += this._outputTail;
            this._out.write(this._outputBuffer, 0, this._outputTail);
            this._outputTail = 0;
        }
    }

    private final int _findSeenName(String string) {
        int n = string.hashCode();
        Object object = this._seenNames[n & this._seenNames.length - 1];
        if (object == null) {
            return -1;
        }
        SmileGenerator$SharedStringNode smileGenerator$SharedStringNode = object;
        if (smileGenerator$SharedStringNode.value == string) {
            return smileGenerator$SharedStringNode.index;
        }
        while ((smileGenerator$SharedStringNode = smileGenerator$SharedStringNode.next) != null) {
            if (smileGenerator$SharedStringNode.value != string) continue;
            return smileGenerator$SharedStringNode.index;
        }
        smileGenerator$SharedStringNode = object;
        do {
            if (((String)(object = smileGenerator$SharedStringNode.value)).hashCode() != n || !((String)object).equals(string)) continue;
            return smileGenerator$SharedStringNode.index;
        } while ((smileGenerator$SharedStringNode = smileGenerator$SharedStringNode.next) != null);
        return -1;
    }

    private final void _addSeenName(String string) {
        int n;
        if (this._seenNameCount == this._seenNames.length) {
            if (this._seenNameCount == 1024) {
                Arrays.fill(this._seenNames, null);
                this._seenNameCount = 0;
            } else {
                SmileGenerator$SharedStringNode[] smileGenerator$SharedStringNodeArray = this._seenNames;
                this._seenNames = new SmileGenerator$SharedStringNode[1024];
                for (SmileGenerator$SharedStringNode smileGenerator$SharedStringNode : smileGenerator$SharedStringNodeArray) {
                    while (smileGenerator$SharedStringNode != null) {
                        int n2 = smileGenerator$SharedStringNode.value.hashCode() & 0x3FF;
                        SmileGenerator$SharedStringNode smileGenerator$SharedStringNode2 = smileGenerator$SharedStringNode.next;
                        smileGenerator$SharedStringNode.next = this._seenNames[n2];
                        this._seenNames[n2] = smileGenerator$SharedStringNode;
                        smileGenerator$SharedStringNode = smileGenerator$SharedStringNode2;
                    }
                }
            }
        }
        if (SmileGenerator._validBackRef(n = this._seenNameCount)) {
            int n3 = string.hashCode() & this._seenNames.length - 1;
            this._seenNames[n3] = new SmileGenerator$SharedStringNode(string, n, this._seenNames[n3]);
        }
        this._seenNameCount = n + 1;
    }

    private final int _findSeenStringValue(String string) {
        int n = string.hashCode();
        Object object = this._seenStringValues[n & this._seenStringValues.length - 1];
        if (object != null) {
            SmileGenerator$SharedStringNode smileGenerator$SharedStringNode = object;
            do {
                if (smileGenerator$SharedStringNode.value != string) continue;
                return smileGenerator$SharedStringNode.index;
            } while ((smileGenerator$SharedStringNode = smileGenerator$SharedStringNode.next) != null);
            smileGenerator$SharedStringNode = object;
            do {
                if (((String)(object = smileGenerator$SharedStringNode.value)).hashCode() != n || !((String)object).equals(string)) continue;
                return smileGenerator$SharedStringNode.index;
            } while ((smileGenerator$SharedStringNode = smileGenerator$SharedStringNode.next) != null);
        }
        return -1;
    }

    private final void _addSeenStringValue(String string) {
        int n;
        if (this._seenStringValueCount == this._seenStringValues.length) {
            if (this._seenStringValueCount == 1024) {
                Arrays.fill(this._seenStringValues, null);
                this._seenStringValueCount = 0;
            } else {
                SmileGenerator$SharedStringNode[] smileGenerator$SharedStringNodeArray = this._seenStringValues;
                this._seenStringValues = new SmileGenerator$SharedStringNode[1024];
                for (SmileGenerator$SharedStringNode smileGenerator$SharedStringNode : smileGenerator$SharedStringNodeArray) {
                    while (smileGenerator$SharedStringNode != null) {
                        int n2 = smileGenerator$SharedStringNode.value.hashCode() & 0x3FF;
                        SmileGenerator$SharedStringNode smileGenerator$SharedStringNode2 = smileGenerator$SharedStringNode.next;
                        smileGenerator$SharedStringNode.next = this._seenStringValues[n2];
                        this._seenStringValues[n2] = smileGenerator$SharedStringNode;
                        smileGenerator$SharedStringNode = smileGenerator$SharedStringNode2;
                    }
                }
            }
        }
        if (SmileGenerator._validBackRef(n = this._seenStringValueCount)) {
            int n3 = string.hashCode() & this._seenStringValues.length - 1;
            this._seenStringValues[n3] = new SmileGenerator$SharedStringNode(string, n, this._seenStringValues[n3]);
        }
        this._seenStringValueCount = n + 1;
    }

    private static final boolean _validBackRef(int n) {
        return (n & 0xFF) < 254;
    }

    protected long outputOffset() {
        return this._bytesWritten + this._outputTail;
    }

    protected UnsupportedOperationException _notSupported() {
        return new UnsupportedOperationException();
    }
}

