/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonEncoding;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonFactory;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerationException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Version;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.format.InputAccessor;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.format.MatchStrength;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.PackageVersion;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileGenerator$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileParser$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileParserBootstrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class SmileFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_SMILE = "Smile";
    static final int DEFAULT_SMILE_PARSER_FEATURE_FLAGS = SmileParser$Feature.collectDefaults();
    static final int DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS = SmileGenerator$Feature.collectDefaults();
    protected boolean _cfgDelegateToTextual;
    protected int _smileParserFeatures;
    protected int _smileGeneratorFeatures;

    public SmileFactory() {
        this(null);
    }

    public SmileFactory(ObjectCodec objectCodec) {
        super(objectCodec);
        this._smileParserFeatures = DEFAULT_SMILE_PARSER_FEATURE_FLAGS;
        this._smileGeneratorFeatures = DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS;
    }

    public SmileFactory(SmileFactory smileFactory, ObjectCodec objectCodec) {
        super(smileFactory, objectCodec);
        this._cfgDelegateToTextual = smileFactory._cfgDelegateToTextual;
        this._smileParserFeatures = smileFactory._smileParserFeatures;
        this._smileGeneratorFeatures = smileFactory._smileGeneratorFeatures;
    }

    @Override
    public SmileFactory copy() {
        this._checkInvalidCopy(SmileFactory.class);
        return new SmileFactory(this, null);
    }

    public void delegateToTextual(boolean bl) {
        this._cfgDelegateToTextual = bl;
    }

    @Override
    protected Object readResolve() {
        return new SmileFactory(this, this._objectCodec);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_SMILE;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor inputAccessor) {
        return SmileParserBootstrapper.hasSmileFormat(inputAccessor);
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return true;
    }

    public Class<SmileParser$Feature> getFormatReadFeatureType() {
        return SmileParser$Feature.class;
    }

    public Class<SmileGenerator$Feature> getFormatWriteFeatureType() {
        return SmileGenerator$Feature.class;
    }

    public final SmileFactory configure(SmileParser$Feature smileParser$Feature, boolean bl) {
        if (bl) {
            this.enable(smileParser$Feature);
        } else {
            this.disable(smileParser$Feature);
        }
        return this;
    }

    public SmileFactory enable(SmileParser$Feature smileParser$Feature) {
        this._smileParserFeatures |= smileParser$Feature.getMask();
        return this;
    }

    public SmileFactory disable(SmileParser$Feature smileParser$Feature) {
        this._smileParserFeatures &= ~smileParser$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(SmileParser$Feature smileParser$Feature) {
        return (this._smileParserFeatures & smileParser$Feature.getMask()) != 0;
    }

    public final SmileFactory configure(SmileGenerator$Feature smileGenerator$Feature, boolean bl) {
        if (bl) {
            this.enable(smileGenerator$Feature);
        } else {
            this.disable(smileGenerator$Feature);
        }
        return this;
    }

    public SmileFactory enable(SmileGenerator$Feature smileGenerator$Feature) {
        this._smileGeneratorFeatures |= smileGenerator$Feature.getMask();
        return this;
    }

    public SmileFactory disable(SmileGenerator$Feature smileGenerator$Feature) {
        this._smileGeneratorFeatures &= ~smileGenerator$Feature.getMask();
        return this;
    }

    public final boolean isEnabled(SmileGenerator$Feature smileGenerator$Feature) {
        return (this._smileGeneratorFeatures & smileGenerator$Feature.getMask()) != 0;
    }

    @Override
    public SmileParser createParser(File file) {
        IOContext iOContext = this._createContext(file, true);
        return this._createParser(this._decorate(new FileInputStream(file), iOContext), iOContext);
    }

    @Override
    public SmileParser createParser(URL uRL) {
        IOContext iOContext = this._createContext(uRL, true);
        return this._createParser(this._decorate(this._optimizedStreamFromURL(uRL), iOContext), iOContext);
    }

    @Override
    public SmileParser createParser(InputStream inputStream) {
        IOContext iOContext = this._createContext(inputStream, false);
        return this._createParser(this._decorate(inputStream, iOContext), iOContext);
    }

    @Override
    public SmileParser createParser(byte[] byArray) {
        return this.createParser(byArray, 0, byArray.length);
    }

    @Override
    public SmileParser createParser(byte[] byArray, int n, int n2) {
        InputStream inputStream;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createParser(this._decorate(inputStream, iOContext), iOContext);
        }
        return this._createParser(byArray, n, n2, iOContext);
    }

    @Override
    public SmileGenerator createGenerator(OutputStream outputStream, JsonEncoding object) {
        object = this._createContext(outputStream, false);
        return this._createGenerator(this._decorate(outputStream, (IOContext)object), (IOContext)object);
    }

    @Override
    public SmileGenerator createGenerator(OutputStream outputStream) {
        IOContext iOContext = this._createContext(outputStream, false);
        return this._createGenerator(this._decorate(outputStream, iOContext), iOContext);
    }

    @Override
    protected SmileParser _createParser(InputStream inputStream, IOContext iOContext) {
        return new SmileParserBootstrapper(iOContext, inputStream).constructParser(this._factoryFeatures, this._parserFeatures, this._smileParserFeatures, this._objectCodec, this._byteSymbolCanonicalizer);
    }

    @Override
    protected JsonParser _createParser(Reader reader, IOContext iOContext) {
        if (this._cfgDelegateToTextual) {
            return super._createParser(reader, iOContext);
        }
        return (JsonParser)this._nonByteSource();
    }

    @Override
    protected JsonParser _createParser(char[] cArray, int n, int n2, IOContext iOContext, boolean bl) {
        if (this._cfgDelegateToTextual) {
            return super._createParser(cArray, n, n2, iOContext, bl);
        }
        return (JsonParser)this._nonByteSource();
    }

    @Override
    protected SmileParser _createParser(byte[] byArray, int n, int n2, IOContext iOContext) {
        return new SmileParserBootstrapper(iOContext, byArray, n, n2).constructParser(this._factoryFeatures, this._parserFeatures, this._smileParserFeatures, this._objectCodec, this._byteSymbolCanonicalizer);
    }

    @Override
    protected JsonGenerator _createGenerator(Writer writer, IOContext iOContext) {
        if (this._cfgDelegateToTextual) {
            return super._createGenerator(writer, iOContext);
        }
        return (JsonGenerator)this._nonByteTarget();
    }

    @Override
    protected JsonGenerator _createUTF8Generator(OutputStream outputStream, IOContext iOContext) {
        return this._createGenerator(outputStream, iOContext);
    }

    @Override
    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) {
        if (this._cfgDelegateToTextual) {
            return super._createWriter(outputStream, jsonEncoding, iOContext);
        }
        return (Writer)this._nonByteTarget();
    }

    protected <T> T _nonByteSource() {
        throw new UnsupportedOperationException("Can not create generator for character-based (not byte-based) source");
    }

    protected <T> T _nonByteTarget() {
        throw new UnsupportedOperationException("Can not create generator for character-based (not byte-based) target");
    }

    protected SmileGenerator _createGenerator(OutputStream closeable, IOContext iOContext) {
        int n = this._smileGeneratorFeatures;
        closeable = new SmileGenerator(iOContext, this._generatorFeatures, n, this._objectCodec, (OutputStream)closeable);
        if ((n & SmileGenerator$Feature.WRITE_HEADER.getMask()) != 0) {
            ((SmileGenerator)closeable).writeHeader();
        } else {
            if ((n & SmileGenerator$Feature.CHECK_SHARED_STRING_VALUES.getMask()) != 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but CHECK_SHARED_STRING_VALUES enabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or disable CHECK_SHARED_STRING_VALUES to resolve)");
            }
            if ((n & SmileGenerator$Feature.ENCODE_BINARY_AS_7BIT.getMask()) == 0) {
                throw new JsonGenerationException("Inconsistent settings: WRITE_HEADER disabled, but ENCODE_BINARY_AS_7BIT disabled; can not construct generator due to possible data loss (either enable WRITE_HEADER, or ENCODE_BINARY_AS_7BIT to resolve)");
            }
        }
        return closeable;
    }
}

