/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.BufferRecycler;
import java.io.OutputStream;
import java.util.LinkedList;

public final class ByteArrayBuilder
extends OutputStream {
    public static final byte[] NO_BYTES = new byte[0];
    private static final int INITIAL_BLOCK_SIZE = 500;
    private static final int MAX_BLOCK_SIZE = 262144;
    static final int DEFAULT_BLOCK_ARRAY_SIZE = 40;
    private final BufferRecycler _bufferRecycler;
    private final LinkedList<byte[]> _pastBlocks = new LinkedList();
    private int _pastLen;
    private byte[] _currBlock;
    private int _currBlockPtr;

    public ByteArrayBuilder() {
        this(null);
    }

    public ByteArrayBuilder(BufferRecycler bufferRecycler) {
        this(bufferRecycler, 500);
    }

    public ByteArrayBuilder(int n) {
        this(null, n);
    }

    public ByteArrayBuilder(BufferRecycler bufferRecycler, int n) {
        this._bufferRecycler = bufferRecycler;
        this._currBlock = bufferRecycler == null ? new byte[n] : bufferRecycler.allocByteBuffer(2);
    }

    public final void reset() {
        this._pastLen = 0;
        this._currBlockPtr = 0;
        if (!this._pastBlocks.isEmpty()) {
            this._pastBlocks.clear();
        }
    }

    public final void release() {
        this.reset();
        if (this._bufferRecycler != null && this._currBlock != null) {
            this._bufferRecycler.releaseByteBuffer(2, this._currBlock);
            this._currBlock = null;
        }
    }

    public final void append(int n) {
        if (this._currBlockPtr >= this._currBlock.length) {
            this._allocMore();
        }
        this._currBlock[this._currBlockPtr++] = (byte)n;
    }

    public final void appendTwoBytes(int n) {
        if (this._currBlockPtr + 1 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n;
            return;
        }
        this.append(n >> 8);
        this.append(n);
    }

    public final void appendThreeBytes(int n) {
        if (this._currBlockPtr + 2 < this._currBlock.length) {
            this._currBlock[this._currBlockPtr++] = (byte)(n >> 16);
            this._currBlock[this._currBlockPtr++] = (byte)(n >> 8);
            this._currBlock[this._currBlockPtr++] = (byte)n;
            return;
        }
        this.append(n >> 16);
        this.append(n >> 8);
        this.append(n);
    }

    public final byte[] toByteArray() {
        int n = this._pastLen + this._currBlockPtr;
        if (n == 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (byte[] byArray2 : this._pastBlocks) {
            int n3 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            n2 += n3;
        }
        System.arraycopy(this._currBlock, 0, byArray, n2, this._currBlockPtr);
        if ((n2 += this._currBlockPtr) != n) {
            throw new RuntimeException("Internal error: total len assumed to be " + n + ", copied " + n2 + " bytes");
        }
        if (!this._pastBlocks.isEmpty()) {
            this.reset();
        }
        return byArray;
    }

    public final byte[] resetAndGetFirstSegment() {
        this.reset();
        return this._currBlock;
    }

    public final byte[] finishCurrentSegment() {
        this._allocMore();
        return this._currBlock;
    }

    public final byte[] completeAndCoalesce(int n) {
        this._currBlockPtr = n;
        return this.toByteArray();
    }

    public final byte[] getCurrentSegment() {
        return this._currBlock;
    }

    public final void setCurrentSegmentLength(int n) {
        this._currBlockPtr = n;
    }

    public final int getCurrentSegmentLength() {
        return this._currBlockPtr;
    }

    @Override
    public final void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public final void write(byte[] byArray, int n, int n2) {
        while (true) {
            int n3;
            if ((n3 = Math.min(this._currBlock.length - this._currBlockPtr, n2)) > 0) {
                System.arraycopy(byArray, n, this._currBlock, this._currBlockPtr, n3);
                n += n3;
                this._currBlockPtr += n3;
                n2 -= n3;
            }
            if (n2 <= 0) break;
            this._allocMore();
        }
    }

    @Override
    public final void write(int n) {
        this.append(n);
    }

    @Override
    public final void close() {
    }

    @Override
    public final void flush() {
    }

    private void _allocMore() {
        this._pastLen += this._currBlock.length;
        int n = Math.max(this._pastLen >> 1, 1000);
        if (n > 262144) {
            n = 262144;
        }
        this._pastBlocks.add(this._currBlock);
        this._currBlock = new byte[n];
        this._currBlockPtr = 0;
    }
}

