/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonFactory$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer$Bucket;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.BitSet;

public final class CharsToNameCanonicalizer {
    public static final int HASH_MULT = 33;
    protected static final int DEFAULT_T_SIZE = 64;
    protected static final int MAX_T_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    static final int MAX_COLL_CHAIN_LENGTH = 100;
    static final CharsToNameCanonicalizer sBootstrapSymbolTable = new CharsToNameCanonicalizer();
    protected CharsToNameCanonicalizer _parent;
    private final int _hashSeed;
    protected final int _flags;
    protected boolean _canonicalize;
    protected String[] _symbols;
    protected CharsToNameCanonicalizer$Bucket[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected int _longestCollisionList;
    protected boolean _dirty;
    protected BitSet _overflows;

    public static CharsToNameCanonicalizer createRoot() {
        long l = System.currentTimeMillis();
        return CharsToNameCanonicalizer.createRoot((int)l + (int)(l >>> 32) | 1);
    }

    protected static CharsToNameCanonicalizer createRoot(int n) {
        return sBootstrapSymbolTable.makeOrphan(n);
    }

    private CharsToNameCanonicalizer() {
        this._canonicalize = true;
        this._flags = -1;
        this._dirty = true;
        this._hashSeed = 0;
        this._longestCollisionList = 0;
        this.initTables(64);
    }

    private void initTables(int n) {
        this._symbols = new String[n];
        this._buckets = new CharsToNameCanonicalizer$Bucket[n >> 1];
        this._indexMask = n - 1;
        this._size = 0;
        this._longestCollisionList = 0;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n);
    }

    private static int _thresholdSize(int n) {
        return n - (n >> 2);
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer charsToNameCanonicalizer, int n, String[] stringArray, CharsToNameCanonicalizer$Bucket[] charsToNameCanonicalizer$BucketArray, int n2, int n3, int n4) {
        this._parent = charsToNameCanonicalizer;
        this._flags = n;
        this._canonicalize = JsonFactory$Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n);
        this._symbols = stringArray;
        this._buckets = charsToNameCanonicalizer$BucketArray;
        this._size = n2;
        this._hashSeed = n3;
        int n5 = stringArray.length;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n5);
        this._indexMask = n5 - 1;
        this._longestCollisionList = n4;
        this._dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CharsToNameCanonicalizer makeChild(int n) {
        int n2;
        int n3;
        int n4;
        CharsToNameCanonicalizer$Bucket[] charsToNameCanonicalizer$BucketArray;
        String[] stringArray;
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        synchronized (charsToNameCanonicalizer) {
            stringArray = this._symbols;
            charsToNameCanonicalizer$BucketArray = this._buckets;
            n4 = this._size;
            n3 = this._hashSeed;
            n2 = this._longestCollisionList;
        }
        return new CharsToNameCanonicalizer(this, n, stringArray, charsToNameCanonicalizer$BucketArray, n4, n3, n2);
    }

    private CharsToNameCanonicalizer makeOrphan(int n) {
        return new CharsToNameCanonicalizer(null, -1, this._symbols, this._buckets, this._size, n, this._longestCollisionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeChild(CharsToNameCanonicalizer charsToNameCanonicalizer) {
        if (charsToNameCanonicalizer.size() > 12000) {
            CharsToNameCanonicalizer charsToNameCanonicalizer2 = this;
            synchronized (charsToNameCanonicalizer2) {
                this.initTables(256);
                this._dirty = false;
                return;
            }
        }
        if (charsToNameCanonicalizer.size() <= this.size()) {
            return;
        }
        CharsToNameCanonicalizer charsToNameCanonicalizer3 = this;
        synchronized (charsToNameCanonicalizer3) {
            this._symbols = charsToNameCanonicalizer._symbols;
            this._buckets = charsToNameCanonicalizer._buckets;
            this._size = charsToNameCanonicalizer._size;
            this._sizeThreshold = charsToNameCanonicalizer._sizeThreshold;
            this._indexMask = charsToNameCanonicalizer._indexMask;
            this._longestCollisionList = charsToNameCanonicalizer._longestCollisionList;
            this._dirty = false;
            return;
        }
    }

    public final void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null && this._canonicalize) {
            this._parent.mergeChild(this);
            this._dirty = false;
        }
    }

    public final int size() {
        return this._size;
    }

    public final int bucketCount() {
        return this._symbols.length;
    }

    public final boolean maybeDirty() {
        return this._dirty;
    }

    public final int hashSeed() {
        return this._hashSeed;
    }

    public final int collisionCount() {
        int n = 0;
        CharsToNameCanonicalizer$Bucket[] charsToNameCanonicalizer$BucketArray = this._buckets;
        int n2 = this._buckets.length;
        for (int k = 0; k < n2; ++k) {
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket = charsToNameCanonicalizer$BucketArray[k];
            if (charsToNameCanonicalizer$Bucket == null) continue;
            n += charsToNameCanonicalizer$Bucket.length;
        }
        return n;
    }

    public final int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public final String findSymbol(char[] cArray, int n, int n2, int n3) {
        if (n2 <= 0) {
            return "";
        }
        if (!this._canonicalize) {
            return new String(cArray, n, n2);
        }
        int n4 = this._hashToIndex(n3);
        String string = this._symbols[n4];
        if (string != null) {
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket;
            if (string.length() == n2) {
                int n5 = 0;
                while (string.charAt(n5) == cArray[n + n5]) {
                    if (++n5 != n2) continue;
                    return string;
                }
            }
            if ((charsToNameCanonicalizer$Bucket = this._buckets[n4 >> 1]) != null) {
                string = charsToNameCanonicalizer$Bucket.has(cArray, n, n2);
                if (string != null) {
                    return string;
                }
                string = this._findSymbol2(cArray, n, n2, charsToNameCanonicalizer$Bucket.next);
                if (string != null) {
                    return string;
                }
            }
        }
        return this._addSymbol(cArray, n, n2, n3, n4);
    }

    private String _findSymbol2(char[] cArray, int n, int n2, CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket) {
        while (charsToNameCanonicalizer$Bucket != null) {
            String string = charsToNameCanonicalizer$Bucket.has(cArray, n, n2);
            if (string != null) {
                return string;
            }
            charsToNameCanonicalizer$Bucket = charsToNameCanonicalizer$Bucket.next;
        }
        return null;
    }

    private String _addSymbol(char[] object, int n, int n2, int n3, int n4) {
        if (!this._dirty) {
            this.copyArrays();
            this._dirty = true;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            n4 = this._hashToIndex(this.calcHash((char[])object, n, n2));
        }
        object = new String((char[])object, n, n2);
        if (JsonFactory$Feature.INTERN_FIELD_NAMES.enabledIn(this._flags)) {
            object = InternCache.instance.intern((String)object);
        }
        ++this._size;
        if (this._symbols[n4] == null) {
            this._symbols[n4] = object;
        } else {
            n = n4 >> 1;
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket = new CharsToNameCanonicalizer$Bucket((String)object, this._buckets[n]);
            n3 = charsToNameCanonicalizer$Bucket.length;
            if (n3 > 100) {
                this._handleSpillOverflow(n, charsToNameCanonicalizer$Bucket);
            } else {
                this._buckets[n] = charsToNameCanonicalizer$Bucket;
                this._longestCollisionList = Math.max(n3, this._longestCollisionList);
            }
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private void _handleSpillOverflow(int var1_1, CharsToNameCanonicalizer$Bucket var2_2) {
        block3: {
            if (this._overflows != null) break block3;
            this._overflows = new BitSet();
            ** GOTO lbl-1000
        }
        if (this._overflows.get(var1_1)) {
            if (JsonFactory$Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(this._flags)) {
                this.reportTooManyCollisions(100);
            }
            this._canonicalize = false;
        } else lbl-1000:
        // 2 sources

        {
            this._overflows.set(var1_1);
        }
        this._symbols[var1_1 + var1_1] = var2_2.symbol;
        this._buckets[var1_1] = null;
        this._size -= var2_2.length;
        this._longestCollisionList = -1;
    }

    public final int _hashToIndex(int n) {
        int n2 = n + (n >>> 15);
        int n3 = n2 ^ n2 << 7;
        return n3 + (n3 >>> 3) & this._indexMask;
    }

    public final int calcHash(char[] cArray, int n, int n2) {
        int n3 = this._hashSeed;
        int n4 = n;
        n += n2;
        while (n4 < n) {
            n3 = n3 * 33 + cArray[n4];
            ++n4;
        }
        if (n3 == 0) {
            return 1;
        }
        return n3;
    }

    public final int calcHash(String string) {
        int n = string.length();
        int n2 = this._hashSeed;
        for (int k = 0; k < n; ++k) {
            n2 = n2 * 33 + string.charAt(k);
        }
        if (n2 == 0) {
            return 1;
        }
        return n2;
    }

    private void copyArrays() {
        Object[] objectArray = this._symbols;
        this._symbols = Arrays.copyOf(objectArray, objectArray.length);
        objectArray = this._buckets;
        this._buckets = (CharsToNameCanonicalizer$Bucket[])Arrays.copyOf(objectArray, objectArray.length);
    }

    private void rehash() {
        int n;
        Object object;
        int n2;
        int n3 = this._symbols.length;
        int n4 = n3 + n3;
        if (n4 > 65536) {
            this._size = 0;
            this._canonicalize = false;
            this._symbols = new String[64];
            this._buckets = new CharsToNameCanonicalizer$Bucket[32];
            this._indexMask = 63;
            this._dirty = true;
            return;
        }
        Object object2 = this._symbols;
        CharsToNameCanonicalizer$Bucket[] charsToNameCanonicalizer$BucketArray = this._buckets;
        this._symbols = new String[n4];
        this._buckets = new CharsToNameCanonicalizer$Bucket[n4 >> 1];
        this._indexMask = n4 - 1;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n4);
        n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket;
            object = object2[n2];
            if (object == null) continue;
            ++n4;
            int n6 = this._hashToIndex(this.calcHash((String)object));
            if (this._symbols[n6] == null) {
                this._symbols[n6] = object;
                continue;
            }
            n = n6 >> 1;
            this._buckets[n] = charsToNameCanonicalizer$Bucket = new CharsToNameCanonicalizer$Bucket((String)object, this._buckets[n]);
            n5 = Math.max(n5, charsToNameCanonicalizer$Bucket.length);
        }
        n3 >>= 1;
        for (n2 = 0; n2 < n3; ++n2) {
            object = charsToNameCanonicalizer$BucketArray[n2];
            while (object != null) {
                ++n4;
                String string = ((CharsToNameCanonicalizer$Bucket)object).symbol;
                n = this._hashToIndex(this.calcHash(string));
                if (this._symbols[n] == null) {
                    this._symbols[n] = string;
                } else {
                    int n7 = n >> 1;
                    this._buckets[n7] = object2 = new CharsToNameCanonicalizer$Bucket(string, this._buckets[n7]);
                    n5 = Math.max(n5, object2.length);
                }
                object = ((CharsToNameCanonicalizer$Bucket)object).next;
            }
        }
        this._longestCollisionList = n5;
        this._overflows = null;
        if (n4 != this._size) {
            throw new Error("Internal error on SymbolTable.rehash(): had " + this._size + " entries; now have " + n4 + ".");
        }
    }

    protected final void reportTooManyCollisions(int n) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + n + " -- suspect a DoS attack based on hash collisions");
    }
}

