/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.json;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.base.ParserBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.CharTypes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.TextBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class ReaderBasedJsonParser
extends ParserBase {
    protected static final int[] _icLatin1 = CharTypes.getInputCodeLatin1();
    protected Reader _reader;
    protected char[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected ObjectCodec _objectCodec;
    protected final CharsToNameCanonicalizer _symbols;
    protected final int _hashSeed;
    protected boolean _tokenIncomplete = false;

    public ReaderBasedJsonParser(IOContext iOContext, int n, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer, char[] cArray, int n2, int n3, boolean bl) {
        super(iOContext, n);
        this._reader = reader;
        this._inputBuffer = cArray;
        this._inputPtr = n2;
        this._inputEnd = n3;
        this._objectCodec = objectCodec;
        this._symbols = charsToNameCanonicalizer;
        this._hashSeed = charsToNameCanonicalizer.hashSeed();
        this._bufferRecyclable = bl;
    }

    public ReaderBasedJsonParser(IOContext iOContext, int n, Reader reader, ObjectCodec objectCodec, CharsToNameCanonicalizer charsToNameCanonicalizer) {
        super(iOContext, n);
        this._reader = reader;
        this._inputBuffer = iOContext.allocTokenBuffer();
        this._inputPtr = 0;
        this._inputEnd = 0;
        this._objectCodec = objectCodec;
        this._symbols = charsToNameCanonicalizer;
        this._hashSeed = charsToNameCanonicalizer.hashSeed();
        this._bufferRecyclable = true;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public int releaseBuffered(Writer writer) {
        int n = this._inputEnd - this._inputPtr;
        if (n <= 0) {
            return 0;
        }
        int n2 = this._inputPtr;
        writer.write(this._inputBuffer, n2, n);
        return n;
    }

    @Override
    public Object getInputSource() {
        return this._reader;
    }

    @Override
    protected boolean loadMore() {
        this._currInputProcessed += (long)this._inputEnd;
        this._currInputRowStart -= this._inputEnd;
        if (this._reader != null) {
            int n = this._reader.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n > 0) {
                this._inputPtr = 0;
                this._inputEnd = n;
                return true;
            }
            this._closeInput();
            if (n == 0) {
                throw new IOException("Reader returned 0 characters when trying to read " + this._inputEnd);
            }
        }
        return false;
    }

    protected char getNextChar(String string) {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(string);
        }
        return this._inputBuffer[this._inputPtr++];
    }

    @Override
    protected void _closeInput() {
        if (this._reader != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser$Feature.AUTO_CLOSE_SOURCE)) {
                this._reader.close();
            }
            this._reader = null;
        }
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        this._symbols.release();
        if (this._bufferRecyclable) {
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer != null) {
                this._inputBuffer = null;
                this._ioContext.releaseTokenBuffer(cArray);
            }
        }
    }

    @Override
    public final String getText() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        return this._getText2(jsonToken);
    }

    @Override
    public final String getValueAsString() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(null);
    }

    @Override
    public final String getValueAsString(String string) {
        if (this._currToken == JsonToken.VALUE_STRING) {
            if (this._tokenIncomplete) {
                this._tokenIncomplete = false;
                this._finishString();
            }
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return super.getValueAsString(string);
    }

    protected final String _getText2(JsonToken jsonToken) {
        if (jsonToken == null) {
            return null;
        }
        switch (jsonToken.id()) {
            case 5: {
                return this._parsingContext.getCurrentName();
            }
            case 6: 
            case 7: 
            case 8: {
                return this._textBuffer.contentsAsString();
            }
        }
        return jsonToken.asString();
    }

    @Override
    public final char[] getTextCharacters() {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    if (!this._nameCopied) {
                        String string = this._parsingContext.getCurrentName();
                        int n = string.length();
                        if (this._nameCopyBuffer == null) {
                            this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n);
                        } else if (this._nameCopyBuffer.length < n) {
                            this._nameCopyBuffer = new char[n];
                        }
                        string.getChars(0, n, this._nameCopyBuffer, 0);
                        this._nameCopied = true;
                    }
                    return this._nameCopyBuffer;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextBuffer();
                }
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public final int getTextLength() {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return this._parsingContext.getCurrentName().length();
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.size();
                }
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public final int getTextOffset() {
        if (this._currToken != null) {
            switch (this._currToken.id()) {
                case 5: {
                    return 0;
                }
                case 6: {
                    if (this._tokenIncomplete) {
                        this._tokenIncomplete = false;
                        this._finishString();
                    }
                }
                case 7: 
                case 8: {
                    return this._textBuffer.getTextOffset();
                }
            }
        }
        return 0;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._tokenIncomplete) {
            try {
                this._binaryValue = this._decodeBase64(base64Variant);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + base64Variant + "): " + illegalArgumentException.getMessage());
            }
            this._tokenIncomplete = false;
        } else if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) {
        if (!this._tokenIncomplete || this._currToken != JsonToken.VALUE_STRING) {
            byte[] byArray = this.getBinaryValue(base64Variant);
            outputStream.write(byArray);
            return byArray.length;
        }
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            int n = this._readBinary(base64Variant, outputStream, byArray);
            return n;
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
    }

    protected int _readBinary(Base64Variant base64Variant, OutputStream outputStream, byte[] byArray) {
        int n = 0;
        int n2 = byArray.length - 3;
        int n3 = 0;
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) <= ' ') continue;
            int n4 = base64Variant.decodeBase64Char(c2);
            if (n4 < 0) {
                if (c2 == '\"') break;
                n4 = this._decodeBase64Escape(base64Variant, c2, 0);
                if (n4 < 0) continue;
            }
            if (n > n2) {
                n3 += n;
                outputStream.write(byArray, 0, n);
                n = 0;
            }
            int n5 = n4;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n4 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                n4 = this._decodeBase64Escape(base64Variant, c2, 1);
            }
            n5 = n5 << 6 | n4;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n4 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n4 != -2) {
                    if (c2 == '\"' && !base64Variant.usesPadding()) {
                        byArray[n++] = (byte)(n5 >>= 4);
                        break;
                    }
                    n4 = this._decodeBase64Escape(base64Variant, c2, 2);
                }
                if (n4 == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(c2 = this._inputBuffer[this._inputPtr++])) {
                        throw this.reportInvalidBase64Char(base64Variant, c2, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byArray[n++] = (byte)(n5 >>= 4);
                    continue;
                }
            }
            n5 = n5 << 6 | n4;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n4 = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n4 != -2) {
                    if (c2 == '\"' && !base64Variant.usesPadding()) {
                        byArray[n++] = (byte)((n5 >>= 2) >> 8);
                        byArray[n++] = (byte)n5;
                        break;
                    }
                    n4 = this._decodeBase64Escape(base64Variant, c2, 3);
                }
                if (n4 == -2) {
                    byArray[n++] = (byte)((n5 >>= 2) >> 8);
                    byArray[n++] = (byte)n5;
                    continue;
                }
            }
            n5 = n5 << 6 | n4;
            byArray[n++] = (byte)(n5 >> 16);
            byArray[n++] = (byte)(n5 >> 8);
            byArray[n++] = (byte)n5;
        }
        this._tokenIncomplete = false;
        if (n > 0) {
            n3 += n;
            outputStream.write(byArray, 0, n);
        }
        return n3;
    }

    @Override
    public final JsonToken nextToken() {
        JsonToken jsonToken;
        boolean bl;
        int n;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nextAfterName();
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        this._binaryValue = null;
        if (n == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return this._currToken;
        }
        if (n == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_OBJECT;
            return this._currToken;
        }
        if (this._parsingContext.expectComma()) {
            n = this._skipComma(n);
        }
        if (bl = this._parsingContext.inObject()) {
            String string = n == 34 ? this._parseName() : this._handleOddName(n);
            this._parsingContext.setCurrentName(string);
            this._currToken = JsonToken.FIELD_NAME;
            n = this._skipColon();
        }
        switch (n) {
            case 34: {
                this._tokenIncomplete = true;
                jsonToken = JsonToken.VALUE_STRING;
                break;
            }
            case 91: {
                if (!bl) {
                    this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                }
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                if (!bl) {
                    this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                }
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            case 93: 
            case 125: {
                this._reportUnexpectedChar(n, "expected a value");
            }
            case 116: {
                this._matchTrue();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 102: {
                this._matchFalse();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n);
                break;
            }
            default: {
                jsonToken = this._handleOddValue(n);
            }
        }
        if (bl) {
            this._nextToken = jsonToken;
            return this._currToken;
        }
        this._currToken = jsonToken;
        return jsonToken;
    }

    private final JsonToken _nextAfterName() {
        this._nameCopied = false;
        JsonToken jsonToken = this._nextToken;
        this._nextToken = null;
        if (jsonToken == JsonToken.START_ARRAY) {
            this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
        } else if (jsonToken == JsonToken.START_OBJECT) {
            this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    @Override
    public String nextFieldName() {
        JsonToken jsonToken;
        int n;
        this._numTypesValid = 0;
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nextAfterName();
            return null;
        }
        if (this._tokenIncomplete) {
            this._skipString();
        }
        if ((n = this._skipWSOrEnd()) < 0) {
            this.close();
            this._currToken = null;
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        this._binaryValue = null;
        if (n == 93) {
            if (!this._parsingContext.inArray()) {
                this._reportMismatchedEndMarker(n, '}');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_ARRAY;
            return null;
        }
        if (n == 125) {
            if (!this._parsingContext.inObject()) {
                this._reportMismatchedEndMarker(n, ']');
            }
            this._parsingContext = this._parsingContext.getParent();
            this._currToken = JsonToken.END_OBJECT;
            return null;
        }
        if (this._parsingContext.expectComma()) {
            n = this._skipComma(n);
        }
        if (!this._parsingContext.inObject()) {
            this._nextTokenNotInObject(n);
            return null;
        }
        String string = n == 34 ? this._parseName() : this._handleOddName(n);
        this._parsingContext.setCurrentName(string);
        this._currToken = JsonToken.FIELD_NAME;
        n = this._skipColon();
        if (n == 34) {
            this._tokenIncomplete = true;
            this._nextToken = JsonToken.VALUE_STRING;
            return string;
        }
        switch (n) {
            case 45: {
                jsonToken = this._parseNegNumber();
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                jsonToken = this._parsePosNumber(n);
                break;
            }
            case 102: {
                this._matchFalse();
                jsonToken = JsonToken.VALUE_FALSE;
                break;
            }
            case 110: {
                this._matchNull();
                jsonToken = JsonToken.VALUE_NULL;
                break;
            }
            case 116: {
                this._matchTrue();
                jsonToken = JsonToken.VALUE_TRUE;
                break;
            }
            case 91: {
                jsonToken = JsonToken.START_ARRAY;
                break;
            }
            case 123: {
                jsonToken = JsonToken.START_OBJECT;
                break;
            }
            default: {
                jsonToken = this._handleOddValue(n);
            }
        }
        this._nextToken = jsonToken;
        return string;
    }

    private final JsonToken _nextTokenNotInObject(int n) {
        if (n == 34) {
            this._tokenIncomplete = true;
            this._currToken = JsonToken.VALUE_STRING;
            return this._currToken;
        }
        switch (n) {
            case 91: {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_ARRAY;
                return this._currToken;
            }
            case 123: {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            case 116: {
                this._matchToken("true", 1);
                this._currToken = JsonToken.VALUE_TRUE;
                return this._currToken;
            }
            case 102: {
                this._matchToken("false", 1);
                this._currToken = JsonToken.VALUE_FALSE;
                return this._currToken;
            }
            case 110: {
                this._matchToken("null", 1);
                this._currToken = JsonToken.VALUE_NULL;
                return this._currToken;
            }
            case 45: {
                this._currToken = this._parseNegNumber();
                return this._currToken;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this._currToken = this._parsePosNumber(n);
                return this._currToken;
            }
        }
        this._currToken = this._handleOddValue(n);
        return this._currToken;
    }

    @Override
    public final String nextTextValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_STRING) {
                if (this._tokenIncomplete) {
                    this._tokenIncomplete = false;
                    this._finishString();
                }
                return this._textBuffer.contentsAsString();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        if (this.nextToken() == JsonToken.VALUE_STRING) {
            return this.getText();
        }
        return null;
    }

    @Override
    public final int nextIntValue(int n) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getIntValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return n;
        }
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getIntValue();
        }
        return n;
    }

    @Override
    public final long nextLongValue(long l) {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                return this.getLongValue();
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return l;
        }
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getLongValue();
        }
        return l;
    }

    @Override
    public final Boolean nextBooleanValue() {
        if (this._currToken == JsonToken.FIELD_NAME) {
            this._nameCopied = false;
            JsonToken jsonToken = this._nextToken;
            this._nextToken = null;
            this._currToken = jsonToken;
            if (jsonToken == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (jsonToken == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (jsonToken == JsonToken.START_ARRAY) {
                this._parsingContext = this._parsingContext.createChildArrayContext(this._tokenInputRow, this._tokenInputCol);
            } else if (jsonToken == JsonToken.START_OBJECT) {
                this._parsingContext = this._parsingContext.createChildObjectContext(this._tokenInputRow, this._tokenInputCol);
            }
            return null;
        }
        JsonToken jsonToken = this.nextToken();
        if (jsonToken != null) {
            int n = jsonToken.id();
            if (n == 9) {
                return Boolean.TRUE;
            }
            if (n == 10) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected final JsonToken _parsePosNumber(int n) {
        int n2 = this._inputPtr;
        int n3 = n2 - 1;
        int n4 = this._inputEnd;
        if (n == 48) {
            return this._parseNumber2(false, n3);
        }
        int n5 = 1;
        while (true) {
            if (n2 >= n4) {
                this._inputPtr = n3;
                return this._parseNumber2(false, n3);
            }
            if ((n = this._inputBuffer[n2++]) < 48 || n > 57) break;
            ++n5;
        }
        if (n == 46 || n == 101 || n == 69) {
            this._inputPtr = n2;
            return this._parseFloat(n, n3, n2, false, n5);
        }
        this._inputPtr = --n2;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(n);
        }
        n = n2 - n3;
        this._textBuffer.resetWithShared(this._inputBuffer, n3, n);
        return this.resetInt(false, n5);
    }

    private final JsonToken _parseFloat(int n, int n2, int n3, boolean bl, int n4) {
        int n5 = this._inputEnd;
        int n6 = 0;
        if (n == 46) {
            while (true) {
                if (n3 >= n5) {
                    return this._parseNumber2(bl, n2);
                }
                if ((n = this._inputBuffer[n3++]) < 48 || n > 57) break;
                ++n6;
            }
            if (n6 == 0) {
                this.reportUnexpectedNumberChar(n, "Decimal point not followed by a digit");
            }
        }
        int n7 = 0;
        if (n == 101 || n == 69) {
            if (n3 >= n5) {
                this._inputPtr = n2;
                return this._parseNumber2(bl, n2);
            }
            if ((n = this._inputBuffer[n3++]) == 45 || n == 43) {
                if (n3 >= n5) {
                    this._inputPtr = n2;
                    return this._parseNumber2(bl, n2);
                }
                n = this._inputBuffer[n3++];
            }
            while (n <= 57 && n >= 48) {
                ++n7;
                if (n3 >= n5) {
                    this._inputPtr = n2;
                    return this._parseNumber2(bl, n2);
                }
                n = this._inputBuffer[n3++];
            }
            if (n7 == 0) {
                this.reportUnexpectedNumberChar(n, "Exponent indicator not followed by a digit");
            }
        }
        this._inputPtr = --n3;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(n);
        }
        n = n3 - n2;
        this._textBuffer.resetWithShared(this._inputBuffer, n2, n);
        return this.resetFloat(bl, n4, n6, n7);
    }

    protected final JsonToken _parseNegNumber() {
        char c2;
        int n = this._inputPtr;
        int n2 = n - 1;
        int n3 = this._inputEnd;
        if (n >= n3) {
            return this._parseNumber2(true, n2);
        }
        if ((c2 = this._inputBuffer[n++]) > '9' || c2 < '0') {
            this._inputPtr = n;
            return this._handleInvalidNumberStart(c2, true);
        }
        if (c2 == '0') {
            return this._parseNumber2(true, n2);
        }
        int n4 = 1;
        while (true) {
            if (n >= n3) {
                return this._parseNumber2(true, n2);
            }
            if ((c2 = this._inputBuffer[n++]) < '0' || c2 > '9') break;
            ++n4;
        }
        if (c2 == '.' || c2 == 'e' || c2 == 'E') {
            this._inputPtr = n;
            return this._parseFloat(c2, n2, n, true, n4);
        }
        this._inputPtr = --n;
        if (this._parsingContext.inRoot()) {
            this._verifyRootSpace(c2);
        }
        this._textBuffer.resetWithShared(this._inputBuffer, n2, n -= n2);
        return this.resetInt(true, n4);
    }

    private final JsonToken _parseNumber2(boolean bl, int n) {
        this._inputPtr = bl ? n + 1 : n;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n2 = 0;
        if (bl) {
            ++n2;
            cArray[0] = 45;
        }
        int n3 = 0;
        char c2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("No digit following minus sign");
        if (c2 == '0') {
            c2 = this._verifyNoLeadingZeroes();
        }
        boolean bl2 = false;
        while (c2 >= '0' && c2 <= '9') {
            ++n3;
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = c2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                c2 = '\u0000';
                bl2 = true;
                break;
            }
            c2 = this._inputBuffer[this._inputPtr++];
        }
        if (n3 == 0) {
            return this._handleInvalidNumberStart(c2, bl);
        }
        int n4 = 0;
        if (c2 == '.') {
            cArray[n2++] = c2;
            while (true) {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    bl2 = true;
                    break;
                }
                if ((c2 = this._inputBuffer[this._inputPtr++]) < '0' || c2 > '9') break;
                ++n4;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = c2;
            }
            if (n4 == 0) {
                this.reportUnexpectedNumberChar(c2, "Decimal point not followed by a digit");
            }
        }
        int n5 = 0;
        if (c2 == 'e' || c2 == 'E') {
            char c3;
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = c2;
            c2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent");
            if (c2 == '-' || c2 == '+') {
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = c2;
                c3 = c2 = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.getNextChar("expected a digit for number exponent");
            }
            while (c2 <= '9' && c2 >= '0') {
                ++n5;
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                cArray[n2++] = c2;
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    bl2 = true;
                    break;
                }
                c3 = this._inputBuffer[this._inputPtr++];
            }
            if (n5 == 0) {
                this.reportUnexpectedNumberChar(c2, "Exponent indicator not followed by a digit");
            }
        }
        if (!bl2) {
            --this._inputPtr;
            if (this._parsingContext.inRoot()) {
                this._verifyRootSpace(c2);
            }
        }
        this._textBuffer.setCurrentLength(n2);
        return this.reset(bl, n3, n4, n5);
    }

    private final char _verifyNoLeadingZeroes() {
        char c2;
        if (this._inputPtr < this._inputEnd && ((c2 = this._inputBuffer[this._inputPtr]) < '0' || c2 > '9')) {
            return '0';
        }
        return this._verifyNLZ2();
    }

    private char _verifyNLZ2() {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return '0';
        }
        char c2 = this._inputBuffer[this._inputPtr];
        if (c2 < '0' || c2 > '9') {
            return '0';
        }
        if (!this.isEnabled(JsonParser$Feature.ALLOW_NUMERIC_LEADING_ZEROS)) {
            this.reportInvalidNumber("Leading zeroes not allowed");
        }
        ++this._inputPtr;
        if (c2 == '0') {
            while (this._inputPtr < this._inputEnd || this.loadMore()) {
                c2 = this._inputBuffer[this._inputPtr];
                if (c2 < '0' || c2 > '9') {
                    return '0';
                }
                ++this._inputPtr;
                if (c2 == '0') continue;
            }
        }
        return c2;
    }

    protected JsonToken _handleInvalidNumberStart(int n, boolean bl) {
        if (n == 73) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOFInValue();
            }
            if ((n = this._inputBuffer[this._inputPtr++]) == 78) {
                String string = bl ? "-INF" : "+INF";
                this._matchToken(string, 3);
                if (this.isEnabled(JsonParser$Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            } else if (n == 110) {
                String string = bl ? "-Infinity" : "+Infinity";
                this._matchToken(string, 3);
                if (this.isEnabled(JsonParser$Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN(string, bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token '" + string + "': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
            }
        }
        this.reportUnexpectedNumberChar(n, "expected digit (0-9) to follow minus sign, for valid numeric value");
        return null;
    }

    private final void _verifyRootSpace(int n) {
        ++this._inputPtr;
        switch (n) {
            case 9: 
            case 32: {
                return;
            }
            case 13: {
                this._skipCR();
                return;
            }
            case 10: {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                return;
            }
        }
        this._reportMissingRootWS(n);
    }

    protected final String _parseName() {
        int n;
        int n2;
        int n3 = this._hashSeed;
        int[] nArray = _icLatin1;
        for (n2 = this._inputPtr; n2 < this._inputEnd; ++n2) {
            n = this._inputBuffer[n2];
            if (n < nArray.length && nArray[n] != 0) {
                if (n != 34) break;
                int n4 = this._inputPtr;
                this._inputPtr = n2 + 1;
                return this._symbols.findSymbol(this._inputBuffer, n4, n2 - n4, n3);
            }
            n3 = n3 * 33 + n;
        }
        n = this._inputPtr;
        this._inputPtr = n2;
        return this._parseName2(n, n3, 34);
    }

    private String _parseName2(int n, int n2, int n3) {
        this._textBuffer.resetWithShared(this._inputBuffer, n, this._inputPtr - n);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n4 = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing '" + (char)n3 + "' for name");
            }
            char c3 = c2 = this._inputBuffer[this._inputPtr++];
            if (c2 <= '\\') {
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 <= n3) {
                    if (c3 == n3) break;
                    if (c3 < ' ') {
                        this._throwUnquotedSpace(c3, "name");
                    }
                }
            }
            n2 = n2 * 33 + c2;
            cArray[n4++] = c2;
            if (n4 < cArray.length) continue;
            cArray = this._textBuffer.finishCurrentSegment();
            n4 = 0;
        }
        this._textBuffer.setCurrentLength(n4);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n5 = textBuffer.getTextOffset();
        n3 = textBuffer.size();
        return this._symbols.findSymbol(cArray2, n5, n3, n2);
    }

    protected String _handleOddName(int n) {
        int n2;
        int[] nArray;
        int n3;
        int n4;
        if (n == 39 && this.isEnabled(JsonParser$Feature.ALLOW_SINGLE_QUOTES)) {
            return this._parseAposName();
        }
        if (!this.isEnabled(JsonParser$Feature.ALLOW_UNQUOTED_FIELD_NAMES)) {
            this._reportUnexpectedChar(n, "was expecting double-quote to start field name");
        }
        if ((n4 = n < (n3 = (nArray = CharTypes.getInputCodeLatin1JsNames()).length) ? (nArray[n] == 0 ? 1 : 0) : Character.isJavaIdentifierPart((char)n)) == 0) {
            this._reportUnexpectedChar(n, "was expecting either valid name character (for unquoted name) or double-quote (for quoted) to start field name");
        }
        n = this._inputPtr;
        n4 = this._hashSeed;
        int n5 = this._inputEnd;
        if (n < n5) {
            do {
                if ((n2 = this._inputBuffer[n]) < n3) {
                    if (nArray[n2] != 0) {
                        int n6 = this._inputPtr - 1;
                        this._inputPtr = n;
                        return this._symbols.findSymbol(this._inputBuffer, n6, n - n6, n4);
                    }
                } else if (!Character.isJavaIdentifierPart((char)n2)) {
                    int n7 = this._inputPtr - 1;
                    this._inputPtr = n;
                    return this._symbols.findSymbol(this._inputBuffer, n7, n - n7, n4);
                }
                n4 = n4 * 33 + n2;
            } while (++n < n5);
        }
        n2 = this._inputPtr - 1;
        this._inputPtr = n;
        return this._handleOddName2(n2, n4, nArray);
    }

    protected String _parseAposName() {
        int n = this._inputPtr;
        int n2 = this._hashSeed;
        int n3 = this._inputEnd;
        if (n < n3) {
            int[] nArray = _icLatin1;
            int n4 = _icLatin1.length;
            do {
                char c2;
                if ((c2 = this._inputBuffer[n]) == '\'') {
                    n3 = this._inputPtr;
                    this._inputPtr = n + 1;
                    return this._symbols.findSymbol(this._inputBuffer, n3, n - n3, n2);
                }
                if (c2 < n4 && nArray[c2] != 0) break;
                n2 = n2 * 33 + c2;
            } while (++n < n3);
        }
        int n5 = this._inputPtr;
        this._inputPtr = n;
        return this._parseName2(n5, n2, 39);
    }

    protected JsonToken _handleOddValue(int n) {
        switch (n) {
            case 39: {
                if (!this.isEnabled(JsonParser$Feature.ALLOW_SINGLE_QUOTES)) break;
                return this._handleApos();
            }
            case 78: {
                this._matchToken("NaN", 1);
                if (this.isEnabled(JsonParser$Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("NaN", Double.NaN);
                }
                this._reportError("Non-standard token 'NaN': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 73: {
                this._matchToken("Infinity", 1);
                if (this.isEnabled(JsonParser$Feature.ALLOW_NON_NUMERIC_NUMBERS)) {
                    return this.resetAsNaN("Infinity", Double.POSITIVE_INFINITY);
                }
                this._reportError("Non-standard token 'Infinity': enable JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS to allow");
                break;
            }
            case 43: {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this._reportInvalidEOFInValue();
                }
                return this._handleInvalidNumberStart(this._inputBuffer[this._inputPtr++], false);
            }
        }
        if (Character.isJavaIdentifierStart(n)) {
            this._reportInvalidToken("" + (char)n, "('true', 'false' or 'null')");
        }
        this._reportUnexpectedChar(n, "expected a valid value (number, String, array, object, 'true', 'false' or 'null')");
        return null;
    }

    protected JsonToken _handleApos() {
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n = this._textBuffer.getCurrentSegmentSize();
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value");
            }
            char c3 = c2 = this._inputBuffer[this._inputPtr++];
            if (c2 <= '\\') {
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 <= '\'') {
                    if (c3 == '\'') break;
                    if (c3 < ' ') {
                        this._throwUnquotedSpace(c3, "string value");
                    }
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = c2;
        }
        this._textBuffer.setCurrentLength(n);
        return JsonToken.VALUE_STRING;
    }

    private String _handleOddName2(int n, int n2, int[] nArray) {
        this._textBuffer.resetWithShared(this._inputBuffer, n, this._inputPtr - n);
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n3 = this._textBuffer.getCurrentSegmentSize();
        int n4 = nArray.length;
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c2;
            char c3 = c2 = this._inputBuffer[this._inputPtr];
            if (c2 > n4 ? !Character.isJavaIdentifierPart(c2) : nArray[c3] != 0) break;
            ++this._inputPtr;
            n2 = n2 * 33 + c3;
            cArray[n3++] = c2;
            if (n3 < cArray.length) continue;
            cArray = this._textBuffer.finishCurrentSegment();
            n3 = 0;
        }
        this._textBuffer.setCurrentLength(n3);
        TextBuffer textBuffer = this._textBuffer;
        char[] cArray2 = textBuffer.getTextBuffer();
        int n5 = textBuffer.getTextOffset();
        int n6 = textBuffer.size();
        return this._symbols.findSymbol(cArray2, n5, n6, n2);
    }

    @Override
    protected final void _finishString() {
        int n = this._inputPtr;
        int n2 = this._inputEnd;
        if (n < n2) {
            int[] nArray = _icLatin1;
            int n3 = _icLatin1.length;
            do {
                char c2;
                if ((c2 = this._inputBuffer[n]) >= n3 || nArray[c2] == 0) continue;
                if (c2 != '\"') break;
                this._textBuffer.resetWithShared(this._inputBuffer, this._inputPtr, n - this._inputPtr);
                this._inputPtr = n + 1;
                return;
            } while (++n < n2);
        }
        this._textBuffer.resetWithCopy(this._inputBuffer, this._inputPtr, n - this._inputPtr);
        this._inputPtr = n;
        this._finishString2();
    }

    protected void _finishString2() {
        char[] cArray = this._textBuffer.getCurrentSegment();
        int n = this._textBuffer.getCurrentSegmentSize();
        int[] nArray = _icLatin1;
        int n2 = _icLatin1.length;
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(": was expecting closing quote for a string value");
            }
            char c3 = c2 = this._inputBuffer[this._inputPtr++];
            if (c2 < n2 && nArray[c3] != 0) {
                if (c3 == '\"') break;
                if (c3 == '\\') {
                    c2 = this._decodeEscaped();
                } else if (c3 < ' ') {
                    this._throwUnquotedSpace(c3, "string value");
                }
            }
            if (n >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = c2;
        }
        this._textBuffer.setCurrentLength(n);
    }

    protected final void _skipString() {
        this._tokenIncomplete = false;
        int n = this._inputPtr;
        int n2 = this._inputEnd;
        char[] cArray = this._inputBuffer;
        while (true) {
            char c2;
            if (n >= n2) {
                this._inputPtr = n;
                if (!this.loadMore()) {
                    this._reportInvalidEOF(": was expecting closing quote for a string value");
                }
                n = this._inputPtr;
                n2 = this._inputEnd;
            }
            if ((c2 = cArray[n++]) > '\\') continue;
            if (c2 == '\\') {
                this._inputPtr = n;
                this._decodeEscaped();
                n = this._inputPtr;
                n2 = this._inputEnd;
                continue;
            }
            if (c2 > '\"') continue;
            if (c2 == '\"') {
                this._inputPtr = n;
                return;
            }
            if (c2 >= ' ') continue;
            this._inputPtr = n;
            this._throwUnquotedSpace(c2, "string value");
        }
    }

    protected final void _skipCR() {
        if ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == '\n') {
            ++this._inputPtr;
        }
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    private final int _skipColon() {
        if (this._inputPtr + 4 >= this._inputEnd) {
            return this._skipColon2(false);
        }
        char c2 = this._inputBuffer[this._inputPtr];
        if (c2 == ':') {
            if ((c2 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c2 == '/' || c2 == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return c2;
            }
            if ((c2 == ' ' || c2 == '\t') && (c2 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c2 == '/' || c2 == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return c2;
            }
            return this._skipColon2(true);
        }
        if (c2 == ' ' || c2 == '\t') {
            c2 = this._inputBuffer[++this._inputPtr];
        }
        if (c2 == ':') {
            if ((c2 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c2 == '/' || c2 == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return c2;
            }
            if ((c2 == ' ' || c2 == '\t') && (c2 = this._inputBuffer[++this._inputPtr]) > ' ') {
                if (c2 == '/' || c2 == '#') {
                    return this._skipColon2(true);
                }
                ++this._inputPtr;
                return c2;
            }
            return this._skipColon2(true);
        }
        return this._skipColon2(false);
    }

    private final int _skipColon2(boolean bl) {
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 == '/') {
                    this._skipComment();
                    continue;
                }
                if (c2 == '#' && this._skipYAMLComment()) continue;
                if (bl) {
                    return c2;
                }
                if (c2 != ':') {
                    if (c2 < ' ') {
                        this._throwInvalidSpace(c2);
                    }
                    this._reportUnexpectedChar(c2, "was expecting a colon to separate field name and value");
                }
                bl = true;
                continue;
            }
            if (c2 >= ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
    }

    private final int _skipComma(int n) {
        if (n != 44) {
            this._reportUnexpectedChar(n, "was expecting comma to separate " + this._parsingContext.getTypeDesc() + " entries");
        }
        while (this._inputPtr < this._inputEnd) {
            if ((n = this._inputBuffer[this._inputPtr++]) > 32) {
                if (n == 47 || n == 35) {
                    --this._inputPtr;
                    return this._skipAfterComma2();
                }
                return n;
            }
            if (n >= 32) continue;
            if (n == 10) {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (n == 13) {
                this._skipCR();
                continue;
            }
            if (n == 9) continue;
            this._throwInvalidSpace(n);
        }
        return this._skipAfterComma2();
    }

    private final int _skipAfterComma2() {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 == '/') {
                    this._skipComment();
                    continue;
                }
                if (c2 == '#' && this._skipYAMLComment()) continue;
                return c2;
            }
            if (c2 >= ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        throw this._constructError("Unexpected end-of-input within/between " + this._parsingContext.getTypeDesc() + " entries");
    }

    private final int _skipWSOrEnd() {
        char c2;
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return this._eofAsNextChar();
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
            if (c2 == '/' || c2 == '#') {
                --this._inputPtr;
                return this._skipWSOrEnd2();
            }
            return c2;
        }
        if (c2 != ' ') {
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
            } else if (c2 == '\r') {
                this._skipCR();
            } else if (c2 != '\t') {
                this._throwInvalidSpace(c2);
            }
        }
        while (this._inputPtr < this._inputEnd) {
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 == '/' || c2 == '#') {
                    --this._inputPtr;
                    return this._skipWSOrEnd2();
                }
                return c2;
            }
            if (c2 == ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        return this._skipWSOrEnd2();
    }

    private int _skipWSOrEnd2() {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > ' ') {
                if (c2 == '/') {
                    this._skipComment();
                    continue;
                }
                if (c2 == '#' && this._skipYAMLComment()) continue;
                return c2;
            }
            if (c2 == ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        return this._eofAsNextChar();
    }

    private void _skipComment() {
        char c2;
        if (!this.isEnabled(JsonParser$Feature.ALLOW_COMMENTS)) {
            this._reportUnexpectedChar(47, "maybe a (non-standard) comment? (not recognized as one since Feature 'ALLOW_COMMENTS' not enabled for parser)");
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in a comment");
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) == '/') {
            this._skipLine();
            return;
        }
        if (c2 == '*') {
            this._skipCComment();
            return;
        }
        this._reportUnexpectedChar(c2, "was expecting either '*' or '/' for a comment");
    }

    private void _skipCComment() {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) > '*') continue;
            if (c2 == '*') {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) break;
                if (this._inputBuffer[this._inputPtr] != '/') continue;
                ++this._inputPtr;
                return;
            }
            if (c2 >= ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                continue;
            }
            if (c2 == '\r') {
                this._skipCR();
                continue;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
        this._reportInvalidEOF(" in a comment");
    }

    private boolean _skipYAMLComment() {
        if (!this.isEnabled(JsonParser$Feature.ALLOW_YAML_COMMENTS)) {
            return false;
        }
        this._skipLine();
        return true;
    }

    private void _skipLine() {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char c2;
            if ((c2 = this._inputBuffer[this._inputPtr++]) >= ' ') continue;
            if (c2 == '\n') {
                ++this._currInputRow;
                this._currInputRowStart = this._inputPtr;
                return;
            }
            if (c2 == '\r') {
                this._skipCR();
                return;
            }
            if (c2 == '\t') continue;
            this._throwInvalidSpace(c2);
        }
    }

    @Override
    protected char _decodeEscaped() {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportInvalidEOF(" in character escape sequence");
        }
        int n = this._inputBuffer[this._inputPtr++];
        switch (n) {
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 47: 
            case 92: {
                return (char)n;
            }
            case 117: {
                break;
            }
            default: {
                return this._handleUnrecognizedCharacterEscape((char)n);
            }
        }
        n = 0;
        for (int k = 0; k < 4; ++k) {
            char c2;
            int n2;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidEOF(" in character escape sequence");
            }
            if ((n2 = CharTypes.charToHex(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                this._reportUnexpectedChar(c2, "expected a hex-digit for character escape sequence");
            }
            n = n << 4 | n2;
        }
        return (char)n;
    }

    private final void _matchTrue() {
        int n = this._inputPtr;
        if (n + 3 < this._inputEnd) {
            char c2;
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer[n] == 'r' && cArray[++n] == 'u' && cArray[++n] == 'e' && ((c2 = cArray[++n]) < '0' || c2 == ']' || c2 == '}')) {
                this._inputPtr = n;
                return;
            }
        }
        this._matchToken("true", 1);
    }

    private final void _matchFalse() {
        int n = this._inputPtr;
        if (n + 4 < this._inputEnd) {
            char c2;
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer[n] == 'a' && cArray[++n] == 'l' && cArray[++n] == 's' && cArray[++n] == 'e' && ((c2 = cArray[++n]) < '0' || c2 == ']' || c2 == '}')) {
                this._inputPtr = n;
                return;
            }
        }
        this._matchToken("false", 1);
    }

    private final void _matchNull() {
        int n = this._inputPtr;
        if (n + 3 < this._inputEnd) {
            char c2;
            char[] cArray = this._inputBuffer;
            if (this._inputBuffer[n] == 'u' && cArray[++n] == 'l' && cArray[++n] == 'l' && ((c2 = cArray[++n]) < '0' || c2 == ']' || c2 == '}')) {
                this._inputPtr = n;
                return;
            }
        }
        this._matchToken("null", 1);
    }

    protected final void _matchToken(String string, int n) {
        int c2 = string.length();
        do {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._reportInvalidToken(string.substring(0, n));
            }
            if (this._inputBuffer[this._inputPtr] != string.charAt(n)) {
                this._reportInvalidToken(string.substring(0, n));
            }
            ++this._inputPtr;
        } while (++n < c2);
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return;
        }
        char c3 = this._inputBuffer[this._inputPtr];
        if (c3 < '0' || c3 == ']' || c3 == '}') {
            return;
        }
        if (Character.isJavaIdentifierPart(c3)) {
            this._reportInvalidToken(string.substring(0, n));
        }
    }

    protected byte[] _decodeBase64(Base64Variant base64Variant) {
        ByteArrayBuilder byteArrayBuilder = this._getByteArrayBuilder();
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) <= ' ') continue;
            int n = base64Variant.decodeBase64Char(c2);
            if (n < 0) {
                if (c2 == '\"') {
                    return byteArrayBuilder.toByteArray();
                }
                n = this._decodeBase64Escape(base64Variant, c2, 0);
                if (n < 0) continue;
            }
            int n2 = n;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                n = this._decodeBase64Escape(base64Variant, c2, 1);
            }
            n2 = n2 << 6 | n;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n != -2) {
                    if (c2 == '\"' && !base64Variant.usesPadding()) {
                        byteArrayBuilder.append(n2 >>= 4);
                        return byteArrayBuilder.toByteArray();
                    }
                    n = this._decodeBase64Escape(base64Variant, c2, 2);
                }
                if (n == -2) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (!base64Variant.usesPaddingChar(c2 = this._inputBuffer[this._inputPtr++])) {
                        throw this.reportInvalidBase64Char(base64Variant, c2, 3, "expected padding character '" + base64Variant.getPaddingChar() + "'");
                    }
                    byteArrayBuilder.append(n2 >>= 4);
                    continue;
                }
            }
            n2 = n2 << 6 | n;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n = base64Variant.decodeBase64Char(c2 = this._inputBuffer[this._inputPtr++])) < 0) {
                if (n != -2) {
                    if (c2 == '\"' && !base64Variant.usesPadding()) {
                        byteArrayBuilder.appendTwoBytes(n2 >>= 2);
                        return byteArrayBuilder.toByteArray();
                    }
                    n = this._decodeBase64Escape(base64Variant, c2, 3);
                }
                if (n == -2) {
                    byteArrayBuilder.appendTwoBytes(n2 >>= 2);
                    continue;
                }
            }
            n2 = n2 << 6 | n;
            byteArrayBuilder.appendThreeBytes(n2);
        }
    }

    protected void _reportInvalidToken(String string) {
        this._reportInvalidToken(string, "'null', 'true', 'false' or NaN");
    }

    protected void _reportInvalidToken(String charSequence, String string) {
        char c2;
        charSequence = new StringBuilder((String)charSequence);
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && Character.isJavaIdentifierPart(c2 = this._inputBuffer[this._inputPtr])) {
            ++this._inputPtr;
            ((StringBuilder)charSequence).append(c2);
        }
        this._reportError("Unrecognized token '" + ((StringBuilder)charSequence).toString() + "': was expecting " + string);
    }
}

