/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variants;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.FormatSchema;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerationException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser$NumberType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonStreamContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.PrettyPrinter;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.SerializableString;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.TreeNode;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Version;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Versioned;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.CharacterEscapes;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.VersionUtil;
import java.io.Closeable;
import java.io.Flushable;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class JsonGenerator
implements Versioned,
Closeable,
Flushable {
    protected PrettyPrinter _cfgPrettyPrinter;

    protected JsonGenerator() {
    }

    public abstract JsonGenerator setCodec(ObjectCodec var1);

    public abstract ObjectCodec getCodec();

    @Override
    public abstract Version version();

    public abstract JsonGenerator enable(JsonGenerator$Feature var1);

    public abstract JsonGenerator disable(JsonGenerator$Feature var1);

    public final JsonGenerator configure(JsonGenerator$Feature jsonGenerator$Feature, boolean bl) {
        if (bl) {
            this.enable(jsonGenerator$Feature);
        } else {
            this.disable(jsonGenerator$Feature);
        }
        return this;
    }

    public abstract boolean isEnabled(JsonGenerator$Feature var1);

    public abstract int getFeatureMask();

    public abstract JsonGenerator setFeatureMask(int var1);

    public JsonGenerator overrideStdFeatures(int n, int n2) {
        n = this.getFeatureMask() & ~n2 | n & n2;
        return this.setFeatureMask(n);
    }

    public int getFormatFeatures() {
        return 0;
    }

    public JsonGenerator overrideFormatFeatures(int n, int n2) {
        throw new IllegalArgumentException("No FormatFeatures defined for generator of type " + this.getClass().getName());
    }

    public void setSchema(FormatSchema formatSchema) {
        throw new UnsupportedOperationException("Generator of type " + this.getClass().getName() + " does not support schema of type '" + formatSchema.getSchemaType() + "'");
    }

    public FormatSchema getSchema() {
        return null;
    }

    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._cfgPrettyPrinter = prettyPrinter;
        return this;
    }

    public PrettyPrinter getPrettyPrinter() {
        return this._cfgPrettyPrinter;
    }

    public abstract JsonGenerator useDefaultPrettyPrinter();

    public JsonGenerator setHighestNonEscapedChar(int n) {
        return this;
    }

    public int getHighestEscapedChar() {
        return 0;
    }

    public CharacterEscapes getCharacterEscapes() {
        return null;
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        return this;
    }

    public JsonGenerator setRootValueSeparator(SerializableString serializableString) {
        throw new UnsupportedOperationException();
    }

    public Object getOutputTarget() {
        return null;
    }

    public int getOutputBuffered() {
        return -1;
    }

    public Object getCurrentValue() {
        JsonStreamContext jsonStreamContext = this.getOutputContext();
        if (jsonStreamContext == null) {
            return null;
        }
        return jsonStreamContext.getCurrentValue();
    }

    public void setCurrentValue(Object object) {
        JsonStreamContext jsonStreamContext = this.getOutputContext();
        if (jsonStreamContext != null) {
            jsonStreamContext.setCurrentValue(object);
        }
    }

    public boolean canUseSchema(FormatSchema formatSchema) {
        return false;
    }

    public boolean canWriteObjectId() {
        return false;
    }

    public boolean canWriteTypeId() {
        return false;
    }

    public boolean canWriteBinaryNatively() {
        return false;
    }

    public boolean canOmitFields() {
        return true;
    }

    public abstract void writeStartArray();

    public void writeStartArray(int n) {
        this.writeStartArray();
    }

    public abstract void writeEndArray();

    public abstract void writeStartObject();

    public abstract void writeEndObject();

    public abstract void writeFieldName(String var1);

    public abstract void writeFieldName(SerializableString var1);

    public abstract void writeString(String var1);

    public abstract void writeString(char[] var1, int var2, int var3);

    public abstract void writeString(SerializableString var1);

    public abstract void writeRawUTF8String(byte[] var1, int var2, int var3);

    public abstract void writeUTF8String(byte[] var1, int var2, int var3);

    public abstract void writeRaw(String var1);

    public abstract void writeRaw(String var1, int var2, int var3);

    public abstract void writeRaw(char[] var1, int var2, int var3);

    public abstract void writeRaw(char var1);

    public void writeRaw(SerializableString serializableString) {
        this.writeRaw(serializableString.getValue());
    }

    public abstract void writeRawValue(String var1);

    public abstract void writeRawValue(String var1, int var2, int var3);

    public abstract void writeRawValue(char[] var1, int var2, int var3);

    public void writeRawValue(SerializableString serializableString) {
        this.writeRawValue(serializableString.getValue());
    }

    public abstract void writeBinary(Base64Variant var1, byte[] var2, int var3, int var4);

    public void writeBinary(byte[] byArray, int n, int n2) {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, n, n2);
    }

    public void writeBinary(byte[] byArray) {
        this.writeBinary(Base64Variants.getDefaultVariant(), byArray, 0, byArray.length);
    }

    public int writeBinary(InputStream inputStream, int n) {
        return this.writeBinary(Base64Variants.getDefaultVariant(), inputStream, n);
    }

    public abstract int writeBinary(Base64Variant var1, InputStream var2, int var3);

    public void writeNumber(short s) {
        this.writeNumber((int)s);
    }

    public abstract void writeNumber(int var1);

    public abstract void writeNumber(long var1);

    public abstract void writeNumber(BigInteger var1);

    public abstract void writeNumber(double var1);

    public abstract void writeNumber(float var1);

    public abstract void writeNumber(BigDecimal var1);

    public abstract void writeNumber(String var1);

    public abstract void writeBoolean(boolean var1);

    public abstract void writeNull();

    public void writeObjectId(Object object) {
        throw new JsonGenerationException("No native support for writing Object Ids");
    }

    public void writeObjectRef(Object object) {
        throw new JsonGenerationException("No native support for writing Object Ids");
    }

    public void writeTypeId(Object object) {
        throw new JsonGenerationException("No native support for writing Type Ids");
    }

    public abstract void writeObject(Object var1);

    public abstract void writeTree(TreeNode var1);

    public void writeStringField(String string, String string2) {
        this.writeFieldName(string);
        this.writeString(string2);
    }

    public final void writeBooleanField(String string, boolean bl) {
        this.writeFieldName(string);
        this.writeBoolean(bl);
    }

    public final void writeNullField(String string) {
        this.writeFieldName(string);
        this.writeNull();
    }

    public final void writeNumberField(String string, int n) {
        this.writeFieldName(string);
        this.writeNumber(n);
    }

    public final void writeNumberField(String string, long l) {
        this.writeFieldName(string);
        this.writeNumber(l);
    }

    public final void writeNumberField(String string, double d2) {
        this.writeFieldName(string);
        this.writeNumber(d2);
    }

    public final void writeNumberField(String string, float f2) {
        this.writeFieldName(string);
        this.writeNumber(f2);
    }

    public final void writeNumberField(String string, BigDecimal bigDecimal) {
        this.writeFieldName(string);
        this.writeNumber(bigDecimal);
    }

    public final void writeBinaryField(String string, byte[] byArray) {
        this.writeFieldName(string);
        this.writeBinary(byArray);
    }

    public final void writeArrayFieldStart(String string) {
        this.writeFieldName(string);
        this.writeStartArray();
    }

    public final void writeObjectFieldStart(String string) {
        this.writeFieldName(string);
        this.writeStartObject();
    }

    public final void writeObjectField(String string, Object object) {
        this.writeFieldName(string);
        this.writeObject(object);
    }

    public void writeOmittedField(String string) {
    }

    public void copyCurrentEvent(JsonParser jsonParser) {
        Enum enum_ = jsonParser.getCurrentToken();
        if (enum_ == null) {
            this._reportError("No current event to copy");
        }
        switch (((JsonToken)enum_).id()) {
            case -1: {
                this._reportError("No current event to copy");
            }
            case 1: {
                this.writeStartObject();
                return;
            }
            case 2: {
                this.writeEndObject();
                return;
            }
            case 3: {
                this.writeStartArray();
                return;
            }
            case 4: {
                this.writeEndArray();
                return;
            }
            case 5: {
                this.writeFieldName(jsonParser.getCurrentName());
                return;
            }
            case 6: {
                if (jsonParser.hasTextCharacters()) {
                    this.writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                    return;
                }
                this.writeString(jsonParser.getText());
                return;
            }
            case 7: {
                enum_ = jsonParser.getNumberType();
                if (enum_ == JsonParser$NumberType.INT) {
                    this.writeNumber(jsonParser.getIntValue());
                    return;
                }
                if (enum_ == JsonParser$NumberType.BIG_INTEGER) {
                    this.writeNumber(jsonParser.getBigIntegerValue());
                    return;
                }
                this.writeNumber(jsonParser.getLongValue());
                return;
            }
            case 8: {
                enum_ = jsonParser.getNumberType();
                if (enum_ == JsonParser$NumberType.BIG_DECIMAL) {
                    this.writeNumber(jsonParser.getDecimalValue());
                    return;
                }
                if (enum_ == JsonParser$NumberType.FLOAT) {
                    this.writeNumber(jsonParser.getFloatValue());
                    return;
                }
                this.writeNumber(jsonParser.getDoubleValue());
                return;
            }
            case 9: {
                this.writeBoolean(true);
                return;
            }
            case 10: {
                this.writeBoolean(false);
                return;
            }
            case 11: {
                this.writeNull();
                return;
            }
            case 12: {
                this.writeObject(jsonParser.getEmbeddedObject());
                return;
            }
        }
        this._throwInternal();
    }

    public void copyCurrentStructure(JsonParser jsonParser) {
        int n;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == null) {
            this._reportError("No current event to copy");
        }
        if ((n = jsonToken.id()) == 5) {
            this.writeFieldName(jsonParser.getCurrentName());
            n = jsonParser.nextToken().id();
        }
        switch (n) {
            case 1: {
                this.writeStartObject();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndObject();
                return;
            }
            case 3: {
                this.writeStartArray();
                while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.copyCurrentStructure(jsonParser);
                }
                this.writeEndArray();
                return;
            }
        }
        this.copyCurrentEvent(jsonParser);
    }

    public abstract JsonStreamContext getOutputContext();

    @Override
    public abstract void flush();

    public abstract boolean isClosed();

    @Override
    public abstract void close();

    protected void _reportError(String string) {
        throw new JsonGenerationException(string);
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Operation not supported by generator of type " + this.getClass().getName());
    }

    protected void _writeSimpleObject(Object object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        if (object instanceof String) {
            this.writeString((String)object);
            return;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (number instanceof Integer) {
                this.writeNumber(number.intValue());
                return;
            }
            if (number instanceof Long) {
                this.writeNumber(number.longValue());
                return;
            }
            if (number instanceof Double) {
                this.writeNumber(number.doubleValue());
                return;
            }
            if (number instanceof Float) {
                this.writeNumber(number.floatValue());
                return;
            }
            if (number instanceof Short) {
                this.writeNumber(number.shortValue());
                return;
            }
            if (number instanceof Byte) {
                this.writeNumber(number.byteValue());
                return;
            }
            if (number instanceof BigInteger) {
                this.writeNumber((BigInteger)number);
                return;
            }
            if (number instanceof BigDecimal) {
                this.writeNumber((BigDecimal)number);
                return;
            }
            if (number instanceof AtomicInteger) {
                this.writeNumber(((AtomicInteger)number).get());
                return;
            }
            if (number instanceof AtomicLong) {
                this.writeNumber(((AtomicLong)number).get());
                return;
            }
        } else {
            if (object instanceof byte[]) {
                this.writeBinary((byte[])object);
                return;
            }
            if (object instanceof Boolean) {
                this.writeBoolean((Boolean)object);
                return;
            }
            if (object instanceof AtomicBoolean) {
                this.writeBoolean(((AtomicBoolean)object).get());
                return;
            }
        }
        throw new IllegalStateException("No ObjectCodec defined for the generator, can only serialize simple wrapper types (type passed " + object.getClass().getName() + ")");
    }
}

