/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.base;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser$Feature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonStreamContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.NumberInput;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.VersionUtil;
import java.io.IOException;

public abstract class ParserMinimalBase
extends JsonParser {
    protected static final int INT_TAB = 9;
    protected static final int INT_LF = 10;
    protected static final int INT_CR = 13;
    protected static final int INT_SPACE = 32;
    protected static final int INT_LBRACKET = 91;
    protected static final int INT_RBRACKET = 93;
    protected static final int INT_LCURLY = 123;
    protected static final int INT_RCURLY = 125;
    protected static final int INT_QUOTE = 34;
    protected static final int INT_BACKSLASH = 92;
    protected static final int INT_SLASH = 47;
    protected static final int INT_COLON = 58;
    protected static final int INT_COMMA = 44;
    protected static final int INT_HASH = 35;
    protected static final int INT_PERIOD = 46;
    protected static final int INT_e = 101;
    protected static final int INT_E = 69;
    protected JsonToken _currToken;
    protected JsonToken _lastClearedToken;

    protected ParserMinimalBase() {
    }

    protected ParserMinimalBase(int n2) {
        super(n2);
    }

    @Override
    public abstract JsonToken nextToken();

    @Override
    public JsonToken getCurrentToken() {
        return this._currToken;
    }

    @Override
    public int getCurrentTokenId() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return 0;
        }
        return jsonToken.id();
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public boolean hasTokenId(int n2) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return n2 == 0;
        }
        return jsonToken.id() == n2;
    }

    @Override
    public boolean hasToken(JsonToken jsonToken) {
        return this._currToken == jsonToken;
    }

    @Override
    public boolean isExpectedStartArrayToken() {
        return this._currToken == JsonToken.START_ARRAY;
    }

    @Override
    public boolean isExpectedStartObjectToken() {
        return this._currToken == JsonToken.START_OBJECT;
    }

    @Override
    public JsonToken nextValue() {
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            jsonToken = this.nextToken();
        }
        return jsonToken;
    }

    @Override
    public JsonParser skipChildren() {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int n2 = 1;
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = this.nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            if (jsonToken.isStructStart()) {
                ++n2;
                continue;
            }
            if (jsonToken.isStructEnd() && --n2 == 0) break;
        }
        return this;
    }

    protected abstract void _handleEOF();

    @Override
    public abstract String getCurrentName();

    @Override
    public abstract void close();

    @Override
    public abstract boolean isClosed();

    @Override
    public abstract JsonStreamContext getParsingContext();

    @Override
    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken getLastClearedToken() {
        return this._lastClearedToken;
    }

    @Override
    public abstract void overrideCurrentName(String var1);

    @Override
    public abstract String getText();

    @Override
    public abstract char[] getTextCharacters();

    @Override
    public abstract boolean hasTextCharacters();

    @Override
    public abstract int getTextLength();

    @Override
    public abstract int getTextOffset();

    @Override
    public abstract byte[] getBinaryValue(Base64Variant var1);

    @Override
    public boolean getValueAsBoolean(boolean bl) {
        Object object = this._currToken;
        if (object != null) {
            switch (object.id()) {
                case 6: {
                    object = this.getText().trim();
                    if ("true".equals(object)) {
                        return true;
                    }
                    if ("false".equals(object)) {
                        return false;
                    }
                    if (!this._hasTextualNull((String)object)) break;
                    return false;
                }
                case 7: {
                    return this.getIntValue() != 0;
                }
                case 9: {
                    return true;
                }
                case 10: 
                case 11: {
                    return false;
                }
                case 12: {
                    object = this.getEmbeddedObject();
                    if (!(object instanceof Boolean)) break;
                    return (Boolean)object;
                }
            }
        }
        return bl;
    }

    @Override
    public int getValueAsInt() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return this.getIntValue();
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getIntValue();
        }
        return this.getValueAsInt(0);
    }

    @Override
    public int getValueAsInt(int n2) {
        Object object = this._currToken;
        if (object == JsonToken.VALUE_NUMBER_INT) {
            return this.getIntValue();
        }
        if (object == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getIntValue();
        }
        if (object != null) {
            switch (object.id()) {
                case 6: {
                    object = this.getText();
                    if (this._hasTextualNull((String)object)) {
                        return 0;
                    }
                    return NumberInput.parseAsInt((String)object, n2);
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 0;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).intValue();
                }
            }
        }
        return n2;
    }

    @Override
    public long getValueAsLong() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return this.getLongValue();
        }
        if (jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getLongValue();
        }
        return this.getValueAsLong(0L);
    }

    @Override
    public long getValueAsLong(long l2) {
        Object object = this._currToken;
        if (object == JsonToken.VALUE_NUMBER_INT) {
            return this.getLongValue();
        }
        if (object == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getLongValue();
        }
        if (object != null) {
            switch (object.id()) {
                case 6: {
                    object = this.getText();
                    if (this._hasTextualNull((String)object)) {
                        return 0L;
                    }
                    return NumberInput.parseAsLong((String)object, l2);
                }
                case 9: {
                    return 1L;
                }
                case 10: 
                case 11: {
                    return 0L;
                }
                case 12: {
                    object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).longValue();
                }
            }
        }
        return l2;
    }

    @Override
    public double getValueAsDouble(double d2) {
        Object object = this._currToken;
        if (object != null) {
            switch (object.id()) {
                case 6: {
                    object = this.getText();
                    if (this._hasTextualNull((String)object)) {
                        return 0.0;
                    }
                    return NumberInput.parseAsDouble((String)object, d2);
                }
                case 7: 
                case 8: {
                    return this.getDoubleValue();
                }
                case 9: {
                    return 1.0;
                }
                case 10: 
                case 11: {
                    return 0.0;
                }
                case 12: {
                    object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).doubleValue();
                }
            }
        }
        return d2;
    }

    @Override
    public String getValueAsString() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this.getText();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        return this.getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this.getText();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.getCurrentName();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return string;
        }
        return this.getText();
    }

    protected void _decodeBase64(String string, ByteArrayBuilder byteArrayBuilder, Base64Variant base64Variant) {
        try {
            base64Variant.decode(string, byteArrayBuilder);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._reportError(illegalArgumentException.getMessage());
            return;
        }
    }

    protected boolean _hasTextualNull(String string) {
        return "null".equals(string);
    }

    protected void _reportUnexpectedChar(int n2, String string) {
        if (n2 < 0) {
            this._reportInvalidEOF();
        }
        String string2 = "Unexpected character (" + ParserMinimalBase._getCharDesc(n2) + ")";
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        this._reportError(string2);
    }

    protected void _reportInvalidEOF() {
        this._reportInvalidEOF(" in " + (Object)((Object)this._currToken));
    }

    protected void _reportInvalidEOF(String string) {
        this._reportError("Unexpected end-of-input" + string);
    }

    protected void _reportInvalidEOFInValue() {
        this._reportInvalidEOF(" in a value");
    }

    protected void _reportMissingRootWS(int n2) {
        this._reportUnexpectedChar(n2, "Expected space separating root-level values");
    }

    protected void _throwInvalidSpace(int n2) {
        n2 = (char)n2;
        String string = "Illegal character (" + ParserMinimalBase._getCharDesc(n2) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        this._reportError(string);
    }

    protected void _throwUnquotedSpace(int n2, String string) {
        if (!this.isEnabled(JsonParser$Feature.ALLOW_UNQUOTED_CONTROL_CHARS) || n2 > 32) {
            n2 = (char)n2;
            String string2 = "Illegal unquoted character (" + ParserMinimalBase._getCharDesc(n2) + "): has to be escaped using backslash to be included in " + string;
            this._reportError(string2);
        }
    }

    protected char _handleUnrecognizedCharacterEscape(char c2) {
        if (this.isEnabled(JsonParser$Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return c2;
        }
        if (c2 == '\'' && this.isEnabled(JsonParser$Feature.ALLOW_SINGLE_QUOTES)) {
            return c2;
        }
        this._reportError("Unrecognized character escape " + ParserMinimalBase._getCharDesc(c2));
        return c2;
    }

    protected static final String _getCharDesc(int n2) {
        char c2 = (char)n2;
        if (Character.isISOControl(c2)) {
            return "(CTRL-CHAR, code " + n2 + ")";
        }
        if (n2 > 255) {
            return "'" + c2 + "' (code " + n2 + " / 0x" + Integer.toHexString(n2) + ")";
        }
        return "'" + c2 + "' (code " + n2 + ")";
    }

    protected final void _reportError(String string) {
        throw this._constructError(string);
    }

    protected final void _wrapError(String string, Throwable throwable) {
        throw this._constructError(string, throwable);
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected final JsonParseException _constructError(String string, Throwable throwable) {
        return new JsonParseException(string, this.getCurrentLocation(), throwable);
    }

    protected static byte[] _asciiBytes(String string) {
        byte[] byArray = new byte[string.length()];
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        return byArray;
    }

    protected static String _ascii(byte[] byArray) {
        try {
            return new String(byArray, "US-ASCII");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

