/*
 * Decompiled with CFR 0.152.
 */
package gradlegitproperties.org.eclipse.jgit.revwalk.filter;

import gradlegitproperties.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import gradlegitproperties.org.eclipse.jgit.errors.MissingObjectException;
import gradlegitproperties.org.eclipse.jgit.errors.StopWalkException;
import gradlegitproperties.org.eclipse.jgit.internal.JGitText;
import gradlegitproperties.org.eclipse.jgit.revwalk.RevCommit;
import gradlegitproperties.org.eclipse.jgit.revwalk.RevWalk;
import gradlegitproperties.org.eclipse.jgit.revwalk.filter.RevFilter;
import java.io.IOException;

public class SkipRevFilter
extends RevFilter {
    private final int skip;
    private int count;

    public static RevFilter create(int skip) {
        if (skip < 0) {
            throw new IllegalArgumentException(JGitText.get().skipMustBeNonNegative);
        }
        return new SkipRevFilter(skip);
    }

    private SkipRevFilter(int skip) {
        this.skip = skip;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.skip <= this.count++;
    }

    @Override
    public RevFilter clone() {
        return new SkipRevFilter(this.skip);
    }
}

