/*
 * Decompiled with CFR 0.152.
 */
package gradlegitproperties.org.eclipse.jgit.patch;

import gradlegitproperties.org.eclipse.jgit.internal.JGitText;
import gradlegitproperties.org.eclipse.jgit.lib.AbbreviatedObjectId;
import gradlegitproperties.org.eclipse.jgit.patch.CombinedFileHeader;
import gradlegitproperties.org.eclipse.jgit.patch.HunkHeader;
import gradlegitproperties.org.eclipse.jgit.patch.Patch;
import gradlegitproperties.org.eclipse.jgit.util.MutableInteger;
import gradlegitproperties.org.eclipse.jgit.util.RawParseUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;

public class CombinedHunkHeader
extends HunkHeader {
    private CombinedOldImage[] old;

    CombinedHunkHeader(final CombinedFileHeader fh, int offset) {
        super(fh, offset, null);
        this.old = new CombinedOldImage[fh.getParentCount()];
        int i = 0;
        while (i < this.old.length) {
            final int imagePos = i;
            this.old[i] = new CombinedOldImage(){

                @Override
                public AbbreviatedObjectId getId() {
                    return fh.getOldId(imagePos);
                }
            };
            ++i;
        }
    }

    @Override
    public CombinedFileHeader getFileHeader() {
        return (CombinedFileHeader)super.getFileHeader();
    }

    @Override
    public HunkHeader.OldImage getOldImage() {
        return this.getOldImage(0);
    }

    public HunkHeader.OldImage getOldImage(int nthParent) {
        return this.old[nthParent];
    }

    @Override
    void parseHeader() {
        byte[] buf = this.file.buf;
        MutableInteger ptr = new MutableInteger();
        ptr.value = RawParseUtils.nextLF(buf, this.startOffset, ' ');
        CombinedOldImage[] combinedOldImageArray = this.old;
        int n = this.old.length;
        int n2 = 0;
        while (n2 < n) {
            CombinedOldImage o = combinedOldImageArray[n2];
            o.startLine = -RawParseUtils.parseBase10(buf, ptr.value, ptr);
            o.lineCount = buf[ptr.value] == 44 ? RawParseUtils.parseBase10(buf, ptr.value + 1, ptr) : 1;
            ++n2;
        }
        this.newStartLine = RawParseUtils.parseBase10(buf, ptr.value + 1, ptr);
        this.newLineCount = buf[ptr.value] == 44 ? RawParseUtils.parseBase10(buf, ptr.value + 1, ptr) : 1;
    }

    @Override
    int parseBody(Patch script, int end) {
        byte[] buf = this.file.buf;
        int c = RawParseUtils.nextLF(buf, this.startOffset);
        CombinedOldImage[] combinedOldImageArray = this.old;
        int n = this.old.length;
        int n2 = 0;
        while (n2 < n) {
            CombinedOldImage o = combinedOldImageArray[n2];
            o.nDeleted = 0;
            o.nAdded = 0;
            o.nContext = 0;
            ++n2;
        }
        this.nContext = 0;
        int nAdded = 0;
        block9: while (c < end) {
            int eol = RawParseUtils.nextLF(buf, c);
            if (eol - c < this.old.length + 1) break;
            switch (buf[c]) {
                case 32: 
                case 43: 
                case 45: {
                    break;
                }
                default: {
                    break block9;
                }
            }
            int localcontext = 0;
            int ancestor = 0;
            while (ancestor < this.old.length) {
                switch (buf[c + ancestor]) {
                    case 32: {
                        ++localcontext;
                        ++this.old[ancestor].nContext;
                        break;
                    }
                    case 45: {
                        ++this.old[ancestor].nDeleted;
                        break;
                    }
                    case 43: {
                        ++this.old[ancestor].nAdded;
                        ++nAdded;
                        break;
                    }
                    default: {
                        break block9;
                    }
                }
                ++ancestor;
            }
            if (localcontext == this.old.length) {
                ++this.nContext;
            }
            c = eol;
        }
        int ancestor = 0;
        while (ancestor < this.old.length) {
            CombinedOldImage o = this.old[ancestor];
            int cmp = o.nContext + o.nDeleted;
            if (cmp < o.lineCount) {
                int missingCnt = o.lineCount - cmp;
                script.error(buf, this.startOffset, MessageFormat.format(JGitText.get().truncatedHunkLinesMissingForAncestor, missingCnt, ancestor + 1));
            }
            ++ancestor;
        }
        if (this.nContext + nAdded < this.newLineCount) {
            int missingCount = this.newLineCount - (this.nContext + nAdded);
            script.error(buf, this.startOffset, MessageFormat.format(JGitText.get().truncatedHunkNewLinesMissing, missingCount));
        }
        return c;
    }

    @Override
    void extractFileLines(OutputStream[] out) throws IOException {
        byte[] buf = this.file.buf;
        int ptr = this.startOffset;
        int eol = RawParseUtils.nextLF(buf, ptr);
        if (this.endOffset <= eol) {
            return;
        }
        out[0].write(buf, ptr, eol - ptr);
        ptr = eol;
        block8: while (ptr < this.endOffset) {
            eol = RawParseUtils.nextLF(buf, ptr);
            if (eol - ptr < this.old.length + 1) break;
            switch (buf[ptr]) {
                case 32: 
                case 43: 
                case 45: {
                    break;
                }
                default: {
                    break block8;
                }
            }
            int delcnt = 0;
            int ancestor = 0;
            while (ancestor < this.old.length) {
                switch (buf[ptr + ancestor]) {
                    case 45: {
                        ++delcnt;
                        out[ancestor].write(buf, ptr, eol - ptr);
                        break;
                    }
                    case 32: {
                        out[ancestor].write(buf, ptr, eol - ptr);
                        break;
                    }
                    case 43: {
                        break;
                    }
                    default: {
                        break block8;
                    }
                }
                ++ancestor;
            }
            if (delcnt < this.old.length) {
                out[this.old.length].write(buf, ptr, eol - ptr);
            }
            ptr = eol;
        }
    }

    @Override
    void extractFileLines(StringBuilder sb, String[] text, int[] offsets) {
        byte[] buf = this.file.buf;
        int ptr = this.startOffset;
        int eol = RawParseUtils.nextLF(buf, ptr);
        if (this.endOffset <= eol) {
            return;
        }
        this.copyLine(sb, text, offsets, 0);
        ptr = eol;
        block7: while (ptr < this.endOffset) {
            eol = RawParseUtils.nextLF(buf, ptr);
            if (eol - ptr < this.old.length + 1) break;
            switch (buf[ptr]) {
                case 32: 
                case 43: 
                case 45: {
                    break;
                }
                default: {
                    break block7;
                }
            }
            boolean copied = false;
            int ancestor = 0;
            while (ancestor < this.old.length) {
                switch (buf[ptr + ancestor]) {
                    case 32: 
                    case 45: {
                        if (copied) {
                            this.skipLine(text, offsets, ancestor);
                            break;
                        }
                        this.copyLine(sb, text, offsets, ancestor);
                        copied = true;
                        break;
                    }
                    case 43: {
                        break;
                    }
                    default: {
                        break block7;
                    }
                }
                ++ancestor;
            }
            if (!copied) {
                this.copyLine(sb, text, offsets, this.old.length);
            }
            ptr = eol;
        }
    }

    private static abstract class CombinedOldImage
    extends HunkHeader.OldImage {
        int nContext;

        private CombinedOldImage() {
        }
    }
}

