/*
 * Decompiled with CFR 0.152.
 */
package gradlegitproperties.org.eclipse.jgit.lib;

import gradlegitproperties.org.eclipse.jgit.annotations.NonNull;
import gradlegitproperties.org.eclipse.jgit.annotations.Nullable;
import gradlegitproperties.org.eclipse.jgit.api.errors.CanceledException;
import gradlegitproperties.org.eclipse.jgit.lib.CommitBuilder;
import gradlegitproperties.org.eclipse.jgit.lib.PersonIdent;
import gradlegitproperties.org.eclipse.jgit.transport.CredentialsProvider;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GpgSigner {
    private static final Logger LOG = LoggerFactory.getLogger(GpgSigner.class);
    private static GpgSigner defaultSigner = GpgSigner.loadGpgSigner();

    private static GpgSigner loadGpgSigner() {
        try {
            ServiceLoader<GpgSigner> loader = ServiceLoader.load(GpgSigner.class);
            Iterator<GpgSigner> iter = loader.iterator();
            if (iter.hasNext()) {
                return iter.next();
            }
        }
        catch (ServiceConfigurationError e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static GpgSigner getDefault() {
        return defaultSigner;
    }

    public static void setDefault(GpgSigner signer) {
        defaultSigner = signer;
    }

    public abstract void sign(@NonNull CommitBuilder var1, @Nullable String var2, @NonNull PersonIdent var3, CredentialsProvider var4) throws CanceledException;

    public abstract boolean canLocateSigningKey(@Nullable String var1, @NonNull PersonIdent var2, CredentialsProvider var3) throws CanceledException;
}

