/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import android.view.MotionEvent;
import com.google.ar.sceneform.HitTestResult;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.ux.BaseGesture;
import com.google.ar.sceneform.ux.GesturePointersUtility;

public class TwistGesture
extends BaseGesture<TwistGesture> {
    private static final String TAG = TwistGesture.class.getSimpleName();
    private static final boolean TWIST_GESTURE_DEBUG = false;
    private final int pointerId1;
    private final int pointerId2;
    private final Vector3 startPosition1;
    private final Vector3 startPosition2;
    private final Vector3 previousPosition1;
    private final Vector3 previousPosition2;
    private float deltaRotationDegrees;
    private static final float SLOP_ROTATION_DEGREES = 15.0f;

    public TwistGesture(GesturePointersUtility gesturePointersUtility, MotionEvent motionEvent, int pointerId2) {
        super(gesturePointersUtility);
        this.pointerId1 = motionEvent.getPointerId(motionEvent.getActionIndex());
        this.pointerId2 = pointerId2;
        this.startPosition1 = GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId1);
        this.startPosition2 = GesturePointersUtility.motionEventToPosition(motionEvent, pointerId2);
        this.previousPosition1 = new Vector3(this.startPosition1);
        this.previousPosition2 = new Vector3(this.startPosition2);
        TwistGesture.debugLog("Created");
    }

    public float getDeltaRotationDegrees() {
        return this.deltaRotationDegrees;
    }

    @Override
    protected boolean canStart(HitTestResult hitTestResult, MotionEvent motionEvent) {
        boolean touchEnded;
        if (this.gesturePointersUtility.isPointerIdRetained(this.pointerId1) || this.gesturePointersUtility.isPointerIdRetained(this.pointerId2)) {
            this.cancel();
            return false;
        }
        int actionId = motionEvent.getPointerId(motionEvent.getActionIndex());
        int action = motionEvent.getActionMasked();
        if (action == 3) {
            this.cancel();
            return false;
        }
        boolean bl = touchEnded = action == 1 || action == 6;
        if (touchEnded && (actionId == this.pointerId1 || actionId == this.pointerId2)) {
            this.cancel();
            return false;
        }
        if (action != 2) {
            return false;
        }
        Vector3 newPosition1 = GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId1);
        Vector3 newPosition2 = GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId2);
        Vector3 deltaPosition1 = Vector3.subtract((Vector3)newPosition1, (Vector3)this.previousPosition1);
        Vector3 deltaPosition2 = Vector3.subtract((Vector3)newPosition2, (Vector3)this.previousPosition2);
        this.previousPosition1.set(newPosition1);
        this.previousPosition2.set(newPosition2);
        if (Vector3.equals((Vector3)deltaPosition1, (Vector3)Vector3.zero()) || Vector3.equals((Vector3)deltaPosition2, (Vector3)Vector3.zero())) {
            return false;
        }
        float rotation = TwistGesture.calculateDeltaRotation(newPosition1, newPosition2, this.startPosition1, this.startPosition2);
        return !(Math.abs(rotation) < 15.0f);
    }

    @Override
    protected void onStart(HitTestResult hitTestResult, MotionEvent motionEvent) {
        TwistGesture.debugLog("Started");
        this.gesturePointersUtility.retainPointerId(this.pointerId1);
        this.gesturePointersUtility.retainPointerId(this.pointerId2);
    }

    @Override
    protected boolean updateGesture(HitTestResult hitTestResult, MotionEvent motionEvent) {
        boolean touchEnded;
        int actionId = motionEvent.getPointerId(motionEvent.getActionIndex());
        int action = motionEvent.getActionMasked();
        if (action == 3) {
            this.cancel();
            return false;
        }
        boolean bl = touchEnded = action == 1 || action == 6;
        if (touchEnded && (actionId == this.pointerId1 || actionId == this.pointerId2)) {
            this.complete();
            return false;
        }
        if (action != 2) {
            return false;
        }
        Vector3 newPosition1 = GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId1);
        Vector3 newPosition2 = GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId2);
        this.deltaRotationDegrees = TwistGesture.calculateDeltaRotation(newPosition1, newPosition2, this.previousPosition1, this.previousPosition2);
        this.previousPosition1.set(newPosition1);
        this.previousPosition2.set(newPosition2);
        TwistGesture.debugLog("Update: " + this.deltaRotationDegrees);
        return true;
    }

    @Override
    protected void onCancel() {
        TwistGesture.debugLog("Cancelled");
    }

    @Override
    protected void onFinish() {
        TwistGesture.debugLog("Finished");
        this.gesturePointersUtility.releasePointerId(this.pointerId1);
        this.gesturePointersUtility.releasePointerId(this.pointerId2);
    }

    @Override
    protected TwistGesture getSelf() {
        return this;
    }

    private static void debugLog(String log) {
    }

    private static float calculateDeltaRotation(Vector3 currentPosition1, Vector3 currentPosition2, Vector3 previousPosition1, Vector3 previousPosition2) {
        Vector3 currentDirection = Vector3.subtract((Vector3)currentPosition1, (Vector3)currentPosition2).normalized();
        Vector3 previousDirection = Vector3.subtract((Vector3)previousPosition1, (Vector3)previousPosition2).normalized();
        float sign = Math.signum(previousDirection.x * currentDirection.y - previousDirection.y * currentDirection.x);
        return Vector3.angleBetweenVectors((Vector3)currentDirection, (Vector3)previousDirection) * sign;
    }

    public static interface OnGestureEventListener
    extends BaseGesture.OnGestureEventListener<TwistGesture> {
    }
}

