/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import android.view.MotionEvent;
import com.google.ar.sceneform.HitTestResult;
import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.ux.BaseGesture;
import com.google.ar.sceneform.ux.GesturePointersUtility;

public class PinchGesture
extends BaseGesture<PinchGesture> {
    private static final String TAG = PinchGesture.class.getSimpleName();
    private final int pointerId1;
    private final int pointerId2;
    private final Vector3 startPosition1;
    private final Vector3 startPosition2;
    private final Vector3 previousPosition1;
    private final Vector3 previousPosition2;
    private float gap;
    private float gapDelta;
    private static final float SLOP_INCHES = 0.05f;
    private static final float SLOP_MOTION_DIRECTION_DEGREES = 30.0f;
    private static final boolean PINCH_GESTURE_DEBUG = false;

    public PinchGesture(GesturePointersUtility gesturePointersUtility, MotionEvent motionEvent, int pointerId2) {
        super(gesturePointersUtility);
        this.pointerId1 = motionEvent.getPointerId(motionEvent.getActionIndex());
        this.pointerId2 = pointerId2;
        this.startPosition1 = GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId1);
        this.startPosition2 = GesturePointersUtility.motionEventToPosition(motionEvent, pointerId2);
        this.previousPosition1 = new Vector3(this.startPosition1);
        this.previousPosition2 = new Vector3(this.startPosition2);
        PinchGesture.debugLog("Created");
    }

    public float getGap() {
        return this.gap;
    }

    public float gapInches() {
        return this.gesturePointersUtility.pixelsToInches(this.getGap());
    }

    public float getGapDelta() {
        return this.gapDelta;
    }

    public float gapDeltaInches() {
        return this.gesturePointersUtility.pixelsToInches(this.getGapDelta());
    }

    @Override
    public void cancel() {
        super.cancel();
    }

    @Override
    protected boolean canStart(HitTestResult hitTestResult, MotionEvent motionEvent) {
        float slopPixels;
        boolean touchEnded;
        if (this.gesturePointersUtility.isPointerIdRetained(this.pointerId1) || this.gesturePointersUtility.isPointerIdRetained(this.pointerId2)) {
            this.cancel();
            return false;
        }
        int actionId = motionEvent.getPointerId(motionEvent.getActionIndex());
        int action = motionEvent.getActionMasked();
        if (action == 3) {
            this.cancel();
            return false;
        }
        boolean bl = touchEnded = action == 1 || action == 6;
        if (touchEnded && (actionId == this.pointerId1 || actionId == this.pointerId2)) {
            this.cancel();
            return false;
        }
        if (action != 2) {
            return false;
        }
        Vector3 firstToSecond = Vector3.subtract((Vector3)this.startPosition1, (Vector3)this.startPosition2);
        Vector3 firstToSecondDirection = firstToSecond.normalized();
        Vector3 newPosition1 = GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId1);
        Vector3 newPosition2 = GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId2);
        Vector3 deltaPosition1 = Vector3.subtract((Vector3)newPosition1, (Vector3)this.previousPosition1);
        Vector3 deltaPosition2 = Vector3.subtract((Vector3)newPosition2, (Vector3)this.previousPosition2);
        this.previousPosition1.set(newPosition1);
        this.previousPosition2.set(newPosition2);
        float dot1 = Vector3.dot((Vector3)deltaPosition1.normalized(), (Vector3)firstToSecondDirection.negated());
        float dot2 = Vector3.dot((Vector3)deltaPosition2.normalized(), (Vector3)firstToSecondDirection);
        float dotThreshold = (float)Math.cos(Math.toRadians(30.0));
        if (!Vector3.equals((Vector3)deltaPosition1, (Vector3)Vector3.zero()) && Math.abs(dot1) < dotThreshold) {
            return false;
        }
        if (!Vector3.equals((Vector3)deltaPosition2, (Vector3)Vector3.zero()) && Math.abs(dot2) < dotThreshold) {
            return false;
        }
        float startGap = firstToSecond.length();
        this.gap = Vector3.subtract((Vector3)newPosition1, (Vector3)newPosition2).length();
        float separation = Math.abs(this.gap - startGap);
        return !(separation < (slopPixels = this.gesturePointersUtility.inchesToPixels(0.05f)));
    }

    @Override
    protected void onStart(HitTestResult hitTestResult, MotionEvent motionEvent) {
        PinchGesture.debugLog("Started");
        this.gesturePointersUtility.retainPointerId(this.pointerId1);
        this.gesturePointersUtility.retainPointerId(this.pointerId2);
    }

    @Override
    protected boolean updateGesture(HitTestResult hitTestResult, MotionEvent motionEvent) {
        Vector3 newPosition2;
        boolean touchEnded;
        int actionId = motionEvent.getPointerId(motionEvent.getActionIndex());
        int action = motionEvent.getActionMasked();
        if (action == 3) {
            this.cancel();
            return false;
        }
        boolean bl = touchEnded = action == 1 || action == 6;
        if (touchEnded && (actionId == this.pointerId1 || actionId == this.pointerId2)) {
            this.complete();
            return false;
        }
        if (action != 2) {
            return false;
        }
        Vector3 newPosition1 = GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId1);
        float newGap = Vector3.subtract((Vector3)newPosition1, (Vector3)(newPosition2 = GesturePointersUtility.motionEventToPosition(motionEvent, this.pointerId2))).length();
        if (newGap == this.gap) {
            return false;
        }
        this.gapDelta = newGap - this.gap;
        this.gap = newGap;
        PinchGesture.debugLog("Update: " + this.gapDelta);
        return true;
    }

    @Override
    protected void onCancel() {
        PinchGesture.debugLog("Cancelled");
    }

    @Override
    protected void onFinish() {
        PinchGesture.debugLog("Finished");
        this.gesturePointersUtility.releasePointerId(this.pointerId1);
        this.gesturePointersUtility.releasePointerId(this.pointerId2);
    }

    @Override
    protected PinchGesture getSelf() {
        return this;
    }

    private static void debugLog(String log) {
    }

    public static interface OnGestureEventListener
    extends BaseGesture.OnGestureEventListener<PinchGesture> {
    }
}

