/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.ux;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ar.core.Anchor;
import com.google.ar.core.exceptions.UnavailableApkTooOldException;
import com.google.ar.core.exceptions.UnavailableArcoreNotInstalledException;
import com.google.ar.core.exceptions.UnavailableDeviceNotCompatibleException;
import com.google.ar.core.exceptions.UnavailableException;
import com.google.ar.core.exceptions.UnavailableSdkTooOldException;
import com.google.ar.sceneform.AnchorNode;
import com.google.ar.sceneform.ArSceneView;
import com.google.ar.sceneform.NodeParent;
import com.google.ar.sceneform.rendering.ModelRenderable;
import com.google.ar.sceneform.rendering.Renderable;
import com.google.ar.sceneform.rendering.RenderableInstance;
import com.google.ar.sceneform.ux.BaseArFragment;
import com.google.ar.sceneform.ux.R;
import com.google.ar.sceneform.ux.TransformableNode;
import java.util.concurrent.CompletableFuture;

public class ArFragment
extends BaseArFragment {
    private static final String TAG = "StandardArFragment";
    @Nullable
    private OnViewCreatedListener onViewCreatedListener;
    @Nullable
    private OnArUnavailableListener onArUnavailableListener;
    private Renderable onTapRenderable;

    public static ArFragment newInstance(boolean fullscreen) {
        ArFragment fragment = new ArFragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean("fullscreen", fullscreen);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.onViewCreatedListener != null) {
            this.onViewCreatedListener.onViewCreated(this.getArSceneView());
        }
    }

    @Override
    public boolean isArRequired() {
        return true;
    }

    @Override
    protected void onArUnavailableException(UnavailableException sessionException) {
        if (this.onArUnavailableListener != null) {
            this.onArUnavailableListener.onArUnavailableException(sessionException);
        } else {
            String message = sessionException instanceof UnavailableArcoreNotInstalledException ? this.getString(R.string.sceneform_unavailable_arcore_not_installed) : (sessionException instanceof UnavailableApkTooOldException ? this.getString(R.string.sceneform_unavailable_apk_too_old) : (sessionException instanceof UnavailableSdkTooOldException ? this.getString(R.string.sceneform_unavailable_sdk_too_old) : (sessionException instanceof UnavailableDeviceNotCompatibleException ? this.getString(R.string.sceneform_unavailable_device_not_compatible) : this.getString(R.string.sceneform_failed_to_create_ar_session))));
            Log.e((String)TAG, (String)("Error: " + message), (Throwable)sessionException);
            Toast.makeText((Context)this.requireActivity(), (CharSequence)message, (int)1).show();
        }
    }

    public void setOnViewCreatedListener(OnViewCreatedListener onViewCreatedListener) {
        this.onViewCreatedListener = onViewCreatedListener;
    }

    public void setOnArUnavailableListener(@Nullable OnArUnavailableListener onArUnavailableListener) {
        this.onArUnavailableListener = onArUnavailableListener;
    }

    public void setOnTapPlaneGlbModel(String glbSource) {
        this.setOnTapPlaneGlbModel(glbSource, null);
    }

    public void setOnTapPlaneGlbModel(String glbSource, @Nullable OnTapModelListener listener) {
        ((CompletableFuture)((ModelRenderable.Builder)((ModelRenderable.Builder)ModelRenderable.builder().setSource(this.getContext(), Uri.parse((String)glbSource))).setIsFilamentGltf(true)).build().thenAccept(modelRenderable -> {
            this.onTapRenderable = modelRenderable;
        })).exceptionally(throwable -> {
            if (listener != null) {
                listener.onModelError((Throwable)throwable);
            }
            return null;
        });
        this.setOnTapArPlaneListener((hitResult, plane, motionEvent) -> {
            if (this.onTapRenderable == null) {
                return;
            }
            Anchor anchor = hitResult.createAnchor();
            AnchorNode anchorNode = new AnchorNode(anchor);
            anchorNode.setParent((NodeParent)this.getArSceneView().getScene());
            TransformableNode model = new TransformableNode(this.getTransformationSystem());
            model.setParent((NodeParent)anchorNode);
            model.setRenderable(this.onTapRenderable);
            model.select();
            RenderableInstance renderableInstance = model.getRenderableInstance();
            if (renderableInstance != null && renderableInstance.hasAnimations()) {
                renderableInstance.animate(true);
            }
            if (listener != null) {
                listener.onModelAdded(renderableInstance);
            }
        });
    }

    public static interface OnArUnavailableListener {
        public void onArUnavailableException(UnavailableException var1);
    }

    public static interface OnViewCreatedListener {
        public void onViewCreated(ArSceneView var1);
    }

    public static interface OnTapModelListener {
        public void onModelAdded(RenderableInstance var1);

        public void onModelError(Throwable var1);
    }
}

