/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.util.monitor;

import com.google.code.rees.scope.util.monitor.SchedulerProvider;
import com.google.code.rees.scope.util.monitor.TimeoutListener;
import com.google.code.rees.scope.util.monitor.TimeoutMonitor;
import com.google.code.rees.scope.util.monitor.TimeoutRunner;
import com.google.code.rees.scope.util.monitor.Timeoutable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorTimeoutMonitor<T extends Timeoutable<T>>
implements TimeoutMonitor<T>,
TimeoutListener<T> {
    private static final long serialVersionUID = -1502605748762224777L;
    public static final long MONITORING_DELAY = 1000L;
    protected Map<String, TimeoutRunner<T>> timeoutRunners = new HashMap<String, TimeoutRunner<T>>();
    protected transient Map<String, ScheduledFuture<?>> scheduledFutures = null;
    protected transient ScheduledExecutorService scheduler = null;
    protected long monitoringFrequency = 300000L;
    protected SchedulerProvider schedulerProvider;

    protected ScheduledExecutorTimeoutMonitor() {
    }

    @Override
    public void setMonitoringFrequency(long frequencyMillis) {
        this.monitoringFrequency = frequencyMillis;
    }

    public void setSchedulerProvider(SchedulerProvider schedulerProvider) {
        this.schedulerProvider = schedulerProvider;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        this.scheduler = this.schedulerProvider.getScheduler();
        Map<String, TimeoutRunner<T>> map = this.timeoutRunners;
        synchronized (map) {
            if (this.scheduledFutures == null) {
                this.scheduledFutures = new HashMap();
            }
            for (Map.Entry<String, TimeoutRunner<T>> entry : this.timeoutRunners.entrySet()) {
                String targetId = entry.getKey();
                ScheduledFuture<?> future = this.scheduledFutures.get(targetId);
                if (future != null) continue;
                future = this.scheduler.scheduleAtFixedRate(entry.getValue(), 1000L, this.monitoringFrequency, TimeUnit.MILLISECONDS);
                this.scheduledFutures.put(targetId, future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Map<String, TimeoutRunner<T>> map = this.timeoutRunners;
        synchronized (map) {
            if (this.scheduledFutures != null) {
                for (ScheduledFuture<?> future : this.scheduledFutures.values()) {
                    future.cancel(true);
                }
                this.scheduledFutures.clear();
            }
            this.timeoutRunners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTimeoutable(T timeoutable) {
        Map<String, TimeoutRunner<T>> map = this.timeoutRunners;
        synchronized (map) {
            String targetId = timeoutable.getId();
            if (!this.timeoutRunners.containsKey(targetId)) {
                TimeoutRunner timeoutRunner = new TimeoutRunner<T>((Timeoutable)timeoutable, targetId){
                    private transient WeakReference<T> timeoutableReference;
                    private T serializableRef;
                    final /* synthetic */ Timeoutable val$timeoutable;
                    final /* synthetic */ String val$targetId;
                    {
                        this.val$timeoutable = timeoutable;
                        this.val$targetId = string;
                        this.timeoutableReference = new WeakReference<Timeoutable>(this.val$timeoutable);
                        this.serializableRef = null;
                    }

                    @Override
                    public void run() {
                        Object t = this.getTimeoutable();
                        if (t == null) {
                            ScheduledFuture<?> future = ScheduledExecutorTimeoutMonitor.this.scheduledFutures.remove(this.val$targetId);
                            if (future != null) {
                                future.cancel(true);
                            }
                            ScheduledExecutorTimeoutMonitor.this.timeoutRunners.remove(this.val$targetId);
                        } else if (t.getRemainingTime() <= 0L) {
                            t.timeout();
                        }
                    }

                    @Override
                    public T getTimeoutable() {
                        return (Timeoutable)this.timeoutableReference.get();
                    }

                    private void writeObject(ObjectOutputStream out) throws IOException {
                        this.serializableRef = (Timeoutable)this.timeoutableReference.get();
                        out.defaultWriteObject();
                    }

                    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                        in.defaultReadObject();
                        this.timeoutableReference = new WeakReference(this.serializableRef);
                        this.serializableRef = null;
                    }
                };
                this.timeoutRunners.put(targetId, timeoutRunner);
                ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(timeoutRunner, 1000L, this.monitoringFrequency, TimeUnit.MILLISECONDS);
                this.scheduledFutures.put(targetId, future);
                timeoutable.addTimeoutListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTimeoutable(T timeoutable) {
        Map<String, TimeoutRunner<T>> map = this.timeoutRunners;
        synchronized (map) {
            String targetId = timeoutable.getId();
            ScheduledFuture<?> future = this.scheduledFutures.remove(targetId);
            if (future != null) {
                future.cancel(true);
            }
            this.timeoutRunners.remove(targetId);
        }
    }

    @Override
    public void onTimeout(T timeoutable) {
        this.removeTimeoutable(timeoutable);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    public static <TT extends Timeoutable<TT>> ScheduledExecutorTimeoutMonitor<TT> spawnInstance(SchedulerProvider scheduler, long monitoringFrequency) {
        ScheduledExecutorTimeoutMonitor monitor = new ScheduledExecutorTimeoutMonitor();
        monitor.setMonitoringFrequency(monitoringFrequency);
        monitor.setSchedulerProvider(scheduler);
        return monitor;
    }
}

