/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.struts2.test;

import com.google.code.rees.scope.container.ScopeContainerProvider;
import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.conversation.ConversationUtil;
import com.google.code.rees.scope.conversation.configuration.ConversationClassConfiguration;
import com.google.code.rees.scope.conversation.configuration.ConversationConfigurationProvider;
import com.google.code.rees.scope.conversation.configuration.DefaultConversationArbitrator;
import com.google.code.rees.scope.conversation.context.ConversationContext;
import com.google.code.rees.scope.session.SessionUtil;
import com.google.code.rees.scope.util.InjectionUtil;
import com.opensymphony.xwork2.ActionContext;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.apache.struts2.dispatcher.Dispatcher;
import org.springframework.mock.web.MockHttpServletRequest;

public class ScopeTestUtil {
    private static ConversationConfigurationProvider configurationProvider;
    private static DefaultConversationArbitrator arbitrator;
    private static String actionSuffix;

    public static ConversationConfigurationProvider getConfigurationProvider() {
        if (configurationProvider == null) {
            configurationProvider = ((ScopeContainerProvider)Dispatcher.getInstance().getContainer().getInstance(ScopeContainerProvider.class)).getScopeContainer().getComponent(ConversationConfigurationProvider.class);
        }
        return configurationProvider;
    }

    protected static String getActionSuffix() {
        if (actionSuffix == null) {
            actionSuffix = (String)Dispatcher.getInstance().getContainer().getInstance(String.class, "struts.convention.action.suffix");
        }
        return actionSuffix;
    }

    public static void setConversationIdsOnRequest(MockHttpServletRequest request, Class<?> actionClass) {
        ActionContext actionContext = ActionContext.getContext();
        Map convoIdMap = (Map)actionContext.getValueStack().findValue("conversationIdMapStackKey");
        if (convoIdMap != null) {
            for (Map.Entry entry : convoIdMap.entrySet()) {
                request.addParameter((String)entry.getKey(), new String[]{(String)entry.getValue()});
            }
        } else {
            for (String conversationName : arbitrator.getConversations(actionClass, ScopeTestUtil.getActionSuffix())) {
                request.addParameter(ConversationUtil.sanitizeName(conversationName) + "_conversation", conversationName + "-test-id");
            }
        }
    }

    public static void extractScopeFields(Object target) {
        SessionUtil.extractFields(target);
        ScopeTestUtil.extractConversationFields(target, ConversationAdapter.getAdapter());
    }

    public static void injectScopeFields(Object target) {
        SessionUtil.injectFields(target);
        ScopeTestUtil.injectConversationFields(target, ConversationAdapter.getAdapter());
    }

    private static void injectConversationFields(Object target, ConversationAdapter conversationAdapter) {
        Collection<ConversationClassConfiguration> actionConversationConfigs = ScopeTestUtil.getConfigurationProvider().getConfigurations(target.getClass());
        if (actionConversationConfigs != null) {
            for (ConversationClassConfiguration conversation : actionConversationConfigs) {
                Map<String, Field> actionConversationFields;
                ConversationContext conversationContext;
                String conversationName = conversation.getConversationName();
                String conversationId = conversationAdapter.getRequestContext().get(conversationName);
                if (conversationId == null || (conversationContext = conversationAdapter.getConversationContext(conversationName, conversationId)) == null || (actionConversationFields = conversation.getFields()) == null) continue;
                InjectionUtil.setFieldValues(target, actionConversationFields, conversationContext);
            }
        }
    }

    private static void extractConversationFields(Object target, ConversationAdapter conversationAdapter) {
        Collection<ConversationClassConfiguration> actionConversationConfigs = ScopeTestUtil.getConfigurationProvider().getConfigurations(target.getClass());
        if (actionConversationConfigs != null) {
            for (ConversationClassConfiguration conversation : actionConversationConfigs) {
                Map<String, Field> actionConversationFields = conversation.getFields();
                String conversationName = conversation.getConversationName();
                String conversationId = conversationAdapter.getRequestContext().get(conversationName);
                if (conversationId == null) continue;
                if (actionConversationFields != null) {
                    ConversationContext conversationContext = conversationAdapter.getConversationContext(conversationName, conversationId);
                    conversationContext.putAll(InjectionUtil.getFieldValues(target, actionConversationFields));
                }
                conversationAdapter.getViewContext().put(conversationName, conversationId);
            }
        }
    }

    static {
        arbitrator = new DefaultConversationArbitrator();
    }
}

