/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.struts2.programmatic;

import com.google.code.rees.scope.container.ScopeContainer;
import com.google.code.rees.scope.container.ScopeContainerProvider;
import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.conversation.context.ConversationContextManager;
import com.google.code.rees.scope.conversation.context.HttpConversationContextManagerProvider;
import com.google.code.rees.scope.conversation.exceptions.ConversationException;
import com.google.code.rees.scope.conversation.processing.ConversationProcessor;
import com.google.code.rees.scope.struts2.StrutsConversationAdapter;
import com.google.code.rees.scope.struts2.programmatic.ProgrammaticModelDrivenConversation;
import com.google.code.rees.scope.struts2.programmatic.ProgrammaticModelDrivenConversationUtil;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.inject.Inject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class ProgrammaticModelDrivenConversationSupport<T extends Serializable>
extends ActionSupport
implements ProgrammaticModelDrivenConversation<T>,
Preparable {
    private static final long serialVersionUID = -3567083451289146237L;
    private T model;
    protected ScopeContainer scopeContainer;

    @Inject
    public void setScopeContainerProvider(ScopeContainerProvider scopeContainerProvider) {
        this.scopeContainer = scopeContainerProvider.getScopeContainer();
    }

    public T getModel() {
        if (this.model == null) {
            this.model = ProgrammaticModelDrivenConversationUtil.getModel(this, this.getModelName());
        }
        return this.model;
    }

    @Override
    public void setModel(T model) {
        ProgrammaticModelDrivenConversationUtil.setModel(model, this, this.getModelName());
        this.model = model;
    }

    protected String getModelName() {
        return this.getClass().getName();
    }

    public void prepare() {
        ActionContext actionContext = ActionContext.getContext();
        HttpServletRequest request = (HttpServletRequest)actionContext.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        ConversationContextManager contextManager = this.scopeContainer.getComponent(HttpConversationContextManagerProvider.class).getManager(request);
        try {
            this.scopeContainer.getComponent(ConversationProcessor.class).processConversations(new StrutsConversationAdapter(actionContext.getActionInvocation(), contextManager));
            HashMap<String, Map<String, String>> stackItem = new HashMap<String, Map<String, String>>();
            stackItem.put("conversationIdMapStackKey", ConversationAdapter.getAdapter().getViewContext());
            actionContext.getValueStack().push(stackItem);
        }
        catch (ConversationException e) {
            LOG.error("Programmatic Conversation error in Prepare method", (Throwable)e, new String[0]);
        }
    }

    protected void beginConversations() {
        ProgrammaticModelDrivenConversationUtil.begin(this, this.scopeContainer.getProperty(Integer.TYPE, "conversation.max.instances").intValue());
    }

    protected void continueConversations() {
        ProgrammaticModelDrivenConversationUtil.persist(this);
    }

    protected void endConversations() {
        ProgrammaticModelDrivenConversationUtil.end(this);
    }
}

