/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.struts2;

import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.util.RedirectUtil;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConversationPrepareRedirectResult
implements Result {
    public void execute(ActionInvocation actionInvocation) throws Exception {
        ActionContext context = actionInvocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)context.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)context.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        String location = ConversationPrepareRedirectResult.createRedirectLocation(request);
        String locationWithConversationIds = RedirectUtil.getUrlParamString(location, ConversationAdapter.getAdapter().getViewContext());
        String finalLocation = response.encodeRedirectURL(locationWithConversationIds);
        response.sendRedirect(finalLocation);
    }

    private static String createRedirectLocation(HttpServletRequest request) {
        StringBuffer location = request.getRequestURL();
        Map paramMap = request.getParameterMap();
        if (paramMap.isEmpty()) {
            return location.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(location.toString());
        sb.append("?");
        Iterator iterator = paramMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            sb.append((String)entry.getKey()).append("=").append(((String[])entry.getValue())[0]);
            if (!iterator.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }
}

