/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.struts2;

import com.google.code.rees.scope.container.ScopeContainer;
import com.google.code.rees.scope.container.ScopeContainerProvider;
import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.conversation.context.ConversationContextManager;
import com.google.code.rees.scope.conversation.context.HttpConversationContextManagerProvider;
import com.google.code.rees.scope.conversation.exceptions.ConversationException;
import com.google.code.rees.scope.conversation.exceptions.ConversationIdException;
import com.google.code.rees.scope.conversation.processing.ConversationProcessor;
import com.google.code.rees.scope.struts2.ConversationErrorAware;
import com.google.code.rees.scope.struts2.StrutsConversationAdapter;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.Interceptor;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationInterceptor
implements Interceptor {
    private static final long serialVersionUID = -72776817859403642L;
    private static final Logger LOG = LoggerFactory.getLogger(ConversationInterceptor.class);
    public static final String CONVERSATION_ID_EXCEPTION_KEY = "struts.conversation.invalid.id";
    public static final String CONVERSATION_EXCEPTION_KEY = "struts.conversation.general.error";
    public static final String CONVERSATION_EXCEPTION_NAME_STACK_KEY = "conversation.name";
    public static final String CONVERSATION_EXCEPTION_ID_STACK_KEY = "conversation.id";
    protected static final String ID_PARAM_REGEX = ".*_conversation";
    protected static final Pattern ID_PARAM_PATTERN = Pattern.compile(".*_conversation");
    protected HttpConversationContextManagerProvider contextManagerProvider;
    protected ConversationProcessor processor;
    protected ScopeContainer scopeContainer;

    @Inject
    public void setScopeContainerProvider(ScopeContainerProvider scopeContainerProvider) {
        this.scopeContainer = scopeContainerProvider.getScopeContainer();
    }

    public void destroy() {
        LOG.info("Destroying the ConversationInterceptor...");
    }

    public void init() {
        LOG.info("Initializing the Conversation Interceptor...");
        this.contextManagerProvider = this.scopeContainer.getComponent(HttpConversationContextManagerProvider.class);
        this.processor = this.scopeContainer.getComponent(ConversationProcessor.class);
        LOG.info("...Conversation Interceptor successfully initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intercept(ActionInvocation invocation) throws Exception {
        try {
            ActionContext actionContext = invocation.getInvocationContext();
            HttpServletRequest request = (HttpServletRequest)actionContext.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
            ConversationContextManager contextManager = this.contextManagerProvider.getManager(request);
            final StrutsConversationAdapter adapter = new StrutsConversationAdapter(invocation, contextManager);
            this.processor.processConversations(adapter);
            invocation.addPreResultListener(new PreResultListener(){

                public void beforeResult(ActionInvocation invocation, String resultCode) {
                    adapter.executePostProcessors();
                    invocation.getStack().getContext().put("conversationIdMapStackKey", adapter.getViewContext());
                }
            });
            this.cleanupParamIds(actionContext.getParameters());
            String string = invocation.invoke();
            return string;
        }
        catch (ConversationIdException cie) {
            String string = this.handleIdException(invocation, cie);
            return string;
        }
        catch (ConversationException ce) {
            String string = this.handleUnexpectedException(invocation, ce);
            return string;
        }
        finally {
            ConversationAdapter.cleanup();
        }
    }

    protected void cleanupParamIds(Map<String, Object> parameters) {
        Iterator<Map.Entry<String, Object>> i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            if (!ID_PARAM_PATTERN.matcher(i.next().getKey()).matches()) continue;
            i.remove();
        }
    }

    protected String handleIdException(ActionInvocation invocation, ConversationIdException cie) {
        LOG.warn("ConversationIdException occurred in Conversation Processing, returning result of struts.conversation.invalid.id");
        Locale locale = invocation.getInvocationContext().getLocale();
        Map stackContext = invocation.getStack().getContext();
        stackContext.put(CONVERSATION_EXCEPTION_NAME_STACK_KEY, cie.getConversationName());
        stackContext.put(CONVERSATION_EXCEPTION_ID_STACK_KEY, cie.getConversationId());
        String conversationSpecificMessageKey = "struts.conversation.invalid.id." + cie.getConversationName();
        String errorMessage = LocalizedTextUtil.findText(this.getClass(), (String)conversationSpecificMessageKey, (Locale)locale);
        if (errorMessage == null || errorMessage.equals(conversationSpecificMessageKey)) {
            errorMessage = LocalizedTextUtil.findText(this.getClass(), (String)CONVERSATION_ID_EXCEPTION_KEY, (Locale)locale, (String)"The workflow that you are attempting to continue has ended or expired.  Your requested action was not processed.", (Object[])new Object[0]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Placing Conversation Error Message on stack (key={struts.conversation.invalid.id}):  " + errorMessage);
        }
        stackContext.put(CONVERSATION_ID_EXCEPTION_KEY, errorMessage);
        this.handleConversationErrorAware(invocation.getProxy(), errorMessage);
        return CONVERSATION_ID_EXCEPTION_KEY;
    }

    protected String handleUnexpectedException(ActionInvocation invocation, ConversationException ce) {
        LOG.error("An unexpected exception occurred in Conversation Processing, returning result of struts.conversation.general.error");
        Locale locale = invocation.getInvocationContext().getLocale();
        String errorMessage = LocalizedTextUtil.findText(this.getClass(), (String)CONVERSATION_EXCEPTION_KEY, (Locale)locale, (String)"An unexpected error occurred while processing you request.  Please try again.", (Object[])new Object[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Placing Conversation Error Message on stack (key={struts.conversation.general.error}):  " + errorMessage);
        }
        invocation.getStack().getContext().put(CONVERSATION_EXCEPTION_KEY, errorMessage);
        this.handleConversationErrorAware(invocation.getProxy(), errorMessage);
        return CONVERSATION_EXCEPTION_KEY;
    }

    protected void handleConversationErrorAware(ActionProxy proxy, String errorMessage) {
        Object action = proxy.getAction();
        if (action instanceof ConversationErrorAware) {
            LOG.debug("Action is an instance of ConversationErrorAware; setting conversation error.");
            ((ConversationErrorAware)action).setConversationError(errorMessage);
        }
    }
}

