/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.spring;

import com.google.code.rees.scope.conversation.configuration.DefaultConversationArbitrator;
import com.google.code.rees.scope.spring.ConversationController;
import com.google.code.rees.scope.util.NamingUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringConversationArbitrator
extends DefaultConversationArbitrator {
    private static final long serialVersionUID = -2131295964932528989L;

    @Override
    protected String[] getConversationsWithInheritance(Class<?> clazz, String actionSuffix) {
        ArrayList<String> conversations = new ArrayList<String>();
        for (Class<?> conversationControllerClass : this.getConversationControllers(clazz)) {
            String[] newConversations;
            Annotation controller;
            if (clazz.isAnnotationPresent(com.google.code.rees.scope.conversation.annotations.ConversationController.class)) {
                controller = conversationControllerClass.getAnnotation(com.google.code.rees.scope.conversation.annotations.ConversationController.class);
                newConversations = controller.conversations();
                if (controller.value().equals("DEFAULT_VALUE")) {
                    if (newConversations.length == 0) {
                        newConversations = new String[]{NamingUtil.getConventionName(conversationControllerClass, actionSuffix)};
                    }
                } else {
                    conversations.add(controller.value());
                }
                conversations.addAll(Arrays.asList(newConversations));
                continue;
            }
            controller = conversationControllerClass.getAnnotation(ConversationController.class);
            newConversations = controller.conversations();
            if (controller.value().equals("")) {
                if (newConversations.length == 0) {
                    newConversations = new String[]{NamingUtil.getConventionName(conversationControllerClass, actionSuffix)};
                }
            } else {
                conversations.add(controller.value());
            }
            conversations.addAll(Arrays.asList(newConversations));
        }
        return conversations.toArray(new String[0]);
    }

    @Override
    protected Set<Class<?>> getConversationControllers(Class<?> clazz) {
        Class<?> superClass;
        HashSet annotatedClasses = new HashSet();
        for (Class<?> clazzClass : clazz.getInterfaces()) {
            if (!clazzClass.isAnnotationPresent(com.google.code.rees.scope.conversation.annotations.ConversationController.class) && !clazzClass.isAnnotationPresent(ConversationController.class)) continue;
            annotatedClasses.add(clazzClass);
        }
        if (clazz.isAnnotationPresent(com.google.code.rees.scope.conversation.annotations.ConversationController.class) || clazz.isAnnotationPresent(ConversationController.class)) {
            annotatedClasses.add(clazz);
        }
        if ((superClass = clazz.getSuperclass()) != null) {
            annotatedClasses.addAll(this.getConversationControllers(superClass));
        }
        return annotatedClasses;
    }

    @Override
    protected boolean isAction(Method method) {
        return method.isAnnotationPresent(RequestMapping.class);
    }
}

