/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.session;

import com.google.code.rees.scope.ActionProvider;
import com.google.code.rees.scope.container.Component;
import com.google.code.rees.scope.session.SessionConfiguration;
import com.google.code.rees.scope.session.SessionConfigurationProvider;
import com.google.code.rees.scope.session.SessionField;
import com.google.code.rees.scope.session.SessionUtil;
import com.google.code.rees.scope.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSessionConfigurationProvider
implements SessionConfigurationProvider {
    private static final long serialVersionUID = 3703684121698557461L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSessionConfigurationProvider.class);
    protected transient SessionConfiguration configuration = new SessionConfiguration();
    protected Set<Class<?>> classesProcessed = new HashSet();
    protected ActionProvider actionProvider;

    @Override
    @Component
    public void setActionProvider(ActionProvider actionProvider) {
        this.actionProvider = actionProvider;
    }

    @Override
    public void init() {
        try {
            this.processClasses(this.actionProvider.getActionClasses());
        }
        catch (Exception e) {
            LOG.warn("The was an error attempting to retrieve the action classes.  This could be due to an older version of Struts2. Configurations will be built on the fly");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionConfiguration getSessionConfiguration(Class<?> clazz) {
        if (this.configuration == null) {
            Set<Class<?>> set = this.classesProcessed;
            synchronized (set) {
                this.initConfig();
            }
        }
        if (!this.classesProcessed.contains(clazz)) {
            this.processClass(clazz);
        }
        return this.configuration;
    }

    protected synchronized void initConfig() {
        if (this.configuration == null) {
            this.configuration = new SessionConfiguration();
            this.processClasses(this.classesProcessed);
        }
    }

    protected void processClasses(Set<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            this.processClass(clazz);
        }
    }

    protected synchronized void processClass(Class<?> clazz) {
        if (!(this.classesProcessed.contains(clazz) || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || clazz.isAnnotation())) {
            LOG.info("Loading @SessionField fields from " + clazz.getName());
            this.addFields(clazz);
            this.classesProcessed.add(clazz);
        }
    }

    protected void addFields(Class<?> clazz) {
        for (Field field : ReflectionUtil.getFields(clazz)) {
            if (!field.isAnnotationPresent(SessionField.class)) continue;
            LOG.debug("Adding @SessionField " + field.getName() + " from class " + clazz.getName() + " to the SessionConfiguration");
            SessionField sessionField = field.getAnnotation(SessionField.class);
            String name = sessionField.name();
            if (name.equals("default")) {
                name = field.getName();
            }
            String key = SessionUtil.buildKey(name, field.getType());
            ReflectionUtil.makeAccessible(field);
            this.configuration.addField(clazz, key, field);
        }
    }
}

