/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.conversation.processing;

import com.google.code.rees.scope.container.Component;
import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.conversation.ConversationUtil;
import com.google.code.rees.scope.conversation.configuration.ConversationClassConfiguration;
import com.google.code.rees.scope.conversation.configuration.ConversationConfigurationProvider;
import com.google.code.rees.scope.conversation.exceptions.ConversationException;
import com.google.code.rees.scope.conversation.exceptions.ConversationIdException;
import com.google.code.rees.scope.conversation.processing.ConversationEndProcessor;
import com.google.code.rees.scope.conversation.processing.ConversationProcessor;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleConversationProcessor
implements ConversationProcessor {
    private static final long serialVersionUID = -518452439785782433L;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleConversationProcessor.class);
    protected ConversationConfigurationProvider configurationProvider;

    @Override
    @Component
    public void setConfigurationProvider(ConversationConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    @Override
    public void processConversations(ConversationAdapter conversationAdapter) throws ConversationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Beginning processing of conversations...");
            LOG.debug("Conversation Request Context:  " + conversationAdapter.getRequestContext());
        }
        try {
            Object action = conversationAdapter.getAction();
            Collection<ConversationClassConfiguration> actionConversationConfigs = this.configurationProvider.getConfigurations(action.getClass());
            if (actionConversationConfigs != null) {
                for (ConversationClassConfiguration conversationConfig : actionConversationConfigs) {
                    this.processConversation(conversationConfig, conversationAdapter, action);
                }
            }
        }
        catch (ConversationException ce) {
            throw ce;
        }
        catch (Exception e) {
            LOG.error("An exception occurred while processing the conversations:  " + e.getMessage());
            throw new ConversationException(e.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("...processing of conversations complete.");
        }
    }

    protected void processConversation(ConversationClassConfiguration conversationConfig, ConversationAdapter conversationAdapter, Object action) throws ConversationException {
        String actionId = conversationAdapter.getActionId();
        String conversationName = conversationConfig.getConversationName();
        String conversationId = conversationAdapter.getRequestContext().get(conversationName);
        if (conversationId != null) {
            if (conversationConfig.containsAction(actionId)) {
                if (conversationConfig.isEndAction(actionId)) {
                    conversationAdapter.addPostProcessor(new ConversationEndProcessor(), conversationConfig, conversationId);
                } else {
                    conversationAdapter.getViewContext().put(conversationName, conversationId);
                }
            } else {
                this.handleInvalidId(conversationName, conversationId);
            }
        } else if (conversationConfig.isBeginAction(actionId)) {
            long maxIdleTime = conversationConfig.getMaxIdleTime(actionId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Beginning new " + conversationName + " with max idle time of " + maxIdleTime / 1000L + " seconds for action " + actionId);
            }
            ConversationUtil.begin(conversationName, conversationAdapter, maxIdleTime);
        }
    }

    protected void handleInvalidId(String conversationName, String conversationId) throws ConversationIdException {
        String idExceptionMessage = "The following conversation name and id pair did not return an active ConversationContext:  (name: " + conversationName + "|id:  " + conversationId + ").  This is likely due to the conversation having ended or expired.";
        LOG.warn(idExceptionMessage);
        throw new ConversationIdException(idExceptionMessage, conversationName, conversationId);
    }
}

