/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.conversation.processing;

import com.google.code.rees.scope.conversation.ConversationAdapter;
import com.google.code.rees.scope.conversation.ConversationUtil;
import com.google.code.rees.scope.conversation.configuration.ConversationClassConfiguration;
import com.google.code.rees.scope.conversation.context.ConversationContext;
import com.google.code.rees.scope.conversation.exceptions.ConversationException;
import com.google.code.rees.scope.conversation.processing.ConversationEndProcessor;
import com.google.code.rees.scope.conversation.processing.ConversationPostProcessor;
import com.google.code.rees.scope.conversation.processing.InjectionConversationProcessor;
import com.google.code.rees.scope.conversation.processing.SimpleConversationProcessor;
import com.google.code.rees.scope.util.InjectionUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInjectionConversationProcessor
extends SimpleConversationProcessor
implements InjectionConversationProcessor,
ConversationPostProcessor {
    private static final long serialVersionUID = 8632020943340087L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultInjectionConversationProcessor.class);

    @Override
    protected void processConversation(ConversationClassConfiguration conversationConfig, ConversationAdapter conversationAdapter, Object action) throws ConversationException {
        String actionId = conversationAdapter.getActionId();
        String conversationName = conversationConfig.getConversationName();
        String conversationId = conversationAdapter.getRequestContext().get(conversationName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing request for " + conversationName + " and action " + actionId + " of class " + action.getClass());
        }
        if (conversationId != null) {
            if (conversationConfig.containsAction(actionId)) {
                ConversationContext conversationContext = conversationAdapter.getConversationContext(conversationName, conversationId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The action is a conversation member.  Processing with context:  " + conversationContext);
                }
                if (conversationContext != null) {
                    Map<String, Field> actionConversationFields = conversationConfig.getFields();
                    if (actionConversationFields != null) {
                        InjectionUtil.setFieldValues(action, actionConversationFields, conversationContext);
                    }
                } else {
                    this.handleInvalidId(conversationName, conversationId);
                }
                if (conversationConfig.isEndAction(actionId)) {
                    conversationAdapter.addPostProcessor(new ConversationEndProcessor(), conversationConfig, conversationId);
                } else {
                    conversationAdapter.addPostProcessor(this, conversationConfig, conversationId);
                    conversationAdapter.getViewContext().put(conversationName, conversationId);
                }
            }
        } else if (conversationConfig.isBeginAction(actionId)) {
            long maxIdleTime = conversationConfig.getMaxIdleTime(actionId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Beginning new " + conversationName + " with max idle time of " + maxIdleTime / 1000L + " seconds for action " + actionId);
            }
            ConversationContext newConversationContext = ConversationUtil.begin(conversationName, conversationAdapter, maxIdleTime);
            conversationId = newConversationContext.getId();
            conversationAdapter.addPostProcessor(this, conversationConfig, conversationId);
        }
    }

    @Override
    public void postProcessConversation(ConversationAdapter conversationAdapter, ConversationClassConfiguration conversationConfig, String conversationId) {
        String conversationName = conversationConfig.getConversationName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Performing post-processing of  " + conversationName + " with ID of " + conversationId + "...");
        }
        Object action = conversationAdapter.getAction();
        Map<String, Field> actionConversationFields = conversationConfig.getFields();
        if (actionConversationFields != null) {
            ConversationContext conversationContext;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting conversation fields for " + conversationName + " following execution of action " + conversationAdapter.getActionId());
            }
            if ((conversationContext = conversationAdapter.getConversationContext(conversationName, conversationId)) != null) {
                conversationContext.putAll(InjectionUtil.getFieldValues(action, actionConversationFields));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("...completed post-processing of  " + conversationName + " with ID of " + conversationId + ".");
        }
    }

    @Override
    public void injectConversationFields(Object target, ConversationAdapter conversationAdapter) {
        Collection<ConversationClassConfiguration> actionConversationConfigs = this.configurationProvider.getConfigurations(target.getClass());
        if (actionConversationConfigs != null) {
            for (ConversationClassConfiguration conversation : actionConversationConfigs) {
                Map<String, Field> actionConversationFields;
                ConversationContext conversationContext;
                String conversationName = conversation.getConversationName();
                String conversationId = conversationAdapter.getRequestContext().get(conversationName);
                if (conversationId == null || (conversationContext = conversationAdapter.getConversationContext(conversationName, conversationId)) == null || (actionConversationFields = conversation.getFields()) == null) continue;
                InjectionUtil.setFieldValues(target, actionConversationFields, conversationContext);
            }
        }
    }

    @Override
    public void extractConversationFields(Object target, ConversationAdapter conversationAdapter) {
        Collection<ConversationClassConfiguration> actionConversationConfigs = this.configurationProvider.getConfigurations(target.getClass());
        if (actionConversationConfigs != null) {
            for (ConversationClassConfiguration conversation : actionConversationConfigs) {
                Map<String, Field> actionConversationFields = conversation.getFields();
                String conversationName = conversation.getConversationName();
                String conversationId = conversationAdapter.getRequestContext().get(conversationName);
                if (conversationId == null) continue;
                if (actionConversationFields != null) {
                    ConversationContext conversationContext = conversationAdapter.getConversationContext(conversationName, conversationId);
                    conversationContext.putAll(InjectionUtil.getFieldValues(target, actionConversationFields));
                }
                conversationAdapter.getViewContext().put(conversationName, conversationId);
            }
        }
    }
}

