/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.conversation.configuration;

import com.google.code.rees.scope.ActionProvider;
import com.google.code.rees.scope.container.Component;
import com.google.code.rees.scope.container.Property;
import com.google.code.rees.scope.conversation.annotations.BeginConversation;
import com.google.code.rees.scope.conversation.configuration.ConversationArbitrator;
import com.google.code.rees.scope.conversation.configuration.ConversationClassConfiguration;
import com.google.code.rees.scope.conversation.configuration.ConversationConfigurationProvider;
import com.google.code.rees.scope.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConversationConfigurationProvider
implements ConversationConfigurationProvider {
    private static final long serialVersionUID = -1227350994518195549L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConversationConfigurationProvider.class);
    protected ConversationArbitrator arbitrator;
    protected ActionProvider actionProvider;
    protected ConcurrentMap<Class<?>, Collection<ConversationClassConfiguration>> classConfigurations = new ConcurrentHashMap();
    protected long maxIdleTimeMillis = 28800000L;

    @Override
    @Property(value="conversation.idle.timeout")
    public void setDefaultMaxIdleTime(long maxIdleTimeMillis) {
        double idleTimeHours = (double)maxIdleTimeMillis / 3600000.0;
        LOG.info("Setting default conversation timeout:  " + maxIdleTimeMillis + " milliseconds.");
        LOG.info("Converted default conversation timeout:  " + String.format("%.2f", idleTimeHours) + " hours.");
        this.maxIdleTimeMillis = maxIdleTimeMillis;
    }

    @Override
    @Component
    public void setArbitrator(ConversationArbitrator arbitrator) {
        this.arbitrator = arbitrator;
    }

    @Override
    @Component
    public void setActionProvider(ActionProvider actionProvider) {
        this.actionProvider = actionProvider;
    }

    @Override
    public void init() {
        try {
            if (this.classConfigurations.size() != this.actionProvider.getActionClasses().size()) {
                LOG.info("Building Conversation Configurations...");
                if (this.arbitrator == null) {
                    LOG.error("No ConversationArbitrator set for the ConversationConfigurationProvider, review configuration files to make sure an arbitrator is declared.");
                }
                for (Class<?> clazz : this.actionProvider.getActionClasses()) {
                    this.processClass(clazz, this.classConfigurations);
                }
                LOG.info("...building of Conversation Configurations successfully completed.");
            }
        }
        catch (Exception e) {
            LOG.warn("The was an error attempting to retrieve the action classes.  This could be due to an older version of Struts2. Configurations will be built on the fly");
        }
    }

    @Override
    public Collection<ConversationClassConfiguration> getConfigurations(Class<?> clazz) {
        Collection<ConversationClassConfiguration> configurations = (Collection<ConversationClassConfiguration>)this.classConfigurations.get(clazz);
        if (configurations == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No cached ConversationClassConfiguration found for class " + clazz.getName());
            }
            configurations = this.processClass(clazz, this.classConfigurations);
        }
        return configurations;
    }

    protected Collection<ConversationClassConfiguration> processClass(Class<?> clazz, ConcurrentMap<Class<?>, Collection<ConversationClassConfiguration>> classConfigurations) {
        HashSet configurations = (HashSet)classConfigurations.get(clazz);
        if (configurations == null) {
            ConversationClassConfiguration configuration;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Building ConversationClassConfigurationImpl for class " + clazz.getName());
            }
            configurations = new HashSet();
            HashMap<String, ConversationClassConfiguration> temporaryConversationMap = new HashMap<String, ConversationClassConfiguration>();
            for (Field field : this.arbitrator.getCandidateConversationFields(clazz)) {
                Collection<String> fieldConversations = this.arbitrator.getConversations(clazz, field);
                if (fieldConversations == null) continue;
                String fieldName = this.arbitrator.getName(field);
                ReflectionUtil.makeAccessible(field);
                for (String conversation : fieldConversations) {
                    configuration = (ConversationClassConfiguration)temporaryConversationMap.get(conversation);
                    if (configuration == null) {
                        configuration = new ConversationClassConfiguration(conversation);
                        temporaryConversationMap.put(conversation, configuration);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding field " + fieldName + " to ConversationClassConfigurationImpl for Conversation " + conversation);
                    }
                    configuration.addField(fieldName, field);
                }
            }
            for (Method method : this.arbitrator.getCandidateConversationMethods(clazz)) {
                Collection<String> methodEndConversations;
                Collection<String> methodBeginConversations;
                Collection<String> methodConversations = this.arbitrator.getConversations(clazz, method);
                if (methodConversations != null) {
                    String methodName = this.arbitrator.getName(method);
                    for (String conversation : methodConversations) {
                        configuration = (ConversationClassConfiguration)temporaryConversationMap.get(conversation);
                        if (configuration == null) {
                            configuration = new ConversationClassConfiguration(conversation);
                            temporaryConversationMap.put(conversation, configuration);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Adding method " + methodName + " as an Action to ConversationClassConfigurationImpl for Conversation " + conversation);
                        }
                        configuration.addAction(methodName);
                    }
                }
                if ((methodBeginConversations = this.arbitrator.getBeginConversations(clazz, method)) != null) {
                    String methodName = this.arbitrator.getName(method);
                    for (String conversation : methodBeginConversations) {
                        BeginConversation beginConversation;
                        ConversationClassConfiguration configuration2 = (ConversationClassConfiguration)temporaryConversationMap.get(conversation);
                        if (configuration2 == null) {
                            configuration2 = new ConversationClassConfiguration(conversation);
                            temporaryConversationMap.put(conversation, configuration2);
                        }
                        long maxIdleTime = this.maxIdleTimeMillis;
                        if (method.isAnnotationPresent(BeginConversation.class) && (beginConversation = method.getAnnotation(BeginConversation.class)).maxIdleTimeMillis() != -1L) {
                            maxIdleTime = beginConversation.maxIdleTimeMillis();
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Adding method " + methodName + " as a Begin Action to ConversationClassConfigurationImpl for Conversation " + conversation + " with a timeout of " + maxIdleTime / 1000L + " seconds.");
                        }
                        configuration2.addBeginAction(methodName, maxIdleTime);
                    }
                }
                if ((methodEndConversations = this.arbitrator.getEndConversations(clazz, method)) == null) continue;
                String methodName = this.arbitrator.getName(method);
                for (String conversation : methodEndConversations) {
                    ConversationClassConfiguration configuration3 = (ConversationClassConfiguration)temporaryConversationMap.get(conversation);
                    if (configuration3 == null) {
                        configuration3 = new ConversationClassConfiguration(conversation);
                        temporaryConversationMap.put(conversation, configuration3);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding method " + methodName + " as an End Action to ConversationClassConfigurationImpl for Conversation " + conversation);
                    }
                    configuration3.addEndAction(methodName);
                }
            }
            configurations.addAll(temporaryConversationMap.values());
            classConfigurations.putIfAbsent(clazz, configurations);
        }
        return configurations;
    }
}

