/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.rees.scope.container;

import com.google.code.rees.scope.container.Component;
import com.google.code.rees.scope.container.PostConstructable;
import com.google.code.rees.scope.container.Property;
import com.google.code.rees.scope.container.ScopeContainer;
import com.google.code.rees.scope.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScopeContainer
implements ScopeContainer {
    private static final long serialVersionUID = -6820777796732236492L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractScopeContainer.class);
    private Map<Class<?>, Object> components = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getComponent(Class<T> clazz) {
        Object component = this.components.get(clazz);
        if (component == null) {
            component = this.getComponentFromPrimaryContainer(clazz);
            Map<Class<?>, Object> map = this.components;
            synchronized (map) {
                if (this.components.get(clazz) == null) {
                    this.inject(component);
                    if (component instanceof PostConstructable) {
                        ((PostConstructable)component).init();
                    }
                    this.components.put(clazz, component);
                }
            }
        }
        return (T)component;
    }

    @Override
    public <T> T getProperty(Class<T> clazz, String name) {
        return this.getPropertyFromPrimaryContainer(clazz, name);
    }

    protected void inject(Object component) {
        LOG.debug("Injecting dependencies into component of type [{}]", (Object)component.getClass().getName());
        for (Method method : component.getClass().getMethods()) {
            if (!ReflectionUtil.isPublicSetter(method)) continue;
            Class<?> type = method.getParameterTypes()[0];
            try {
                if (ReflectionUtil.isPropertyType(type) && method.isAnnotationPresent(Property.class)) {
                    Property property = method.getAnnotation(Property.class);
                    Object value = this.getPropertyFromPrimaryContainer(type, property.value());
                    LOG.info("Setting property [{}] on component of type [{}] with value [{}]", new Object[]{property.value(), component.getClass().getName(), value});
                    method.invoke(component, value);
                    continue;
                }
                if (!method.isAnnotationPresent(Component.class)) continue;
                method.invoke(component, this.getComponent(type));
            }
            catch (Exception e) {
                if (type.getName().startsWith("com.github.overengineer")) {
                    LOG.warn("Could not set component of type [{}] on component of type [{}] using setter [{}]", new Object[]{type.getName(), component.getClass(), method.getName(), e});
                    continue;
                }
                LOG.debug("Could not set component of type [{}] on component of type [{}] using setter [{}]", new Object[]{type.getName(), component.getClass(), method.getName()});
            }
        }
    }

    protected abstract <T> T getPropertyFromPrimaryContainer(Class<T> var1, String var2);

    protected abstract <T> T getComponentFromPrimaryContainer(Class<T> var1);
}

