/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.TargetDataLine;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioUtils;

public class AudioInputStream
extends InputStream {
    private static final boolean CHECK_LENGTHS = true;
    protected InputStream stream;
    protected AudioFormat format;
    protected long frameLength;
    protected int frameSize;
    private int m_nCheckFrameSize;
    protected long framePos;
    private long m_lPosition;
    private long m_lLengthInBytes;
    private long m_lMarkedPosition;

    public AudioInputStream(InputStream inputStream, AudioFormat audioFormat, long lLengthInFrames) {
        if (TDebug.TraceAudioInputStream) {
            TDebug.out("AudioInputStream.<init>: inputStream: " + inputStream);
        }
        this.stream = inputStream;
        this.format = audioFormat;
        this.frameLength = lLengthInFrames;
        this.m_nCheckFrameSize = this.frameSize = audioFormat.getFrameSize();
        if (this.m_nCheckFrameSize < 1) {
            this.m_nCheckFrameSize = 1;
        }
        this.m_lLengthInBytes = AudioUtils.getLengthInBytes(audioFormat, lLengthInFrames);
        this.m_lPosition = 0L;
        this.updateFramePosition();
    }

    public AudioInputStream(TargetDataLine targetDataLine) {
        this(new TargetDataLineInputStream(targetDataLine), targetDataLine.getFormat(), -1L);
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    public int read() throws IOException {
        if (this.getCheckFrameSize() != 1) {
            throw new IOException("frame size must be 1 to read a single byte");
        }
        if (this.isEndReached()) {
            return -1;
        }
        int nByte = this.stream.read();
        if (nByte != -1) {
            ++this.m_lPosition;
            this.updateFramePosition();
        }
        return nByte;
    }

    public int read(byte[] abData) throws IOException {
        return this.read(abData, 0, abData.length);
    }

    public int read(byte[] abData, int nOffset, int nLength) throws IOException {
        int thisRead;
        if (this.isEndReached()) {
            return -1;
        }
        if (nLength % this.getCheckFrameSize() != 0) {
            throw new IOException("length must be a multiple of the frame size (length=" + nLength + ", frameSize=" + this.getCheckFrameSize() + ")");
        }
        if (this.m_lLengthInBytes != -1L) {
            nLength = (int)Math.min((long)nLength, this.m_lLengthInBytes - this.m_lPosition);
        }
        int nBytesRead = 0;
        do {
            if ((thisRead = this.stream.read(abData, nOffset, nLength)) <= 0) continue;
            nBytesRead += thisRead;
            nLength -= thisRead;
            nOffset += thisRead;
        } while (thisRead > 0 && nLength > 0);
        if (nBytesRead <= 0 && thisRead == -1) {
            nBytesRead = -1;
        } else {
            this.m_lPosition += (long)nBytesRead;
            this.updateFramePosition();
        }
        return nBytesRead;
    }

    public long skip(long nSkip) throws IOException {
        if (nSkip % (long)this.getCheckFrameSize() != 0L) {
            throw new IOException("skip must be a multiple of the frame size");
        }
        if (this.m_lLengthInBytes != -1L) {
            nSkip = (int)Math.min(nSkip, this.m_lLengthInBytes - this.m_lPosition);
        }
        long nSkipped = this.stream.skip(nSkip);
        this.m_lPosition += nSkipped;
        this.updateFramePosition();
        return nSkipped;
    }

    public int available() throws IOException {
        if (this.m_lLengthInBytes == -1L) {
            return this.stream.available();
        }
        return (int)Math.min((long)this.stream.available(), this.m_lLengthInBytes - this.m_lPosition);
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public void mark(int readlimit) {
        this.stream.mark(readlimit);
        this.m_lMarkedPosition = this.m_lPosition;
    }

    public void reset() throws IOException {
        this.stream.reset();
        this.m_lPosition = this.m_lMarkedPosition;
        this.updateFramePosition();
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }

    private int getCheckFrameSize() {
        return this.m_nCheckFrameSize;
    }

    private boolean isEndReached() {
        return this.m_lPosition >= this.m_lLengthInBytes && this.m_lLengthInBytes != -1L;
    }

    private void updateFramePosition() {
        this.framePos = this.m_lPosition / (long)this.getCheckFrameSize();
    }

    private static class TargetDataLineInputStream
    extends InputStream {
        private TargetDataLine m_targetDataLine;
        private byte[] m_abSingleByteBuffer = null;

        public TargetDataLineInputStream(TargetDataLine targetDataLine) {
            this.m_targetDataLine = targetDataLine;
        }

        public int read() {
            int nReturn;
            if (this.m_abSingleByteBuffer == null) {
                this.m_abSingleByteBuffer = new byte[1];
            }
            if ((nReturn = this.read(this.m_abSingleByteBuffer, 0, 1)) < 0) {
                return -1;
            }
            return this.m_abSingleByteBuffer[0];
        }

        public int read(byte[] abData, int nOffset, int nLength) {
            return this.m_targetDataLine.read(abData, nOffset, nLength);
        }
    }
}

