/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import org.tritonus.core.TMidiConfig;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;

public class MidiSystem {
    private static final MidiDevice.Info[] EMPTY_MIDIDEVICE_INFO_ARRAY = new MidiDevice.Info[0];

    public static MidiDevice.Info[] getMidiDeviceInfo() {
        ArrayList<MidiDevice.Info> deviceInfos = new ArrayList<MidiDevice.Info>();
        Iterator<MidiDeviceProvider> providers = TMidiConfig.getMidiDeviceProviders();
        while (providers.hasNext()) {
            MidiDeviceProvider provider = providers.next();
            MidiDevice.Info[] infos = provider.getDeviceInfo();
            deviceInfos.addAll(Arrays.asList(infos));
        }
        return deviceInfos.toArray(EMPTY_MIDIDEVICE_INFO_ARRAY);
    }

    public static MidiDevice getMidiDevice(MidiDevice.Info info) throws MidiUnavailableException {
        Iterator<MidiDeviceProvider> providers = TMidiConfig.getMidiDeviceProviders();
        while (providers.hasNext()) {
            MidiDeviceProvider provider = providers.next();
            if (!provider.isDeviceSupported(info)) continue;
            return provider.getDevice(info);
        }
        throw new IllegalArgumentException("no device found for " + info);
    }

    public static Receiver getReceiver() throws MidiUnavailableException {
        MidiDevice.Info info = TMidiConfig.getDefaultMidiOutDeviceInfo();
        MidiDevice device = MidiSystem.getMidiDevice(info);
        if (!device.isOpen()) {
            device.open();
        }
        Receiver receiver = device.getReceiver();
        return receiver;
    }

    public static Transmitter getTransmitter() throws MidiUnavailableException {
        MidiDevice.Info info = TMidiConfig.getDefaultMidiInDeviceInfo();
        MidiDevice device = MidiSystem.getMidiDevice(info);
        if (!device.isOpen()) {
            device.open();
        }
        Transmitter transmitter = device.getTransmitter();
        return transmitter;
    }

    public static Synthesizer getSynthesizer() throws MidiUnavailableException {
        MidiDevice.Info info = TMidiConfig.getDefaultSynthesizerInfo();
        if (TDebug.TraceMidiSystem) {
            TDebug.out("MidiSystem.getSynthesizer(): using default synthesizer info: " + info);
        }
        Synthesizer synthesizer = (Synthesizer)MidiSystem.getMidiDevice(info);
        return synthesizer;
    }

    public static Sequencer getSequencer() throws MidiUnavailableException {
        return MidiSystem.getSequencer(true);
    }

    public static Sequencer getSequencer(boolean bConnected) throws MidiUnavailableException {
        MidiDevice.Info info = TMidiConfig.getDefaultSequencerInfo();
        if (TDebug.TraceMidiSystem) {
            TDebug.out("MidiSystem.getSequencer(): using: " + info);
        }
        Sequencer sequencer = (Sequencer)MidiSystem.getMidiDevice(info);
        if (bConnected) {
            Synthesizer synth = MidiSystem.getSynthesizer();
            synth.open();
            sequencer.getTransmitter().setReceiver(synth.getReceiver());
        }
        return sequencer;
    }

    public static Soundbank getSoundbank(InputStream inputStream) throws InvalidMidiDataException, IOException {
        return null;
    }

    public static Soundbank getSoundbank(URL url) throws InvalidMidiDataException, IOException {
        return null;
    }

    public static Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        return null;
    }

    public static MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        Iterator<MidiFileReader> readers = TMidiConfig.getMidiFileReaders();
        while (readers.hasNext()) {
            MidiFileReader reader = readers.next();
            try {
                return reader.getMidiFileFormat(inputStream);
            }
            catch (IllegalArgumentException e) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(e);
            }
        }
        throw new InvalidMidiDataException();
    }

    public static MidiFileFormat getMidiFileFormat(URL url) throws InvalidMidiDataException, IOException {
        Iterator<MidiFileReader> readers = TMidiConfig.getMidiFileReaders();
        while (readers.hasNext()) {
            MidiFileReader reader = readers.next();
            try {
                return reader.getMidiFileFormat(url);
            }
            catch (IllegalArgumentException e) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(e);
            }
        }
        throw new InvalidMidiDataException();
    }

    public static MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        Iterator<MidiFileReader> readers = TMidiConfig.getMidiFileReaders();
        while (readers.hasNext()) {
            MidiFileReader reader = readers.next();
            try {
                return reader.getMidiFileFormat(file);
            }
            catch (IllegalArgumentException e) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(e);
            }
        }
        throw new InvalidMidiDataException();
    }

    public static Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        Iterator<MidiFileReader> readers = TMidiConfig.getMidiFileReaders();
        while (readers.hasNext()) {
            MidiFileReader reader = readers.next();
            try {
                return reader.getSequence(inputStream);
            }
            catch (IllegalArgumentException e) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(e);
            }
        }
        throw new InvalidMidiDataException();
    }

    public static Sequence getSequence(URL url) throws InvalidMidiDataException, IOException {
        Iterator<MidiFileReader> readers = TMidiConfig.getMidiFileReaders();
        while (readers.hasNext()) {
            MidiFileReader reader = readers.next();
            try {
                return reader.getSequence(url);
            }
            catch (IllegalArgumentException e) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(e);
            }
        }
        throw new InvalidMidiDataException();
    }

    public static Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        Iterator<MidiFileReader> readers = TMidiConfig.getMidiFileReaders();
        if (TDebug.TraceMidiSystem) {
            TDebug.out("MidiSystem.getSequence(File): got readers: " + readers);
        }
        while (readers.hasNext()) {
            MidiFileReader reader = readers.next();
            if (TDebug.TraceMidiSystem) {
                TDebug.out("MidiSystem.getSequence(File): Trying MidiFileReader " + reader);
            }
            try {
                return reader.getSequence(file);
            }
            catch (IllegalArgumentException e) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(e);
            }
        }
        if (TDebug.TraceMidiSystem) {
            TDebug.out("MidiSystem.getSequence(File): no appropriate MidiFileReader found, throwing exception");
        }
        throw new InvalidMidiDataException();
    }

    public static int[] getMidiFileTypes() {
        ArraySet<Integer> fileTypes = new ArraySet<Integer>();
        Iterator<MidiFileWriter> writers = TMidiConfig.getMidiFileWriters();
        while (writers.hasNext()) {
            MidiFileWriter writer = writers.next();
            int[] anTypes = writer.getMidiFileTypes();
            for (int i = 0; i < anTypes.length; ++i) {
                fileTypes.add(anTypes[i]);
            }
        }
        int[] anTypes = new int[fileTypes.size()];
        Iterator types = fileTypes.iterator();
        int nIndex = 0;
        while (types.hasNext()) {
            Integer type = (Integer)types.next();
            anTypes[nIndex] = type;
            ++nIndex;
        }
        return anTypes;
    }

    public static boolean isFileTypeSupported(int nFileType) {
        Iterator<MidiFileWriter> writers = TMidiConfig.getMidiFileWriters();
        while (writers.hasNext()) {
            MidiFileWriter writer = writers.next();
            boolean bIsSupported = writer.isFileTypeSupported(nFileType);
            if (!bIsSupported) continue;
            return true;
        }
        return false;
    }

    public static int[] getMidiFileTypes(Sequence sequence) {
        ArraySet<Integer> fileTypes = new ArraySet<Integer>();
        Iterator<MidiFileWriter> writers = TMidiConfig.getMidiFileWriters();
        while (writers.hasNext()) {
            MidiFileWriter writer = writers.next();
            int[] anTypes = writer.getMidiFileTypes(sequence);
            for (int i = 0; i < anTypes.length; ++i) {
                fileTypes.add(anTypes[i]);
            }
        }
        int[] anTypes = new int[fileTypes.size()];
        Iterator types = fileTypes.iterator();
        int nIndex = 0;
        while (types.hasNext()) {
            Integer type = (Integer)types.next();
            anTypes[nIndex] = type;
            ++nIndex;
        }
        return anTypes;
    }

    public static boolean isFileTypeSupported(int nFileType, Sequence sequence) {
        Iterator<MidiFileWriter> writers = TMidiConfig.getMidiFileWriters();
        while (writers.hasNext()) {
            MidiFileWriter writer = writers.next();
            boolean bIsSupported = writer.isFileTypeSupported(nFileType, sequence);
            if (!bIsSupported) continue;
            return true;
        }
        return false;
    }

    public static int write(Sequence sequence, int fileType, OutputStream outputStream) throws IOException {
        return MidiSystem.writeImpl(sequence, fileType, outputStream);
    }

    public static int write(Sequence sequence, int fileType, File file) throws IOException {
        return MidiSystem.writeImpl(sequence, fileType, file);
    }

    private static int writeImpl(Sequence sequence, int fileType, Object destination) throws IOException {
        WriteMidiFileWriterAction action = new WriteMidiFileWriterAction(sequence, fileType, destination);
        MidiSystem.doMidiFileWriterIteration(action);
        int nWritten = action.getWritten();
        if (nWritten == -1) {
            throw new IllegalArgumentException("format not  supported");
        }
        return nWritten;
    }

    private static void doMidiFileReaderIteration(MidiFileReaderAction action) throws IOException {
        Iterator<MidiFileReader> audioFileReaders = TMidiConfig.getMidiFileReaders();
        boolean bCompleted = false;
        while (audioFileReaders.hasNext() && !bCompleted) {
            MidiFileReader audioFileReader = audioFileReaders.next();
            if (TDebug.TraceMidiSystem) {
                TDebug.out("MidiSystem.doMidiFileReaderIteration(): handling MidiFileReader: " + audioFileReader);
            }
            bCompleted = action.handleMidiFileReader(audioFileReader);
        }
    }

    private static void doMidiFileWriterIteration(MidiFileWriterAction action) throws IOException {
        Iterator<MidiFileWriter> audioFileWriters = TMidiConfig.getMidiFileWriters();
        boolean bCompleted = false;
        while (audioFileWriters.hasNext() && !bCompleted) {
            MidiFileWriter audioFileWriter = audioFileWriters.next();
            if (TDebug.TraceMidiSystem) {
                TDebug.out("MidiSystem.doMidiFileWriterIteration(): handling MidiFileWriter: " + audioFileWriter);
            }
            bCompleted = action.handleMidiFileWriter(audioFileWriter);
        }
    }

    private static interface MidiFileWriterAction {
        public boolean handleMidiFileWriter(MidiFileWriter var1) throws IOException;
    }

    private static interface MidiFileReaderAction {
        public boolean handleMidiFileReader(MidiFileReader var1) throws IOException;
    }

    private static class WriteMidiFileWriterAction
    implements MidiFileWriterAction {
        private Sequence m_sequence;
        private int m_fileType;
        private Object m_destination;
        private int m_nWritten;

        public WriteMidiFileWriterAction(Sequence sequence, int fileType, Object destination) {
            this.m_sequence = sequence;
            this.m_fileType = fileType;
            this.m_destination = destination;
            this.m_nWritten = -1;
        }

        public boolean handleMidiFileWriter(MidiFileWriter midiFileWriter) throws IOException {
            int nWritten = -1;
            if (!midiFileWriter.isFileTypeSupported(this.m_fileType)) {
                return false;
            }
            try {
                if (this.m_destination instanceof OutputStream) {
                    nWritten = midiFileWriter.write(this.m_sequence, this.m_fileType, (OutputStream)this.m_destination);
                } else if (this.m_destination instanceof File) {
                    nWritten = midiFileWriter.write(this.m_sequence, this.m_fileType, (File)this.m_destination);
                }
                this.m_nWritten = nWritten;
                return true;
            }
            catch (IllegalArgumentException e) {
                if (TDebug.TraceMidiSystem || TDebug.TraceAllExceptions) {
                    TDebug.out(e);
                }
                return false;
            }
        }

        public int getWritten() {
            return this.m_nWritten;
        }
    }
}

