/*
 * plist - An open source library to parse and generate property lists
 * Copyright (C) 2014 Daniel Dreibrodt
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.dd.plist;

/**
 * A PropertyListFormatException is thrown by the various property list format parsers
 * when an error in the format of the given property list is encountered.
 * @author Daniel Dreibrodt
 */
public class PropertyListFormatException extends Exception {

    /**
     * The location of the object that caused the exception.
     */
    private LocationInformation locationInformation;

    /**
     * Creates a new exception with the given message.
     * @param message A message containing information about the nature of the exception.
     */
    public PropertyListFormatException(String message) {
        this(message, (LocationInformation) null);
    }

    /**
     * Creates a new exception with the given message.
     * @param message A message containing information about the nature of the exception.
     * @param cause The original exception that caused this exception.
     */
    public PropertyListFormatException(String message, Throwable cause) {
        this(message, null, cause);
    }

    /**
     * Creates a new exception with the given message.
     * @param message A message containing information about the nature of the exception.
     * @param locationInformation The location of the element causing the exception.
     */
    PropertyListFormatException(String message, LocationInformation locationInformation) {
        super(message);
        this.locationInformation = locationInformation;
    }

    /**
     * Creates a new exception with the given message.
     * @param message A message containing information about the nature of the exception.
     * @param locationInformation The location of the element causing the exception.
     * @param cause The original exception that caused this exception.
     */
    PropertyListFormatException(String message, LocationInformation locationInformation, Throwable cause) {
        super(message, cause);
        this.locationInformation = locationInformation;
    }

    /**
     * The location of the element that caused the exception, if available.
     * @return The location information, if available.
     */
    public LocationInformation getLocationInformation() {
        return this.locationInformation;
    }

    void setLocationInformation(LocationInformation locationInformation) {
        this.locationInformation = locationInformation;
    }
}
