/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSSet;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import com.dd.plist.UID;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;

public class BinaryPropertyListParser {
    private byte[] bytes;
    private int offsetSize;
    private int objectRefSize;
    private int numObjects;
    private int topObject;
    private int offsetTableOffset;
    private int[] offsetTable;

    private BinaryPropertyListParser() {
    }

    public static NSObject parse(byte[] data) throws Exception {
        BinaryPropertyListParser parser = new BinaryPropertyListParser();
        return parser.doParse(data);
    }

    private NSObject doParse(byte[] data) throws Exception {
        this.bytes = data;
        String magic = new String(BinaryPropertyListParser.copyOfRange(this.bytes, 0, 8));
        if (!magic.startsWith("bplist")) {
            throw new Exception("The given data is no binary property list. Wrong magic bytes: " + magic);
        }
        byte[] trailer = BinaryPropertyListParser.copyOfRange(this.bytes, this.bytes.length - 32, this.bytes.length);
        this.offsetSize = (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(trailer, 6, 7));
        this.objectRefSize = (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(trailer, 7, 8));
        this.numObjects = (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(trailer, 8, 16));
        this.topObject = (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(trailer, 16, 24));
        this.offsetTableOffset = (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(trailer, 24, 32));
        this.offsetTable = new int[this.numObjects];
        for (int i = 0; i < this.numObjects; ++i) {
            byte[] offsetBytes = BinaryPropertyListParser.copyOfRange(this.bytes, this.offsetTableOffset + i * this.offsetSize, this.offsetTableOffset + (i + 1) * this.offsetSize);
            this.offsetTable[i] = (int)BinaryPropertyListParser.parseUnsignedInt(offsetBytes);
        }
        return this.parseObject(this.topObject);
    }

    public static NSObject parse(InputStream is) throws Exception {
        byte[] buf = PropertyListParser.readAll(is, Integer.MAX_VALUE);
        is.close();
        return BinaryPropertyListParser.parse(buf);
    }

    public static NSObject parse(File f) throws Exception {
        if (f.length() > Runtime.getRuntime().freeMemory()) {
            throw new Exception("To little heap space available! Wanted to read " + f.length() + " bytes, but only " + Runtime.getRuntime().freeMemory() + " are available.");
        }
        return BinaryPropertyListParser.parse(new FileInputStream(f));
    }

    private NSObject parseObject(int obj) throws Exception {
        int offset = this.offsetTable[obj];
        byte type = this.bytes[offset];
        int objType = (type & 0xF0) >> 4;
        int objInfo = type & 0xF;
        switch (objType) {
            case 0: {
                switch (objInfo) {
                    case 0: {
                        return null;
                    }
                    case 8: {
                        return new NSNumber(false);
                    }
                    case 9: {
                        return new NSNumber(true);
                    }
                    case 15: {
                        return null;
                    }
                }
                break;
            }
            case 1: {
                int length = (int)Math.pow(2.0, objInfo);
                if ((long)length < Runtime.getRuntime().freeMemory()) {
                    return new NSNumber(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 1, offset + 1 + length), 0);
                }
                throw new Exception("To little heap space available! Wanted to read " + length + " bytes, but only " + Runtime.getRuntime().freeMemory() + " are available.");
            }
            case 2: {
                int length = (int)Math.pow(2.0, objInfo);
                if ((long)length < Runtime.getRuntime().freeMemory()) {
                    return new NSNumber(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 1, offset + 1 + length), 1);
                }
                throw new Exception("To little heap space available! Wanted to read " + length + " bytes, but only " + Runtime.getRuntime().freeMemory() + " are available.");
            }
            case 3: {
                if (objInfo != 3) {
                    System.err.println("Unknown date type :" + objInfo + ". Parsing anyway...");
                }
                return new NSDate(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 1, offset + 9));
            }
            case 4: {
                int dataoffset = 1;
                int length = objInfo;
                if (objInfo == 15) {
                    byte int_type = this.bytes[offset + 1];
                    int intType = (int_type & 0xF0) / 15;
                    if (intType != 1) {
                        System.err.println("UNEXPECTED LENGTH-INT TYPE! " + intType);
                    }
                    int intInfo = int_type & 0xF;
                    int intLength = (int)Math.pow(2.0, intInfo);
                    dataoffset = 2 + intLength;
                    length = intLength < 3 ? (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + intLength)) : new BigInteger(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + intLength)).intValue();
                }
                if ((long)length < Runtime.getRuntime().freeMemory()) {
                    return new NSData(BinaryPropertyListParser.copyOfRange(this.bytes, offset + dataoffset, offset + dataoffset + length));
                }
                throw new Exception("To little heap space available! Wanted to read " + length + " bytes, but only " + Runtime.getRuntime().freeMemory() + " are available.");
            }
            case 5: {
                int length = objInfo;
                int stroffset = 1;
                if (objInfo == 15) {
                    byte int_type = this.bytes[offset + 1];
                    int intType = (int_type & 0xF0) / 15;
                    if (intType != 1) {
                        System.err.println("UNEXPECTED LENGTH-INT TYPE! " + intType);
                    }
                    int intInfo = int_type & 0xF;
                    int intLength = (int)Math.pow(2.0, intInfo);
                    stroffset = 2 + intLength;
                    length = intLength < 3 ? (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + intLength)) : new BigInteger(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + intLength)).intValue();
                }
                if ((long)length < Runtime.getRuntime().freeMemory()) {
                    return new NSString(BinaryPropertyListParser.copyOfRange(this.bytes, offset + stroffset, offset + stroffset + length), "ASCII");
                }
                throw new Exception("To little heap space available! Wanted to read " + length + " bytes, but only " + Runtime.getRuntime().freeMemory() + " are available.");
            }
            case 6: {
                int length = objInfo;
                int stroffset = 1;
                if (objInfo == 15) {
                    byte int_type = this.bytes[offset + 1];
                    int intType = (int_type & 0xF0) / 15;
                    if (intType != 1) {
                        System.err.println("UNEXPECTED LENGTH-INT TYPE! " + intType);
                    }
                    int intInfo = int_type & 0xF;
                    int intLength = (int)Math.pow(2.0, intInfo);
                    stroffset = 2 + intLength;
                    length = intLength < 3 ? (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + intLength)) : new BigInteger(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + intLength)).intValue();
                }
                if ((long)(length *= 2) < Runtime.getRuntime().freeMemory()) {
                    return new NSString(BinaryPropertyListParser.copyOfRange(this.bytes, offset + stroffset, offset + stroffset + length), "UTF-16BE");
                }
                throw new Exception("To little heap space available! Wanted to read " + length + " bytes, but only " + Runtime.getRuntime().freeMemory() + " are available.");
            }
            case 8: {
                int length = objInfo + 1;
                if ((long)length < Runtime.getRuntime().freeMemory()) {
                    return new UID(String.valueOf(obj), BinaryPropertyListParser.copyOfRange(this.bytes, offset + 1, offset + 1 + length));
                }
                throw new Exception("To little heap space available! Wanted to read " + length + " bytes, but only " + Runtime.getRuntime().freeMemory() + " are available.");
            }
            case 10: {
                int length = objInfo;
                int arrayoffset = 1;
                if (objInfo == 15) {
                    byte int_type = this.bytes[offset + 1];
                    int intType = (int_type & 0xF0) / 15;
                    if (intType != 1) {
                        System.err.println("UNEXPECTED LENGTH-INT TYPE! " + intType);
                    }
                    int intInfo = int_type & 0xF;
                    int intLength = (int)Math.pow(2.0, intInfo);
                    arrayoffset = 2 + intLength;
                    length = intLength < 3 ? (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + intLength)) : new BigInteger(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + intLength)).intValue();
                }
                if ((long)(length * this.objectRefSize) > Runtime.getRuntime().freeMemory()) {
                    throw new Exception("To little heap space available!");
                }
                NSArray array = new NSArray(length);
                for (int i = 0; i < length; ++i) {
                    int objRef = (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(this.bytes, offset + arrayoffset + i * this.objectRefSize, offset + arrayoffset + (i + 1) * this.objectRefSize));
                    array.setValue(i, this.parseObject(objRef));
                }
                return array;
            }
            case 12: {
                int length = objInfo;
                int arrayoffset = 1;
                if (objInfo == 15) {
                    byte int_type = this.bytes[offset + 1];
                    int intType = (int_type & 0xF0) / 15;
                    if (intType != 1) {
                        System.err.println("UNEXPECTED LENGTH-INT TYPE! " + intType);
                    }
                    int intInfo = int_type & 0xF;
                    int intLength = (int)Math.pow(2.0, intInfo);
                    arrayoffset = 2 + intLength;
                    length = intLength < 3 ? (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + intLength)) : new BigInteger(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + intLength)).intValue();
                }
                if ((long)(length * this.objectRefSize) > Runtime.getRuntime().freeMemory()) {
                    throw new Exception("To little heap space available!");
                }
                NSSet set = new NSSet();
                for (int i = 0; i < length; ++i) {
                    int objRef = (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(this.bytes, offset + arrayoffset + i * this.objectRefSize, offset + arrayoffset + (i + 1) * this.objectRefSize));
                    set.addObject(this.parseObject(objRef));
                }
                return set;
            }
            case 13: {
                int length = objInfo;
                int dictoffset = 1;
                if (objInfo == 15) {
                    byte int_type = this.bytes[offset + 1];
                    int intType = (int_type & 0xF0) / 15;
                    if (intType != 1) {
                        System.err.println("UNEXPECTED LENGTH-INT TYPE! " + intType);
                    }
                    int intInfo = int_type & 0xF;
                    int intLength = (int)Math.pow(2.0, intInfo);
                    dictoffset = 2 + intLength;
                    length = intLength < 3 ? (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + intLength)) : new BigInteger(BinaryPropertyListParser.copyOfRange(this.bytes, offset + 2, offset + 2 + intLength)).intValue();
                }
                if ((long)(length * 2 * this.objectRefSize) > Runtime.getRuntime().freeMemory()) {
                    throw new Exception("To little heap space available!");
                }
                NSDictionary dict = new NSDictionary();
                for (int i = 0; i < length; ++i) {
                    int keyRef = (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(this.bytes, offset + dictoffset + i * this.objectRefSize, offset + dictoffset + (i + 1) * this.objectRefSize));
                    int valRef = (int)BinaryPropertyListParser.parseUnsignedInt(BinaryPropertyListParser.copyOfRange(this.bytes, offset + dictoffset + length * this.objectRefSize + i * this.objectRefSize, offset + dictoffset + length * this.objectRefSize + (i + 1) * this.objectRefSize));
                    NSObject key = this.parseObject(keyRef);
                    NSObject val = this.parseObject(valRef);
                    dict.put(key.toString(), val);
                }
                return dict;
            }
            default: {
                System.err.println("Unknown object type: " + objType);
            }
        }
        return null;
    }

    public static final long parseUnsignedInt(byte[] bytes) {
        long l = 0L;
        for (byte b : bytes) {
            l <<= 8;
            l |= (long)(b & 0xFF);
        }
        return l &= 0xFFFFFFFFL;
    }

    public static final long parseLong(byte[] bytes) {
        long l = 0L;
        for (byte b : bytes) {
            l <<= 8;
            l |= (long)(b & 0xFF);
        }
        return l;
    }

    public static final double parseDouble(byte[] bytes) {
        if (bytes.length == 8) {
            return Double.longBitsToDouble(BinaryPropertyListParser.parseLong(bytes));
        }
        if (bytes.length == 4) {
            return Float.intBitsToFloat((int)BinaryPropertyListParser.parseLong(bytes));
        }
        throw new IllegalArgumentException("bad byte array length " + bytes.length);
    }

    public static byte[] copyOfRange(byte[] src, int startIndex, int endIndex) {
        int length = endIndex - startIndex;
        if (length < 0) {
            throw new IllegalArgumentException("startIndex (" + startIndex + ")" + " > endIndex (" + endIndex + ")");
        }
        byte[] dest = new byte[length];
        System.arraycopy(src, startIndex, dest, 0, length);
        return dest;
    }
}

