/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html.empiricism;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.owasp.html.HtmlElementTables;
import org.owasp.shim.Java8Shim;

public final class JsonToSerializedHtmlElementTables {
    private static final Map<String, HtmlElementTables.TextContentModelBit> MODEL_BITS = Java8Shim.j8().mapOfEntries(new Map.Entry[]{Java8Shim.j8().mapEntry((Object)"comments", (Object)HtmlElementTables.TextContentModelBit.COMMENTS), Java8Shim.j8().mapEntry((Object)"entities", (Object)HtmlElementTables.TextContentModelBit.ENTITIES), Java8Shim.j8().mapEntry((Object)"raw", (Object)HtmlElementTables.TextContentModelBit.RAW), Java8Shim.j8().mapEntry((Object)"text", (Object)HtmlElementTables.TextContentModelBit.TEXT), Java8Shim.j8().mapEntry((Object)"plain_text", (Object)HtmlElementTables.TextContentModelBit.PLAIN_TEXT), Java8Shim.j8().mapEntry((Object)"unended", (Object)HtmlElementTables.TextContentModelBit.UNENDED)});

    public static void main(String ... argv) throws IOException {
        JsonObject obj;
        if (argv.length > 2 || argv.length > 0 && !new File(argv[0]).isFile()) {
            System.err.println("Expected infile.js outfile.java");
            System.err.println();
            System.err.println("Converts canned.js to a serialized " + HtmlElementTables.class.getName());
            System.exit(1);
        }
        String infile = argv.length >= 1 ? argv[0] : "canned-data.json";
        String outfile = argv.length >= 2 ? argv[1] : "target/HtmlElementTablesCanned.java";
        try (FileInputStream in = new FileInputStream(infile);
             JsonReader reader = Json.createReader((InputStream)in);){
            obj = reader.readObject();
        }
        SourceLineWriter src = new SourceLineWriter();
        src.lines("package org.owasp.html;", "", "/** Generated by " + JsonToSerializedHtmlElementTables.class + " */", "final class HtmlElementTablesCanned {", "static final HtmlElementTables TABLES;", "static {");
        ArrayList<String> b = new ArrayList<String>();
        JsonArray arr = obj.getJsonArray("elementNames");
        int n = arr.size();
        for (int i = 0; i < n; ++i) {
            b.add(arr.getString(i));
        }
        List elementNameList = Java8Shim.j8().listCopyOf(b);
        HtmlElementTables.HtmlElementNames elementNames = new HtmlElementTables.HtmlElementNames(elementNameList);
        String[] elementNamesArr = elementNameList.toArray(new String[0]);
        src.lines("HtmlElementTables.HtmlElementNames elementNames", "= new HtmlElementTables.HtmlElementNames(");
        src.write(elementNamesArr);
        src.line(");");
        JsonToSerializedHtmlElementTables.newDenseElementBinaryMatrix(elementNames, obj.getJsonObject("canContain"), "canContain", src);
        JsonToSerializedHtmlElementTables.newDenseElementBinaryMatrix(elementNames, obj.getJsonObject("closedOnClose"), "closedOnClose", src);
        JsonToSerializedHtmlElementTables.newDenseElementBinaryMatrix(elementNames, obj.getJsonObject("closedOnOpen"), "closedOnOpen", src);
        JsonToSerializedHtmlElementTables.newSparseElementToElements(elementNames, obj.getJsonObject("explicitClosers"), "explicitClosers", src);
        JsonToSerializedHtmlElementTables.newSparseElementMultitable(elementNames, obj.getJsonObject("impliedElements"), "impliedElements", src);
        JsonToSerializedHtmlElementTables.newTextContentModel(elementNames, obj.getJsonObject("textContentModel"), "textContentModel", src);
        JsonToSerializedHtmlElementTables.newDenseElementSet(elementNames, obj.getJsonObject("resumable"), "resumable", src);
        src.lines("TABLES = new HtmlElementTables(", "elementNames,", "canContain,", "closedOnClose,", "closedOnOpen,", "explicitClosers,", "impliedElements,", "textContentModel,", "resumable);");
        src.lines("}", "}");
        try (FileOutputStream out = new FileOutputStream(outfile);
             OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
            w.write(src.getSource());
        }
    }

    private static void newTextContentModel(HtmlElementTables.HtmlElementNames elementNames, JsonObject tcmObj, String fieldName, SourceLineWriter src) {
        byte[] packedBits = new byte[elementNames.canonNames.size()];
        for (String key : tcmObj.keySet()) {
            int ei = elementNames.getElementNameIndex(key);
            byte b = 0;
            JsonObject bitsObj = tcmObj.getJsonObject(key);
            for (String bitKey : bitsObj.keySet()) {
                HtmlElementTables.TextContentModelBit mbit = MODEL_BITS.get(bitKey);
                if (bitsObj.getBoolean(bitKey)) {
                    b = (byte)(b | mbit.bitMask);
                    continue;
                }
                b = (byte)(b & ~mbit.bitMask);
            }
            packedBits[ei] = b;
        }
        src.lines("HtmlElementTables.TextContentModel " + fieldName + " = new HtmlElementTables.TextContentModel(");
        src.write(packedBits);
        src.line(");");
    }

    private static void newDenseElementBinaryMatrix(HtmlElementTables.HtmlElementNames en, JsonObject obj, String fieldName, SourceLineWriter src) {
        int dim = en.canonNames.size();
        boolean[] bits = new boolean[dim * dim];
        for (String elname : obj.keySet()) {
            int ai = en.getElementNameIndex(elname);
            JsonArray arr = obj.getJsonArray(elname);
            int n = arr.size();
            for (int i = 0; i < n; ++i) {
                int bi = en.getElementNameIndex(arr.getString(i));
                bits[ai * dim + bi] = true;
            }
        }
        src.lines("HtmlElementTables.DenseElementBinaryMatrix " + fieldName + " = new HtmlElementTables.DenseElementBinaryMatrix(");
        src.writePacked(bits);
        src.line(", " + dim + ");");
    }

    private static void newDenseElementSet(HtmlElementTables.HtmlElementNames en, JsonObject obj, String fieldName, SourceLineWriter src) {
        int dim = en.canonNames.size();
        boolean[] bits = new boolean[dim];
        for (String elname : obj.keySet()) {
            int i = en.getElementNameIndex(elname);
            bits[i] = obj.getBoolean(elname);
        }
        src.lines("HtmlElementTables.DenseElementSet " + fieldName + " = new HtmlElementTables.DenseElementSet(");
        src.writePacked(bits);
        src.lines(");");
    }

    private static void newSparseElementToElements(HtmlElementTables.HtmlElementNames en, JsonObject obj, String fieldName, SourceLineWriter src) {
        ArrayList<int[]> arrs = new ArrayList<int[]>();
        for (String elname : obj.keySet()) {
            int ei = en.getElementNameIndex(elname);
            LinkedHashSet<String> names = new LinkedHashSet<String>();
            JsonArray arr = obj.getJsonArray(elname);
            int n = arr.size();
            for (int i = 0; i < n; ++i) {
                names.add(arr.getString(i));
            }
            Set iset = Java8Shim.j8().setCopyOf(names);
            int[] vals = new int[iset.size()];
            int i = 0;
            for (String name : iset) {
                vals[i++] = en.getElementNameIndex(name);
            }
            if (vals.length != 3) {
                throw new IllegalStateException();
            }
            Arrays.sort(vals);
            int[] ints = new int[vals.length + 1];
            ints[0] = ei;
            System.arraycopy(vals, 0, ints, 1, vals.length);
            arrs.add(ints);
        }
        Collections.sort(arrs, new Comparator<int[]>(){

            @Override
            public int compare(int[] a, int[] b) {
                return Integer.compare(a[0], b[0]);
            }
        });
        int[][] arr = (int[][])arrs.toArray((T[])new int[arrs.size()][]);
        src.lines("HtmlElementTables.SparseElementToElements " + fieldName + " = new HtmlElementTables.SparseElementToElements(");
        src.write(arr);
        src.line(");");
    }

    private static void newSparseElementMultitable(HtmlElementTables.HtmlElementNames en, JsonObject obj, String fieldName, SourceLineWriter src) {
        int dim = en.canonNames.size();
        int[][][] arrs = new int[dim][][];
        for (String elname : obj.keySet()) {
            int ei = en.getElementNameIndex(elname);
            JsonObject subtable = obj.getJsonObject(elname);
            int[][] tableArr = new int[subtable.size()][];
            arrs[ei] = tableArr;
            int ti = 0;
            for (String elnameb : subtable.keySet()) {
                JsonArray els = subtable.getJsonArray(elnameb);
                int[] row = new int[els.size() + 1];
                row[0] = en.getElementNameIndex(elnameb);
                int n = els.size();
                for (int i = 0; i < n; ++i) {
                    row[i + 1] = en.getElementNameIndex(els.getString(i));
                }
                tableArr[ti++] = row;
            }
            Arrays.sort(tableArr, new Comparator<int[]>(){

                @Override
                public int compare(int[] o1, int[] o2) {
                    return o1[0] - o2[0];
                }
            });
        }
        src.lines("HtmlElementTables.SparseElementMultitable " + fieldName + " = new HtmlElementTables.SparseElementMultitable(");
        src.write(arrs);
        src.line(");");
    }

    static final class SourceLineWriter {
        final StringBuilder indent = new StringBuilder();
        final StringBuilder sb = new StringBuilder();

        SourceLineWriter() {
        }

        void lines(CharSequence ... lines) {
            for (CharSequence line : lines) {
                this.line(line);
            }
        }

        void line(CharSequence cs) {
            int n = cs.length();
            if (n != 0) {
                char c;
                int lt;
                for (lt = 0; lt < n && ((c = cs.charAt(lt)) == '}' || c == ')'); ++lt) {
                    this.indent.setLength(this.indent.length() - 2);
                }
                this.sb.append((CharSequence)this.indent);
                this.sb.append(cs);
                while (lt < n) {
                    c = cs.charAt(lt);
                    if (c == '{' || c == '(') {
                        this.indent.append(' ').append(' ');
                    } else if (c == '}' || c == ')') {
                        this.indent.setLength(this.indent.length() - 2);
                    }
                    ++lt;
                }
            }
            this.sb.append('\n');
        }

        void write(int[][] arr) {
            this.line("new int[][] {");
            this.writeEls(arr);
            this.line("}");
        }

        private void writeEls(int[][] arr) {
            int n = arr.length;
            for (int i = 0; i < n; ++i) {
                this.line("{");
                this.writeEls(arr[i]);
                this.line(i + 1 != n ? "}," : "}");
            }
        }

        void write(int[] arr) {
            this.line("new int[] {");
            this.writeEls(arr);
            this.line("}");
        }

        private void writeEls(int[] arr) {
            StringBuilder buf = new StringBuilder();
            int n = arr.length;
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    buf.append(',');
                    if (i % 16 == 0 && buf.length() != 0) {
                        this.line(buf);
                        buf.setLength(0);
                    } else {
                        buf.append(' ');
                    }
                }
                buf.append(arr[i]);
            }
            if (buf.length() != 0) {
                this.line(buf);
            }
        }

        private void writeEls(byte[] arr) {
            StringBuilder buf = new StringBuilder();
            int n = arr.length;
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    buf.append(',');
                    if (i % 16 == 0 && buf.length() != 0) {
                        this.line(buf);
                        buf.setLength(0);
                    } else {
                        buf.append(' ');
                    }
                }
                buf.append("(byte)").append(arr[i]);
            }
            if (buf.length() != 0) {
                this.line(buf);
            }
        }

        void writePacked(boolean[] arr) {
            int[] packed = new int[(arr.length + 31) / 32];
            int n = arr.length;
            for (int i = 0; i < n; ++i) {
                if (!arr[i]) continue;
                int n2 = i >> 5;
                packed[n2] = packed[n2] | 1 << (i & 0x1F);
            }
            boolean[] reunpacked = HtmlElementTables.unpack((int[])packed, (int)arr.length);
            if (!Arrays.equals(arr, reunpacked)) {
                throw new IllegalStateException();
            }
            this.line("HtmlElementTables.unpack(new int[] {");
            this.writeEls(packed);
            this.line("}, " + arr.length + ")");
        }

        void write(byte[] arr) {
            this.line("new byte[] {");
            this.writeEls(arr);
            this.line("}");
        }

        String getSource() {
            return this.sb.toString();
        }

        void write(int[][][] arrs) {
            this.line("new int[][][] {");
            int m = arrs.length;
            for (int j = 0; j < m; ++j) {
                int[][] arr = arrs[j];
                if (arr == null) {
                    this.line(j + 1 != m ? "null," : "null");
                    continue;
                }
                this.line("{");
                this.writeEls(arr);
                this.line(j + 1 != m ? "}," : "}");
            }
            this.line("}");
        }

        void write(String[] arr) {
            this.line("new String[] {");
            this.writeEls(arr);
            this.line("}");
        }

        private void writeEls(String[] arr) {
            StringBuilder buf = new StringBuilder();
            int n = arr.length;
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    buf.append(',');
                    if (i % 16 == 0 && buf.length() != 0) {
                        this.line(buf);
                        buf.setLength(0);
                    } else {
                        buf.append(' ');
                    }
                }
                String s = arr[i];
                buf.append('\"');
                int m = s.length();
                block8: for (int j = 0; j < m; ++j) {
                    char c = s.charAt(j);
                    switch (c) {
                        case '\n': {
                            buf.append("\\n");
                            continue block8;
                        }
                        case '\r': {
                            buf.append("\\r");
                            continue block8;
                        }
                        case '\\': {
                            buf.append("\\\\");
                            continue block8;
                        }
                        case '\"': {
                            buf.append("\\\"");
                            continue block8;
                        }
                        case '(': 
                        case ')': 
                        case '{': 
                        case '}': {
                            buf.append("\\u00");
                            buf.append(Integer.toHexString(c));
                            continue block8;
                        }
                        default: {
                            buf.append(c);
                        }
                    }
                }
                buf.append('\"');
            }
            if (buf.length() != 0) {
                this.line(buf);
            }
        }
    }
}

