/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal.cache;

import com.googlecode.download.maven.plugin.internal.cache.FileBackedIndex;
import com.googlecode.download.maven.plugin.internal.cache.FileIndex;
import com.googlecode.download.maven.plugin.internal.checksum.Checksums;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class DownloadCache {
    private final File basedir;
    private final FileIndex index;

    public DownloadCache(File cacheDirectory, Log log) {
        this.index = new FileBackedIndex(cacheDirectory, log);
        this.basedir = cacheDirectory;
    }

    private String getEntry(URI uri, Checksums checksums) {
        String res = this.index.get(uri);
        if (res == null) {
            return null;
        }
        File resFile = new File(this.basedir, res);
        if (resFile.isFile() && checksums.isValid(resFile)) {
            return res;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getArtifact(URI uri, Checksums checksums) {
        String res;
        this.index.getLock().lock();
        try {
            res = this.getEntry(uri, checksums);
        }
        finally {
            this.index.getLock().unlock();
        }
        if (res != null) {
            return new File(this.basedir, res);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(URI uri, File outputFile, Checksums checksums) throws MojoFailureException, IOException {
        if (!this.basedir.exists() && !this.basedir.mkdirs()) {
            throw new MojoFailureException("Could not create cache directory: " + this.basedir.getAbsolutePath());
        }
        this.index.getLock().lock();
        try {
            String entry = this.getEntry(uri, checksums);
            if (entry != null) {
                return;
            }
            String fileName = String.format("%s_%s", outputFile.getName(), DigestUtils.md5Hex((String)uri.toString()));
            Files.copy(outputFile.toPath(), new File(this.basedir, fileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.index.put(uri, fileName);
        }
        finally {
            this.index.getLock().unlock();
        }
    }
}

