/*
 * Decompiled with CFR 0.152.
 */
package com.google.i18n.phonenumbers.geocoding;

import com.google.i18n.phonenumbers.geocoding.AreaCodeMapStorageStrategy;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FlyweightMapStorage
extends AreaCodeMapStorageStrategy {
    private static final int SHORT_NUM_BYTES = 2;
    private static final int INT_NUM_BYTES = 4;
    private int prefixSizeInBytes;
    private int descIndexSizeInBytes;
    private ByteBuffer phoneNumberPrefixes;
    private ByteBuffer descriptionIndexes;
    private String[] descriptionPool;

    FlyweightMapStorage() {
    }

    @Override
    public int getPrefix(int index) {
        return FlyweightMapStorage.readWordFromBuffer(this.phoneNumberPrefixes, this.prefixSizeInBytes, index);
    }

    @Override
    public String getDescription(int index) {
        int indexInDescriptionPool = FlyweightMapStorage.readWordFromBuffer(this.descriptionIndexes, this.descIndexSizeInBytes, index);
        return this.descriptionPool[indexInDescriptionPool];
    }

    @Override
    public void readFromSortedMap(SortedMap<Integer, String> areaCodeMap) {
        TreeSet<String> descriptionsSet = new TreeSet<String>();
        this.numOfEntries = areaCodeMap.size();
        this.prefixSizeInBytes = FlyweightMapStorage.getOptimalNumberOfBytesForValue(areaCodeMap.lastKey());
        this.phoneNumberPrefixes = ByteBuffer.allocate(this.numOfEntries * this.prefixSizeInBytes);
        int index = 0;
        for (Map.Entry<Integer, String> entry : areaCodeMap.entrySet()) {
            int prefix = entry.getKey();
            FlyweightMapStorage.storeWordInBuffer(this.phoneNumberPrefixes, this.prefixSizeInBytes, index, prefix);
            this.possibleLengths.add((int)Math.log10(prefix) + 1);
            descriptionsSet.add(entry.getValue());
            ++index;
        }
        this.createDescriptionPool(descriptionsSet, areaCodeMap);
    }

    private void createDescriptionPool(SortedSet<String> descriptionsSet, SortedMap<Integer, String> areaCodeMap) {
        this.descIndexSizeInBytes = FlyweightMapStorage.getOptimalNumberOfBytesForValue(descriptionsSet.size() - 1);
        this.descriptionIndexes = ByteBuffer.allocate(this.numOfEntries * this.descIndexSizeInBytes);
        this.descriptionPool = new String[descriptionsSet.size()];
        descriptionsSet.toArray(this.descriptionPool);
        int index = 0;
        for (int i = 0; i < this.numOfEntries; ++i) {
            int prefix = FlyweightMapStorage.readWordFromBuffer(this.phoneNumberPrefixes, this.prefixSizeInBytes, i);
            String description = (String)areaCodeMap.get(prefix);
            int positionInDescriptionPool = Arrays.binarySearch(this.descriptionPool, description);
            FlyweightMapStorage.storeWordInBuffer(this.descriptionIndexes, this.descIndexSizeInBytes, index, positionInDescriptionPool);
            ++index;
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.prefixSizeInBytes = objectInput.readInt();
        this.descIndexSizeInBytes = objectInput.readInt();
        int sizeOfLengths = objectInput.readInt();
        this.possibleLengths.clear();
        for (int i = 0; i < sizeOfLengths; ++i) {
            this.possibleLengths.add(objectInput.readInt());
        }
        int descriptionPoolSize = objectInput.readInt();
        if (this.descriptionPool == null || this.descriptionPool.length < descriptionPoolSize) {
            this.descriptionPool = new String[descriptionPoolSize];
        }
        for (int i = 0; i < descriptionPoolSize; ++i) {
            String description;
            this.descriptionPool[i] = description = objectInput.readUTF();
        }
        this.readEntries(objectInput);
    }

    private void readEntries(ObjectInput objectInput) throws IOException {
        this.numOfEntries = objectInput.readInt();
        if (this.phoneNumberPrefixes == null || this.phoneNumberPrefixes.capacity() < this.numOfEntries) {
            this.phoneNumberPrefixes = ByteBuffer.allocate(this.numOfEntries * this.prefixSizeInBytes);
        }
        if (this.descriptionIndexes == null || this.descriptionIndexes.capacity() < this.numOfEntries) {
            this.descriptionIndexes = ByteBuffer.allocate(this.numOfEntries * this.descIndexSizeInBytes);
        }
        for (int i = 0; i < this.numOfEntries; ++i) {
            FlyweightMapStorage.readExternalWord(objectInput, this.prefixSizeInBytes, this.phoneNumberPrefixes, i);
            FlyweightMapStorage.readExternalWord(objectInput, this.descIndexSizeInBytes, this.descriptionIndexes, i);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.prefixSizeInBytes);
        objectOutput.writeInt(this.descIndexSizeInBytes);
        int sizeOfLengths = this.possibleLengths.size();
        objectOutput.writeInt(sizeOfLengths);
        for (Integer length : this.possibleLengths) {
            objectOutput.writeInt(length);
        }
        objectOutput.writeInt(this.descriptionPool.length);
        for (String description : this.descriptionPool) {
            objectOutput.writeUTF(description);
        }
        objectOutput.writeInt(this.numOfEntries);
        for (int i = 0; i < this.numOfEntries; ++i) {
            FlyweightMapStorage.writeExternalWord(objectOutput, this.prefixSizeInBytes, this.phoneNumberPrefixes, i);
            FlyweightMapStorage.writeExternalWord(objectOutput, this.descIndexSizeInBytes, this.descriptionIndexes, i);
        }
    }

    private static int getOptimalNumberOfBytesForValue(int value) {
        return value <= Short.MAX_VALUE ? 2 : 4;
    }

    private static void readExternalWord(ObjectInput objectInput, int wordSize, ByteBuffer outputBuffer, int index) throws IOException {
        int wordIndex = index * wordSize;
        if (wordSize == 2) {
            outputBuffer.putShort(wordIndex, objectInput.readShort());
        } else {
            outputBuffer.putInt(wordIndex, objectInput.readInt());
        }
    }

    private static void writeExternalWord(ObjectOutput objectOutput, int wordSize, ByteBuffer inputBuffer, int index) throws IOException {
        int wordIndex = index * wordSize;
        if (wordSize == 2) {
            objectOutput.writeShort(inputBuffer.getShort(wordIndex));
        } else {
            objectOutput.writeInt(inputBuffer.getInt(wordIndex));
        }
    }

    private static int readWordFromBuffer(ByteBuffer buffer, int wordSize, int index) {
        int wordIndex = index * wordSize;
        return wordSize == 2 ? buffer.getShort(wordIndex) : buffer.getInt(wordIndex);
    }

    private static void storeWordInBuffer(ByteBuffer buffer, int wordSize, int index, int value) {
        int wordIndex = index * wordSize;
        if (wordSize == 2) {
            buffer.putShort(wordIndex, (short)value);
        } else {
            buffer.putInt(wordIndex, value);
        }
    }
}

