/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mockit.internal.RedefinitionEngine;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.state.TestRun;
import mockit.internal.util.GeneratedClasses;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MockFixture {
    private final Map<String, byte[]> transformedClasses = new HashMap<String, byte[]>(2);
    private final Map<Class<?>, byte[]> redefinedClasses = new IdentityHashMap(8);
    private final Set<String> redefinedClassesWithNativeMethods = new HashSet<String>();
    private final Map<Class<?>, String> realClassesToMockClasses = new IdentityHashMap(8);
    private final List<Class<?>> mockedClasses = new ArrayList();
    private final Map<Class<?>, InstanceFactory> mockedTypesAndInstances = new IdentityHashMap();

    public void addTransformedClass(String className, byte[] pretransformClassfile) {
        this.transformedClasses.put(className, pretransformClassfile);
    }

    public void addRedefinedClass(String mockClassInternalName, Class<?> redefinedClass, byte[] modifiedClassfile) {
        String previousNames;
        if (mockClassInternalName != null && (previousNames = this.realClassesToMockClasses.put(redefinedClass, mockClassInternalName)) != null) {
            this.realClassesToMockClasses.put(redefinedClass, previousNames + ' ' + mockClassInternalName);
        }
        this.addRedefinedClass(redefinedClass, modifiedClassfile);
    }

    public void addRedefinedClass(Class<?> redefinedClass, byte[] modifiedClassfile) {
        this.redefinedClasses.put(redefinedClass, modifiedClassfile);
    }

    public void registerMockedClass(Class<?> mockedType) {
        if (!this.mockedClasses.contains(mockedType) && !GeneratedClasses.isGeneratedImplementationClass(mockedType)) {
            this.mockedClasses.add(mockedType);
        }
    }

    public boolean isInstanceOfMockedClass(Object mockedInstance) {
        Class<?> mockedClass = mockedInstance.getClass();
        int n = this.mockedClasses.size();
        for (int i = 0; i < n; ++i) {
            Class<?> mockedType = this.mockedClasses.get(i);
            if (mockedType != mockedClass && !mockedType.isAssignableFrom(mockedClass)) continue;
            return true;
        }
        return false;
    }

    public void registerInstanceFactoryForMockedType(Class<?> mockedType, InstanceFactory mockedInstanceFactory) {
        this.registerMockedClass(mockedType);
        this.mockedTypesAndInstances.put(mockedType, mockedInstanceFactory);
    }

    public InstanceFactory findInstanceFactory(Class<?> mockedType) {
        if (mockedType.isInterface() || Modifier.isAbstract(mockedType.getModifiers())) {
            for (Map.Entry<Class<?>, InstanceFactory> entry : this.mockedTypesAndInstances.entrySet()) {
                Class baseType = GeneratedClasses.getMockedClassOrInterfaceType(entry.getKey());
                if (baseType != mockedType) continue;
                return entry.getValue();
            }
            return null;
        }
        return this.mockedTypesAndInstances.get(mockedType);
    }

    public void restoreAndRemoveRedefinedClasses(Set<Class<?>> desiredClasses) {
        Set<Class<?>> classesToRestore = desiredClasses == null ? this.redefinedClasses.keySet() : desiredClasses;
        RedefinitionEngine redefinitionEngine = new RedefinitionEngine();
        for (Class<?> redefinedClass : classesToRestore) {
            redefinitionEngine.restoreOriginalDefinition(redefinedClass);
            this.restoreDefinition(redefinedClass);
            this.discardStateForCorrespondingMockClassIfAny(redefinedClass);
        }
        if (desiredClasses == null) {
            this.redefinedClasses.clear();
        } else {
            this.redefinedClasses.keySet().removeAll(desiredClasses);
        }
    }

    private void restoreDefinition(Class<?> redefinedClass) {
        if (this.redefinedClassesWithNativeMethods.contains(redefinedClass.getName())) {
            this.reregisterNativeMethodsForRestoredClass(redefinedClass);
        }
        this.mockedTypesAndInstances.remove(redefinedClass);
        this.mockedClasses.remove(redefinedClass);
    }

    private void discardStateForCorrespondingMockClassIfAny(Class<?> redefinedClass) {
        String mockClassesInternalNames = this.realClassesToMockClasses.remove(redefinedClass);
        TestRun.getMockClasses().getMockStates().removeClassState(redefinedClass, mockClassesInternalNames);
    }

    void restoreTransformedClasses(Set<String> previousTransformedClasses) {
        if (!this.transformedClasses.isEmpty()) {
            Set<String> classesToRestore;
            if (previousTransformedClasses.isEmpty()) {
                classesToRestore = this.transformedClasses.keySet();
            } else {
                classesToRestore = this.getTransformedClasses();
                classesToRestore.removeAll(previousTransformedClasses);
            }
            if (!classesToRestore.isEmpty()) {
                this.restoreAndRemoveTransformedClasses(classesToRestore);
            }
        }
    }

    private void restoreAndRemoveTransformedClasses(Set<String> classesToRestore) {
        RedefinitionEngine redefinitionEngine = new RedefinitionEngine();
        for (String transformedClassName : classesToRestore) {
            byte[] definitionToRestore = this.transformedClasses.get(transformedClassName);
            redefinitionEngine.restoreToDefinition(transformedClassName, definitionToRestore);
        }
        this.transformedClasses.keySet().removeAll(classesToRestore);
    }

    void restoreRedefinedClasses(Map<?, byte[]> previousDefinitions) {
        RedefinitionEngine redefinitionEngine = new RedefinitionEngine();
        Iterator<Map.Entry<Class<?>, byte[]>> itr = this.redefinedClasses.entrySet().iterator();
        while (itr.hasNext()) {
            byte[] previousDefinition;
            Map.Entry<Class<?>, byte[]> entry = itr.next();
            Class<?> redefinedClass = entry.getKey();
            byte[] currentDefinition = entry.getValue();
            if (currentDefinition == (previousDefinition = previousDefinitions.get(redefinedClass))) continue;
            redefinitionEngine.restoreDefinition(redefinedClass, previousDefinition);
            if (previousDefinition == null) {
                this.restoreDefinition(redefinedClass);
                this.discardStateForCorrespondingMockClassIfAny(redefinedClass);
                itr.remove();
                continue;
            }
            entry.setValue(previousDefinition);
        }
    }

    public void addRedefinedClassWithNativeMethods(String redefinedClassInternalName) {
        this.redefinedClassesWithNativeMethods.add(redefinedClassInternalName.replace('/', '.'));
    }

    private void reregisterNativeMethodsForRestoredClass(Class<?> realClass) {
        Method registerNatives = null;
        try {
            registerNatives = realClass.getDeclaredMethod("registerNatives", new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            try {
                registerNatives = realClass.getDeclaredMethod("initIDs", new Class[0]);
            }
            catch (NoSuchMethodException alsoIgnore) {
                // empty catch block
            }
        }
        if (registerNatives != null) {
            try {
                registerNatives.setAccessible(true);
                registerNatives.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException ignore) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public Set<String> getTransformedClasses() {
        return new HashSet<String>(this.transformedClasses.keySet());
    }

    public Map<Class<?>, byte[]> getRedefinedClasses() {
        return new HashMap(this.redefinedClasses);
    }

    public int getRedefinedClassCount() {
        return this.redefinedClasses.size();
    }

    public byte[] getRedefinedClassfile(Class<?> redefinedClass) {
        return this.redefinedClasses.get(redefinedClass);
    }

    public boolean containsRedefinedClass(Class<?> redefinedClass) {
        return this.redefinedClasses.containsKey(redefinedClass);
    }
}

