/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.pathCoverage;

import java.io.PrintWriter;
import java.util.List;
import mockit.coverage.paths.Node;
import mockit.coverage.paths.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PathCoverageFormatter {
    private final PrintWriter output;
    private final StringBuilder lineSegmentIds;
    private char pathId1;
    private char pathId2;

    PathCoverageFormatter(PrintWriter output) {
        this.output = output;
        this.lineSegmentIds = new StringBuilder(100);
    }

    void writeInformationForEachPath(List<Path> paths) {
        this.pathId1 = (char)65;
        this.pathId2 = '\u0000';
        for (Path path : paths) {
            this.writeCoverageInfoForIndividualPath(path);
            if (this.pathId2 == '\u0000' && this.pathId1 < 'Z') {
                this.pathId1 = (char)(this.pathId1 + '\u0001');
                continue;
            }
            if (this.pathId2 == '\u0000') {
                this.pathId1 = (char)65;
                this.pathId2 = (char)65;
                continue;
            }
            if (this.pathId2 < 'Z') {
                this.pathId2 = (char)(this.pathId2 + '\u0001');
                continue;
            }
            this.pathId1 = (char)(this.pathId1 + '\u0001');
            this.pathId2 = (char)65;
        }
    }

    private void writeCoverageInfoForIndividualPath(Path path) {
        int executionCount = path.getExecutionCount();
        String lineSegmentIdsForPath = this.getIdsForLineSegmentsBelongingToThePath(path);
        this.output.write("        <span class='");
        this.output.write(executionCount == 0 ? "uncovered" : "covered");
        this.output.write("' onclick=\"showPath(this,'");
        this.output.write(lineSegmentIdsForPath);
        this.output.write("')\">");
        this.writePathId();
        this.output.write(": ");
        this.output.print(executionCount);
        this.output.println("</span>");
    }

    private String getIdsForLineSegmentsBelongingToThePath(Path path) {
        this.lineSegmentIds.setLength(0);
        int previousLine = 0;
        int previousSegment = 0;
        for (Node node : path.getNodes()) {
            int line = node.line;
            int segment = node.getSegment();
            if (line > previousLine) {
                this.appendSegmentId(line, segment);
                previousLine = line;
            } else if (segment > previousSegment) {
                this.appendSegmentId(line, segment);
            }
            previousSegment = segment;
        }
        return this.lineSegmentIds.toString();
    }

    private void appendSegmentId(int line, int segment) {
        if (this.lineSegmentIds.length() > 0) {
            this.lineSegmentIds.append(' ');
        }
        this.lineSegmentIds.append('l').append(line).append('s').append(segment);
    }

    private void writePathId() {
        this.output.write(this.pathId1);
        if (this.pathId2 != '\u0000') {
            this.output.write(this.pathId2);
        }
    }
}

