/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.packages;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mockit.coverage.Metrics;
import mockit.coverage.data.FileCoverageData;
import mockit.coverage.data.PerFileCoverage;
import mockit.coverage.reporting.packages.ListWithFilesAndPercentages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PackageCoverageReport
extends ListWithFilesAndPercentages {
    private final Map<String, FileCoverageData> filesToFileData;
    private final Collection<String> sourceFilesNotFound;
    private final char[] fileNameWithSpaces;
    private String filePath;

    PackageCoverageReport(PrintWriter output, Collection<String> sourceFilesNotFound, Map<String, FileCoverageData> filesToFileData, Collection<List<String>> allSourceFileNames) {
        super(output, "          ");
        this.sourceFilesNotFound = sourceFilesNotFound;
        this.filesToFileData = filesToFileData;
        this.fileNameWithSpaces = new char[this.maximumSourceFileNameLength(allSourceFileNames)];
    }

    private int maximumSourceFileNameLength(Collection<List<String>> allSourceFileNames) {
        int maxLength = 0;
        for (List<String> files : allSourceFileNames) {
            for (String fileName : files) {
                int n = fileName.length();
                if (n <= maxLength) continue;
                maxLength = n;
            }
        }
        return maxLength;
    }

    @Override
    protected void writeMetricsForFile(String packageName, String fileName) {
        this.filePath = packageName.length() == 0 ? fileName : packageName + '/' + fileName;
        final FileCoverageData fileData = this.filesToFileData.get(this.filePath);
        this.writeRowStart();
        this.printIndent();
        this.output.write("  <td class='file ");
        this.output.write(fileData.kindOfTopLevelType);
        this.output.write("'>");
        int fileNameLength = this.buildFileNameWithTrailingSpaces(fileName);
        this.writeTableCellWithFileName(fileNameLength);
        Metrics.performAction(new Metrics.Action(){

            public void perform(Metrics metric) {
                PackageCoverageReport.this.writeCodeCoverageMetricForFile(metric, fileData.getPerFileCoverage(metric));
            }
        });
        this.writeRowClose();
    }

    private int buildFileNameWithTrailingSpaces(String fileName) {
        int n = fileName.length();
        fileName.getChars(0, n, this.fileNameWithSpaces, 0);
        Arrays.fill(this.fileNameWithSpaces, n, this.fileNameWithSpaces.length, ' ');
        return n;
    }

    private void writeTableCellWithFileName(int fileNameLen) {
        if (this.sourceFilesNotFound == null || this.sourceFilesNotFound.contains(this.filePath)) {
            this.output.write(this.fileNameWithSpaces);
        } else {
            this.output.write("<a target='_blank' href='");
            int p = this.filePath.lastIndexOf(46);
            this.output.write(this.filePath.substring(0, p));
            this.output.write(".html'>");
            this.output.write(this.fileNameWithSpaces, 0, fileNameLen);
            this.output.write("</a>");
            this.output.write(this.fileNameWithSpaces, fileNameLen, this.fileNameWithSpaces.length - fileNameLen);
        }
        this.output.println("</td>");
    }

    private void writeCodeCoverageMetricForFile(Metrics metric, PerFileCoverage coverageInfo) {
        int percentage = coverageInfo.getCoveragePercentage();
        int covered = coverageInfo.getCoveredItems();
        int total = coverageInfo.getTotalItems();
        int n = metric.ordinal();
        this.coveredItems[n] = this.coveredItems[n] + covered;
        int n2 = metric.ordinal();
        this.totalItems[n2] = this.totalItems[n2] + total;
        this.printCoveragePercentage(metric, covered, total, percentage);
    }

    @Override
    protected void writeClassAttributeForCoveragePercentageCell() {
    }
}

