/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.packages;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mockit.coverage.CoveragePercentage;
import mockit.coverage.Metrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ListWithFilesAndPercentages {
    protected final PrintWriter output;
    private final String baseIndent;
    final int[] totalItems = new int[Metrics.values().length];
    final int[] coveredItems = new int[Metrics.values().length];

    protected ListWithFilesAndPercentages(PrintWriter output, String baseIndent) {
        this.output = output;
        this.baseIndent = baseIndent;
    }

    final void writeMetricsForEachFile(String packageName, List<String> fileNames) {
        if (fileNames.isEmpty()) {
            return;
        }
        Collections.sort(fileNames);
        Arrays.fill(this.totalItems, 0);
        Arrays.fill(this.coveredItems, 0);
        for (String fileName : fileNames) {
            this.writeMetricsForFile(packageName, fileName);
        }
    }

    protected final void writeRowStart() {
        this.printIndent();
        this.output.println("<tr>");
    }

    protected final void writeRowClose() {
        this.printIndent();
        this.output.println("</tr>");
    }

    final void printIndent() {
        this.output.write(this.baseIndent);
    }

    protected abstract void writeMetricsForFile(String var1, String var2);

    final void printCoveragePercentage(Metrics metric, int covered, int total, int percentage) {
        this.printIndent();
        this.output.write("  <td ");
        if (total > 0) {
            this.writeRowCellWithCoveragePercentage(metric, covered, total, percentage);
        } else {
            this.output.write("class='nocode'>N/A");
        }
        this.output.println("</td>");
    }

    private void writeRowCellWithCoveragePercentage(Metrics metric, int covered, int total, int percentage) {
        this.writeClassAttributeForCoveragePercentageCell();
        this.output.write("style='background-color:#");
        this.output.write(CoveragePercentage.percentageColor(covered, total));
        this.output.write("' title='");
        this.output.write(metric.itemName());
        this.output.write(": ");
        this.output.print(covered);
        this.output.write(47);
        this.output.print(total);
        this.output.write("'>");
        this.writePercentageValue(covered, total, percentage);
        this.output.print("%");
    }

    protected abstract void writeClassAttributeForCoveragePercentageCell();

    private void writePercentageValue(int covered, int total, int percentage) {
        if (percentage < 100) {
            this.output.print(percentage);
        } else if (covered == total) {
            this.output.print("100");
        } else {
            this.output.print(">99");
        }
    }
}

