/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.lineCoverage;

import java.util.List;
import mockit.coverage.lines.BranchCoverageData;
import mockit.coverage.lines.LineCoverageData;
import mockit.coverage.lines.LineSegmentData;
import mockit.coverage.reporting.ListOfCallPoints;
import mockit.coverage.reporting.parsing.LineElement;
import mockit.coverage.reporting.parsing.LineParser;

final class LineSegmentsFormatter {
    private final ListOfCallPoints listOfCallPoints;
    private final StringBuilder line;
    private int lineNumber;
    private LineElement element;
    private int segmentIndex;
    private LineSegmentData segmentData;

    LineSegmentsFormatter(boolean withCallPoints, StringBuilder line) {
        this.listOfCallPoints = withCallPoints ? new ListOfCallPoints() : null;
        this.line = line;
    }

    void formatSegments(LineParser lineParser, LineCoverageData lineData) {
        this.lineNumber = lineParser.getNumber();
        List<BranchCoverageData> branchData = lineData.getBranches();
        int numSegments = 1 + branchData.size();
        this.element = lineParser.getInitialElement().appendUntilNextCodeElement(this.line);
        this.segmentIndex = 0;
        this.segmentData = lineData;
        this.appendUntilFirstElementAfterNextBranchingPoint();
        this.segmentIndex = 1;
        while (this.element != null && this.segmentIndex < numSegments) {
            this.segmentData = branchData.get(this.segmentIndex - 1);
            this.element = this.element.appendUntilNextCodeElement(this.line);
            this.appendUntilFirstElementAfterNextBranchingPoint();
            ++this.segmentIndex;
        }
        this.line.append("</pre>");
        if (this.hasCallPointsForSegment()) {
            this.line.append(this.listOfCallPoints.getContents());
        }
    }

    private void appendUntilFirstElementAfterNextBranchingPoint() {
        if (this.element != null) {
            LineElement firstElement = this.element;
            this.element = this.element.findNextBranchingPoint();
            this.appendToFormattedLine(firstElement);
            if (this.element != null && this.element.isBranchingElement()) {
                this.line.append(this.element.getText());
                this.element = this.element.getNext();
            }
        }
    }

    private void appendToFormattedLine(LineElement firstElement) {
        if (firstElement == this.element) {
            return;
        }
        this.appendStartTag();
        firstElement.appendAllBefore(this.line, this.element);
        this.appendEndTag();
    }

    private void appendStartTag() {
        this.line.append("<span id='l").append(this.lineNumber).append('s').append(this.segmentIndex).append("' ");
        this.appendTooltipWithExecutionCounts();
        if (this.segmentData.isCovered()) {
            this.line.append("class='covered");
            if (this.hasCallPointsForSegment()) {
                this.line.append(" cp' onclick='showHide(this,").append(this.segmentIndex).append(')');
            }
            this.line.append("'>");
        } else {
            this.line.append("class='uncovered'>");
        }
    }

    private void appendTooltipWithExecutionCounts() {
        this.line.append("title='Executions: ").append(this.segmentData.getExecutionCount()).append("' ");
    }

    private void appendEndTag() {
        int i = this.line.length() - 1;
        while (Character.isWhitespace(this.line.charAt(i))) {
            --i;
        }
        this.line.insert(i + 1, "</span>");
        if (this.hasCallPointsForSegment()) {
            this.listOfCallPoints.insertListOfCallPoints(this.segmentData.getCallPoints());
        }
    }

    private boolean hasCallPointsForSegment() {
        return this.listOfCallPoints != null && this.segmentData.containsCallPoints();
    }
}

