/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.CodeSource;

final class StaticFiles {
    private final String outputDir;
    private long lastModifiedTimeOfCoverageJar;

    StaticFiles(String outputDir) {
        this.outputDir = outputDir;
    }

    void copyToOutputDir(boolean forSourceFilePages) throws IOException {
        this.copyFile("coverage.css");
        this.copyFile("coverage.js");
        this.copyFile("logo.png");
        this.copyFile("package.png");
        this.copyFile("class.png");
        this.copyFile("abstractClass.png");
        this.copyFile("interface.png");
        this.copyFile("annotation.png");
        this.copyFile("exception.png");
        this.copyFile("enum.png");
        if (forSourceFilePages) {
            this.copyFile("prettify.js");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String fileName) throws IOException {
        File outputFile = new File(this.outputDir, fileName);
        if (outputFile.exists() && outputFile.lastModified() > this.getLastModifiedTimeOfCoverageJar()) {
            return;
        }
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile));
        BufferedInputStream input = new BufferedInputStream(StaticFiles.class.getResourceAsStream(fileName));
        try {
            int b;
            while ((b = ((InputStream)input).read()) != -1) {
                ((OutputStream)output).write(b);
            }
        }
        finally {
            try {
                ((InputStream)input).close();
            }
            finally {
                ((OutputStream)output).close();
            }
        }
    }

    private long getLastModifiedTimeOfCoverageJar() {
        if (this.lastModifiedTimeOfCoverageJar == 0L) {
            CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                this.lastModifiedTimeOfCoverageJar = -1L;
            } else {
                String pathToThisJar = codeSource.getLocation().getPath();
                this.lastModifiedTimeOfCoverageJar = new File(pathToThisJar).lastModified();
            }
        }
        return this.lastModifiedTimeOfCoverageJar;
    }
}

