/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourceFiles {
    private final List<File> srcDirs = new ArrayList<File>();

    SourceFiles() {
    }

    List<File> buildListOfSourceDirectories(String[] sourceDirs) {
        if (sourceDirs.length > 0) {
            this.buildListWithSpecifiedDirectories(sourceDirs);
        } else {
            this.buildListWithAllSrcSubDirectories();
        }
        return this.srcDirs;
    }

    private void buildListWithSpecifiedDirectories(String[] dirs) {
        for (String dir : dirs) {
            File srcDir = new File(dir);
            if (!srcDir.isDirectory()) continue;
            this.srcDirs.add(srcDir);
        }
        if (this.srcDirs.isEmpty()) {
            throw new IllegalStateException("None of the specified source directories exist");
        }
    }

    private void buildListWithAllSrcSubDirectories() {
        String curDirName = new File(System.getProperty("user.dir")).getName();
        this.addSrcSubDirs(new File("../" + curDirName));
    }

    private void addSrcSubDirs(File dir) {
        for (File subDir : dir.listFiles()) {
            if (!subDir.isDirectory()) continue;
            if ("src".equals(subDir.getName())) {
                this.srcDirs.add(subDir);
                continue;
            }
            this.addSrcSubDirs(subDir);
        }
    }
}

