/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;

public final class OutputFile
extends PrintWriter {
    private static final Pattern PATH_SEPARATOR = Pattern.compile("/");
    private final String relPathToOutDir;
    private final boolean withPrettyPrint;

    public OutputFile(File file) throws IOException {
        super(new FileWriter(file));
        this.relPathToOutDir = "";
        this.withPrettyPrint = false;
    }

    public OutputFile(String outputDir, String sourceFilePath) throws IOException {
        super(new FileWriter(OutputFile.getOutputFileCreatingDirIfNeeded(outputDir, sourceFilePath)));
        this.relPathToOutDir = OutputFile.getRelativeSubPathToOutputDir(sourceFilePath);
        this.withPrettyPrint = true;
    }

    private static File getOutputFileCreatingDirIfNeeded(String outputDir, String sourceFilePath) {
        int p = sourceFilePath.lastIndexOf(46);
        String outputFileName = sourceFilePath.substring(0, p) + ".html";
        File outputFile = new File(outputDir, outputFileName);
        File parentDir = outputFile.getParentFile();
        if (!parentDir.exists()) {
            boolean outputDirCreated = parentDir.mkdirs();
            assert (outputDirCreated) : "Failed to create output dir: " + outputDir;
        }
        return outputFile;
    }

    private static String getRelativeSubPathToOutputDir(String filePath) {
        StringBuilder cssRelPath = new StringBuilder();
        int n = PATH_SEPARATOR.split(filePath).length;
        for (int i = 1; i < n; ++i) {
            cssRelPath.append("../");
        }
        return cssRelPath.toString();
    }

    public void writeCommonHeader(String subTitle) {
        String titleSuffix = subTitle == null ? "" : " - " + subTitle;
        this.println("<!DOCTYPE html>");
        this.println("<html>");
        this.println("<head>");
        this.println("  <title>JMockit Coverage Report" + titleSuffix + "</title>");
        this.println("  <meta http-equiv='Content-Type' content='text/html; charset=UTF-8'/>");
        this.println("  <link rel='stylesheet' type='text/css' href='" + this.relPathToOutDir + "coverage.css'/>");
        this.println("  <link rel='shortcut icon' type='image/png' href='" + this.relPathToOutDir + "logo.png'/>");
        this.println("  <script type='text/javascript' src='" + this.relPathToOutDir + "coverage.js'></script>");
        if (this.withPrettyPrint) {
            this.println("  <script type='text/javascript' src='" + this.relPathToOutDir + "prettify.js'></script>");
        }
        this.println("</head>");
        this.println(this.withPrettyPrint ? "<body onload='prettyPrint()'>" : "<body>");
    }

    public void writeCommonFooter() {
        this.println("</body>");
        this.println("</html>");
    }
}

