/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting;

import java.util.List;
import mockit.coverage.CallPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListOfCallPoints {
    private static final String EOL = System.getProperty("line.separator");
    private final StringBuilder content = new StringBuilder(100);
    private int n;

    public void insertListOfCallPoints(List<CallPoint> callPoints) {
        if (this.content.length() == 0) {
            this.content.append(EOL).append("      ");
        }
        this.content.append("  <ol style='display: none'>").append(EOL);
        this.n = 1;
        StackTraceElement previous = null;
        for (CallPoint callPoint : callPoints) {
            StackTraceElement current = callPoint.getStackTraceElement();
            if (previous == null) {
                this.appendTestMethod(current);
            } else if (!this.isSameTestMethod(current, previous)) {
                this.appendRepetitionCountIfAny();
                this.content.append("</li>").append(EOL);
                this.appendTestMethod(current);
            } else if (current.getLineNumber() == previous.getLineNumber()) {
                ++this.n;
            } else {
                this.appendRepetitionCountIfAny();
                this.content.append(", ").append(current.getLineNumber());
            }
            previous = current;
        }
        this.content.append("</li>").append(EOL).append("        </ol>").append(EOL).append("      ");
    }

    private void appendTestMethod(StackTraceElement current) {
        this.content.append("          <li>");
        this.content.append(current.getClassName()).append('#');
        this.content.append(current.getMethodName().replaceFirst("<", "&lt;")).append(": ");
        this.content.append(current.getLineNumber());
    }

    private void appendRepetitionCountIfAny() {
        if (this.n > 1) {
            this.content.append('x').append(this.n);
            this.n = 1;
        }
    }

    private boolean isSameTestMethod(StackTraceElement ste1, StackTraceElement ste2) {
        return ste1 == ste2 || ste1.getClassName().equals(ste2.getClassName()) && ste1.getMethodName().equals(ste2.getMethodName());
    }

    public String getContents() {
        String result = this.content.toString();
        this.content.setLength(0);
        return result;
    }
}

